/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.Optional;

public class EphemeralSettingsViewModel {
    private Optional<OutboundMessageEphemeralInfo> draftEphemeralInfo;
    private JsonExpiration discussionJsonExpiration;
    private boolean readOnce = false;
    private Long visibility = null;
    private Long existence = null;
    private final MutableLiveData<Boolean> draftLoaded = new MutableLiveData<Boolean>(false);
    private final MutableLiveData<Boolean> valid = new MutableLiveData<Boolean>(false);
    private final Discussion discussion;
    private final LiveDataListener<DiscussionCustomization> discussionCustomizationLiveDataListener = this::onDiscussionCustomizationChanged;
    private final LiveDataListener<Discussion> discussionLiveDataListener = this::selectedDiscussionChanged;
    private final LiveData<DiscussionCustomization> discussionCustomizationLiveData;

    public EphemeralSettingsViewModel(LiveData<Discussion> selectedDiscussion) {
        this.discussion = selectedDiscussion.getValue();
        this.discussionCustomizationLiveData = LiveDataFactory.switchMap(selectedDiscussion, discussion -> {
            if (discussion != null) {
                return LiveDataFactory.buildDbLiveDataItem(DiscussionCustomization.class, () -> DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId()));
            }
            return null;
        });
        this.discussionCustomizationLiveData.addListener(this.discussionCustomizationLiveDataListener);
        selectedDiscussion.addListener(this.discussionLiveDataListener);
    }

    public MutableLiveData<Boolean> getValid() {
        return this.valid;
    }

    public boolean isReadOnce() {
        return this.readOnce;
    }

    public void setReadOnce(boolean readOnce) {
        this.readOnce = readOnce;
        this.checkValid();
    }

    public Long getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Long visibility) {
        this.visibility = visibility;
        this.checkValid();
    }

    public Long getExistence() {
        return this.existence;
    }

    public void setExistence(Long existence) {
        this.existence = existence;
        this.checkValid();
    }

    public Optional<OutboundMessageEphemeralInfo> getDraftEphemeralInfo() {
        return this.draftEphemeralInfo;
    }

    public JsonExpiration getDiscussionJsonExpiration() {
        return this.discussionJsonExpiration;
    }

    public MutableLiveData<Boolean> getDraftLoaded() {
        return this.draftLoaded;
    }

    public Discussion getDiscussion() {
        return this.discussion;
    }

    private void onDiscussionCustomizationChanged(DiscussionCustomization newValue, DiscussionCustomization oldValue) {
        this.discussionJsonExpiration = newValue != null ? newValue.getExpirationJson() : null;
        this.checkValid();
    }

    private void selectedDiscussionChanged(Discussion newValue, Discussion oldValue) {
        this.draftLoaded.postValue(false);
        this.draftEphemeralInfo = Optional.empty();
        if (newValue == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            Optional<OutboundMessage> draftMessage = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)newValue.getItemId());
            if (draftMessage.isPresent()) {
                this.draftEphemeralInfo = DbManager.getInstance().getOutboundMessageDao().getEphemeralInfo(draftMessage.get());
            }
            this.draftLoaded.postValue(true);
        });
    }

    private void checkValid() {
        boolean valid;
        boolean bl = valid = !(this.visibility != null && this.visibility <= 0L || this.existence != null && this.existence <= 0L);
        if (this.discussionJsonExpiration != null) {
            if (this.discussionJsonExpiration.getReadOnce() != null && this.discussionJsonExpiration.getReadOnce().booleanValue()) {
                valid &= this.readOnce;
            }
            if (this.discussionJsonExpiration.getVisibilityDuration() != null) {
                valid &= this.visibility != null && this.visibility <= this.discussionJsonExpiration.getVisibilityDuration();
            }
            if (this.discussionJsonExpiration.getExistenceDuration() != null) {
                valid &= this.existence != null && this.existence <= this.discussionJsonExpiration.getExistenceDuration();
            }
        }
        this.valid.postValue(valid);
    }

    public void reset() {
        if (this.discussionJsonExpiration == null) {
            this.readOnce = false;
            this.visibility = null;
            this.existence = null;
        } else {
            this.readOnce = this.discussionJsonExpiration.getReadOnce() != null && this.discussionJsonExpiration.getReadOnce() != false;
            this.visibility = this.discussionJsonExpiration.getVisibilityDuration();
            this.existence = this.discussionJsonExpiration.getExistenceDuration();
        }
    }
}

