/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.engine.helpers.message.tasks.SetDraftJsonExpirationTask;
import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopup;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.EphemeralSettingsViewModel;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.helpers.TextHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class EphemeralSettingsPopupController
implements Initializable {
    @FXML
    private VBox ephemeral_settings_global_vbox;
    @FXML
    private VBox default_settings_summary_vbox;
    @FXML
    private Label text_ephemeral_settings_summary;
    @FXML
    private Text default_ephemeral_settings_summary;
    @FXML
    private HBox visible_once_setting_hbox;
    @FXML
    private Label text_visible_once;
    @FXML
    private CheckBox burn_after_reading_checkbox;
    @FXML
    private HBox visible_for_setting_hbox;
    @FXML
    private Label text_visible_for;
    @FXML
    private TextField visible_for_input;
    @FXML
    private ComboBox<String> visible_for_combobox;
    @FXML
    private HBox existence_for_setting_hbox;
    @FXML
    private Label text_existence_for;
    @FXML
    private TextField existence_for_input;
    @FXML
    private ComboBox<String> existence_for_combobox;
    @FXML
    private Button ok_button;
    private static final String FXML_PATH = "fx/discussions/discussion_view/messages/message_composer/ephemeral_settings.fxml";
    private final EphemeralSettingsViewModel ephemeralSettingsViewModel = new EphemeralSettingsViewModel(DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData());
    private UNIT visibilityUnit;
    private UNIT existenceUnit;
    private VISEX popupMenuVisex;
    private static final String SECONDS_TEXT_ID = "unit_s_label";
    private static final String MINUTES_TEXT_ID = "unit_m_label";
    private static final String HOURS_TEXT_ID = "unit_h_label";
    private static final String DAYS_TEXT_ID = "unit_d_label";
    private static final String YEARS_TEXT_ID = "unit_y_label";
    private static String SECONDS_TEXT;
    private static String MINUTES_TEXT;
    private static String HOURS_TEXT;
    private static String DAYS_TEXT;
    private static String YEARS_TEXT;

    public EphemeralSettingsPopupController() {
        ViewControllerHelper.loadNodeWithExplicitController(this, FXML_PATH);
    }

    public void initialize(URL location, ResourceBundle resources) {
        AppLogger.t("EphemeralSettingsPopupController::initialize");
        this.burn_after_reading_checkbox.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.ephemeralSettingsViewModel.setReadOnce(this.burn_after_reading_checkbox.isSelected());
            }
        });
        this.visible_for_input.textProperty().addListener((observable, oldValue, newValue) -> this.recompute(VISEX.VISIBILITY));
        this.existence_for_input.textProperty().addListener((observable, oldValue, newValue) -> this.recompute(VISEX.EXISTENCE));
        SECONDS_TEXT = ViewControllerHelper.RESOURCE_BUNDLE.getString(SECONDS_TEXT_ID).replace("\n", System.lineSeparator());
        MINUTES_TEXT = ViewControllerHelper.RESOURCE_BUNDLE.getString(MINUTES_TEXT_ID).replace("\n", System.lineSeparator());
        HOURS_TEXT = ViewControllerHelper.RESOURCE_BUNDLE.getString(HOURS_TEXT_ID).replace("\n", System.lineSeparator());
        DAYS_TEXT = ViewControllerHelper.RESOURCE_BUNDLE.getString(DAYS_TEXT_ID).replace("\n", System.lineSeparator());
        YEARS_TEXT = ViewControllerHelper.RESOURCE_BUNDLE.getString(YEARS_TEXT_ID).replace("\n", System.lineSeparator());
        ObservableList comboiItems = FXCollections.observableArrayList((Object[])new String[]{SECONDS_TEXT, MINUTES_TEXT, HOURS_TEXT, DAYS_TEXT, YEARS_TEXT});
        this.visible_for_combobox.setItems(comboiItems);
        this.existence_for_combobox.setItems(comboiItems);
        this.ephemeralSettingsViewModel.getDraftLoaded().addListener(this::draftLoadedChanged);
        this.visible_for_input.setTextFormatter(TextHelper.getDigitOnlyTextFormatter());
        this.existence_for_input.setTextFormatter(TextHelper.getDigitOnlyTextFormatter());
        this.ok_button.setOnMouseClicked(this::onValidate);
        this.visible_for_combobox.getSelectionModel().selectedItemProperty().addListener(this::visibilityTimeChanged);
        this.existence_for_combobox.getSelectionModel().selectedItemProperty().addListener(this::existenceTimeChanged);
    }

    private void existenceTimeChanged(Observable observable, String oldValue, String newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (newValue.equals(SECONDS_TEXT)) {
            this.existenceUnit = UNIT.SECONDS;
        } else if (newValue.equals(MINUTES_TEXT)) {
            this.existenceUnit = UNIT.MINUTES;
        } else if (newValue.equals(HOURS_TEXT)) {
            this.existenceUnit = UNIT.HOURS;
        } else if (newValue.equals(DAYS_TEXT)) {
            this.existenceUnit = UNIT.DAYS;
        } else if (newValue.equals(YEARS_TEXT)) {
            this.existenceUnit = UNIT.YEARS;
        }
        AppLogger.d("Existence unit set to : " + String.valueOf((Object)this.existenceUnit));
        this.recompute(VISEX.EXISTENCE);
    }

    private void visibilityTimeChanged(Observable observable, String oldValue, String newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (newValue.equals(SECONDS_TEXT)) {
            this.visibilityUnit = UNIT.SECONDS;
        } else if (newValue.equals(MINUTES_TEXT)) {
            this.visibilityUnit = UNIT.MINUTES;
        } else if (newValue.equals(HOURS_TEXT)) {
            this.visibilityUnit = UNIT.HOURS;
        } else if (newValue.equals(DAYS_TEXT)) {
            this.visibilityUnit = UNIT.DAYS;
        } else if (newValue.equals(YEARS_TEXT)) {
            this.visibilityUnit = UNIT.YEARS;
        }
        AppLogger.d("Visibility unit set to : " + String.valueOf((Object)this.visibilityUnit));
        this.recompute(VISEX.VISIBILITY);
    }

    public Node getContainer() {
        return this.ephemeral_settings_global_vbox;
    }

    private void recompute(VISEX visex) {
        String count = null;
        UNIT unit = UNIT.MINUTES;
        switch (visex.ordinal()) {
            case 0: {
                count = this.visible_for_input.getText();
                unit = this.visibilityUnit;
                break;
            }
            case 1: {
                count = this.existence_for_input.getText();
                unit = this.existenceUnit;
                break;
            }
            default: {
                AppLogger.w("not handling VISEX : " + visex.name());
            }
        }
        Long time = null;
        if (count != null) {
            try {
                long unitTime = Long.parseLong(count.toString());
                time = switch (unit.ordinal()) {
                    case 0 -> unitTime;
                    case 1 -> unitTime * 60L;
                    case 2 -> unitTime * 3600L;
                    case 3 -> unitTime * 86400L;
                    case 4 -> unitTime * 31536000L;
                    default -> null;
                };
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AppLogger.t("Setting visibility time to : " + time + " " + String.valueOf((Object)this.visibilityUnit) + "\nFor : " + visex.name());
        AppLogger.t("Setting existence time  to : " + time + " " + String.valueOf((Object)this.existenceUnit) + "\nFor : " + visex.name());
        switch (visex.ordinal()) {
            case 0: {
                this.ephemeralSettingsViewModel.setVisibility(time);
                break;
            }
            case 1: {
                this.ephemeralSettingsViewModel.setExistence(time);
            }
        }
    }

    private void setTimeAndUnit(Optional<Long> timeOpt, VISEX visex) {
        String value;
        UNIT unit;
        if (timeOpt.isEmpty()) {
            unit = visex == VISEX.VISIBILITY ? UNIT.MINUTES : UNIT.DAYS;
            value = null;
        } else {
            long time = timeOpt.get();
            if (time == 0L) {
                unit = visex == VISEX.VISIBILITY ? UNIT.MINUTES : UNIT.DAYS;
                value = "0";
            } else if (time % 31536000L == 0L) {
                unit = UNIT.YEARS;
                value = Long.toString(time / 31536000L);
            } else if (time % 86400L == 0L) {
                unit = UNIT.DAYS;
                value = Long.toString(time / 86400L);
            } else if (time % 3600L == 0L) {
                unit = UNIT.HOURS;
                value = Long.toString(time / 3600L);
            } else if (time % 60L == 0L) {
                unit = UNIT.MINUTES;
                value = Long.toString(time / 60L);
            } else {
                unit = UNIT.SECONDS;
                value = Long.toString(time);
            }
        }
        switch (visex.ordinal()) {
            case 0: {
                this.visible_for_input.setText(value);
                this.visibilityUnit = unit;
                break;
            }
            case 1: {
                this.existence_for_input.setText(value);
                this.existenceUnit = unit;
            }
        }
        this.unitChanged(visex);
    }

    private void unitChanged(VISEX visex) {
        UNIT unit = switch (visex.ordinal()) {
            case 0 -> this.visibilityUnit;
            default -> this.existenceUnit;
        };
        String text = switch (unit.ordinal()) {
            case 1 -> MINUTES_TEXT_ID;
            case 2 -> HOURS_TEXT_ID;
            case 3 -> DAYS_TEXT_ID;
            case 4 -> YEARS_TEXT_ID;
            default -> SECONDS_TEXT_ID;
        };
        switch (visex.ordinal()) {
            case 0: {
                this.visible_for_combobox.setValue((Object)ViewControllerHelper.RESOURCE_BUNDLE.getString(text).replace("\n", System.lineSeparator()));
                break;
            }
            case 1: {
                this.existence_for_combobox.setValue((Object)ViewControllerHelper.RESOURCE_BUNDLE.getString(text).replace("\n", System.lineSeparator()));
            }
        }
        this.recompute(visex);
    }

    private void draftLoadedChanged(Boolean newValue, Boolean oldValue) {
        if (newValue != null && newValue.booleanValue()) {
            this.burn_after_reading_checkbox.setDisable(false);
            this.visible_for_input.setDisable(false);
            this.existence_for_input.setDisable(false);
            this.existence_for_combobox.setDisable(false);
            this.visible_for_combobox.setDisable(false);
            Optional<OutboundMessageEphemeralInfo> draftEphemeralInfoOpt = this.ephemeralSettingsViewModel.getDraftEphemeralInfo();
            if (draftEphemeralInfoOpt.isPresent()) {
                OutboundMessageEphemeralInfo draftEphemeralInfo = draftEphemeralInfoOpt.get();
                this.burn_after_reading_checkbox.setSelected(draftEphemeralInfo.isReadOnce());
                this.setTimeAndUnit(draftEphemeralInfo.getVisibilityDuration(), VISEX.VISIBILITY);
                this.setTimeAndUnit(draftEphemeralInfo.getExistenceDuration(), VISEX.EXISTENCE);
            } else {
                this.burn_after_reading_checkbox.setSelected(false);
                this.setTimeAndUnit(Optional.empty(), VISEX.VISIBILITY);
                this.setTimeAndUnit(Optional.empty(), VISEX.EXISTENCE);
            }
        } else {
            this.burn_after_reading_checkbox.setDisable(true);
            this.visible_for_input.setDisable(true);
            this.existence_for_input.setDisable(true);
            this.existence_for_combobox.setDisable(true);
            this.visible_for_combobox.setDisable(true);
        }
    }

    private void onValidate(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && this.ephemeralSettingsViewModel.getValid().getValue() != null && ((Boolean)this.ephemeralSettingsViewModel.getValid().getValue()).booleanValue()) {
            AsyncTaskExecutor.submitTask(() -> new SetDraftJsonExpirationTask(this.ephemeralSettingsViewModel.getDiscussion(), this.ephemeralSettingsViewModel.isReadOnce(), this.ephemeralSettingsViewModel.getVisibility(), this.ephemeralSettingsViewModel.getExistence()).run());
            CustomPopup.getCurrentPopUpRef().hide();
        }
    }

    private static enum UNIT {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        YEARS;

    }

    private static enum VISEX {
        VISIBILITY,
        EXISTENCE;

    }
}

