/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.DraftsBackupTask;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.fx.misc.OpenGraphHelper;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class DraftAttachmentsViewModel {
    private Optional<OpenGraph> lastHandledOpenGraph = Optional.empty();
    private final LiveData<List<OutboundAttachment>> attachmentLiveData;
    private final LiveData<List<OutboundAttachment>> pureDraftAttachment;
    private final LiveData<Optional<OutboundAttachment>> linkPreviewDraftAttachment;
    private final IntegerProperty attachmentCountProperty = new SimpleIntegerProperty(0);
    private final IntegerProperty maxAttachmentToDownload = new SimpleIntegerProperty();
    private final AppLogger logger = new AppLogger(DraftAttachmentsViewModel.class);

    public DraftAttachmentsViewModel() {
        this.attachmentLiveData = LiveDataFactory.switchMap(DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData(), discussion -> {
            if (discussion != null) {
                return LiveDataFactory.buildDbLiveDataList(OutboundAttachment.class, () -> DbManager.getInstance().getOutboundAttachmentDao().getDiscussionDraftAttachments((Id<Discussion>)discussion.getItemId()));
            }
            return null;
        });
        this.pureDraftAttachment = ListLiveData.filter(this.attachmentLiveData, outboundAttachment -> !"olvid/link-preview".equals(outboundAttachment.getMimeType()));
        this.linkPreviewDraftAttachment = ListLiveData.findFirst(this.attachmentLiveData, outboundAttachment -> outboundAttachment.getStatus().equals(OutboundAttachmentGenerated.Status.DRAFT_READY) && "olvid/link-preview".equals(outboundAttachment.getMimeType()));
    }

    void fetchOpenGraph(String trimmedInput, Optional<String> last) {
        this.logger.trace("DraftAttachmentViewModel::fetchOpenGraph run");
        if (last.isEmpty() || Thread.currentThread().isInterrupted()) {
            this.deleteLastLinkPreviewDraft();
            return;
        }
        if (this.lastHandledOpenGraph.isPresent() && this.lastHandledOpenGraph.get().getUrl().equals(last.get())) {
            this.logger.trace("DraftAttachmentViewModel::fetchOpenGraph run same url as last, nothing to do");
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.deleteLastLinkPreviewDraft();
            return;
        }
        Optional<OpenGraph> openGraph = OpenGraphHelper.fetchOpenGraph(last.get());
        if (Thread.currentThread().isInterrupted()) {
            this.deleteLastLinkPreviewDraft();
            return;
        }
        openGraph.ifPresentOrElse(graph -> {
            if (this.updateOpenGraph(Optional.of(graph))) {
                if (this.getLinkPreviewDraftAttachment().getValue().isPresent()) {
                    new DeleteDraftAttachmentsDbTask(this.getLinkPreviewDraftAttachment().getValue().get()).run();
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.deleteLastLinkPreviewDraft();
                    return;
                }
                this.logger.debug("DraftAttachmentViewModel::fetchOpenGraph found link preview, adding it to draft");
                new DraftsBackupTask((Id<Discussion>)DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue().getItemId(), trimmedInput, new DraftsBackupTask.DataInputStruct(OpenGraphHelper.encodeOpenGraphStruct(graph), "olvid/link-preview")).run();
            }
        }, this::deleteLastLinkPreviewDraft);
    }

    private void deleteLastLinkPreviewDraft() {
        if (this.getLinkPreviewDraftAttachment().getValue().isPresent()) {
            new DeleteDraftAttachmentsDbTask(this.getLinkPreviewDraftAttachment().getValue().get()).run();
        }
        this.updateOpenGraph(Optional.empty());
    }

    public int getAttachmentCountProperty() {
        return this.attachmentCountProperty.get();
    }

    public IntegerProperty attachmentCountPropertyProperty() {
        return this.attachmentCountProperty;
    }

    public void setAttachmentCountProperty(int attachmentCountProperty) {
        this.attachmentCountProperty.set(attachmentCountProperty);
    }

    public List<OutboundAttachment> getPureDraftAttachmentsList() {
        return this.pureDraftAttachment.getValue() == null ? Collections.emptyList() : this.pureDraftAttachment.getValue();
    }

    public int getMaxAttachmentToDownload() {
        return this.maxAttachmentToDownload.get();
    }

    public IntegerProperty maxAttachmentToDownloadProperty() {
        return this.maxAttachmentToDownload;
    }

    public void setMaxAttachmentToDownload(int maxAttachmentToDownload) {
        this.maxAttachmentToDownload.set(maxAttachmentToDownload);
    }

    public LiveData<List<OutboundAttachment>> getPureDraftAttachment() {
        return this.pureDraftAttachment;
    }

    public LiveData<Optional<OutboundAttachment>> getLinkPreviewDraftAttachment() {
        return this.linkPreviewDraftAttachment;
    }

    boolean updateOpenGraph(Optional<OpenGraph> graph) {
        boolean updated = false;
        if (graph.isEmpty() || !graph.get().equals(this.lastHandledOpenGraph.orElse(null))) {
            this.lastHandledOpenGraph = graph;
            updated = true;
        }
        this.logger.trace(graph.toString());
        return updated;
    }
}

