/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.text.Text;

public class InvitationReceivedFragmentController
implements Initializable {
    private final AppLogger loggerInstance = new AppLogger(this.getClass());
    @FXML
    private Text invitationInfoMessage;
    @FXML
    private Button invitationAccept;
    @FXML
    private Button invitationDiscard;
    Invitation invitation;
    private final StringProperty discussionTitle;

    public InvitationReceivedFragmentController(Invitation invitation, StringProperty discussionTitle) {
        this.invitation = invitation;
        this.discussionTitle = discussionTitle;
    }

    public void initialize(URL location, ResourceBundle resources) {
        ObjectMapper jsonObjectMapper = EngineWrapper.getJsonObjectMapper();
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT) {
            this.invitationInfoMessage.textProperty().bind((ObservableValue)ViewControllerHelper.getString("new_invitation_message", (ObservableStringValue)this.discussionTitle));
        } else if (this.invitation.getState() == InvitationGenerated.State.GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT || this.invitation.getState() == InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT) {
            this.invitationInfoMessage.textProperty().bind((ObservableValue)ViewControllerHelper.getString("new_group_invitation_via_message", (ObservableStringValue)this.discussionTitle));
        }
        this.invitationAccept.setOnAction(this::handleInvitationAccept);
        this.invitationDiscard.setOnAction(this::handleInvitationDiscard);
    }

    private void handleInvitationAccept(ActionEvent actionEvent) {
        this.loggerInstance.debug("handleInvitationAccept");
        if (this.invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT) {
            if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
                InvitationApi.answerInvitation(this.invitation, true, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            }
        } else if (this.invitation.getState() == InvitationGenerated.State.GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT || this.invitation.getState() == InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT) {
            AsyncTaskExecutor.submitTask(() -> InvitationApi.answerGroupInvitation(this.invitation, true));
        } else {
            return;
        }
        this.invitationAccept.setDisable(true);
    }

    private void handleInvitationDiscard(ActionEvent actionEvent) {
        this.loggerInstance.debug("handleInvitationDiscard");
        if (this.invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT) {
            if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
                InvitationApi.answerInvitation(this.invitation, false, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            }
        } else if (this.invitation.getState() == InvitationGenerated.State.GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT || this.invitation.getState() == InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT) {
            AsyncTaskExecutor.submitTask(() -> InvitationApi.answerGroupInvitation(this.invitation, false));
        } else {
            return;
        }
        this.invitationDiscard.setDisable(true);
    }
}

