/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.text.Text;

public class InvitationOneToOneReceivedFragmentController
implements Initializable {
    private final AppLogger loggerInstance = new AppLogger(this.getClass());
    @FXML
    private Text invitationInfoMessage;
    @FXML
    private Button invitationAccept;
    @FXML
    private Button invitationDiscard;
    Invitation invitation;
    private final StringProperty discussionTitle;

    public InvitationOneToOneReceivedFragmentController(Invitation invitation, StringProperty discussionTitle) {
        this.invitation = invitation;
        this.discussionTitle = discussionTitle;
    }

    public void initialize(URL location, ResourceBundle resources) {
        ObjectMapper jsonObjectMapper = EngineWrapper.getJsonObjectMapper();
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.invitationInfoMessage.textProperty().bind((ObservableValue)ViewControllerHelper.getString("new_one_to_one_invitation_message", (ObservableStringValue)this.discussionTitle));
        this.invitationAccept.setOnAction(this::handleOneToOneInvitationAccept);
        this.invitationDiscard.setOnAction(this::handleOneToOneInvitationDiscard);
    }

    private void handleOneToOneInvitationAccept(ActionEvent actionEvent) {
        this.loggerInstance.debug("handleOneToOneInvitationAccept");
        if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.answerOneToOneInvitation(this.invitation, true, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            this.invitationAccept.setDisable(true);
        }
    }

    private void handleOneToOneInvitationDiscard(ActionEvent actionEvent) {
        this.loggerInstance.debug("handleOneToOneInvitationDiscard");
        if (SelectedOwnedIdentitySingleton.getInstance().isSelectedIdentityPresent()) {
            InvitationApi.answerOneToOneInvitation(this.invitation, false, SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity());
            this.invitationAccept.setDisable(true);
        }
    }
}

