/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.draft_attachment_list;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.misc.ImageLruCache;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import java.util.List;

public class DraftAttachmentsViewModel {
    private final LiveData<List<OutboundAttachment>> attachmentInfosLiveData;
    private final ImageLruCache smallImageCache;

    public DraftAttachmentsViewModel(LiveDataListener<List<OutboundAttachment>> listener, ImageLruCache smallImageCache) {
        this.smallImageCache = smallImageCache;
        this.attachmentInfosLiveData = LiveDataFactory.switchMap(DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData(), discussion -> {
            if (discussion != null) {
                return LiveDataFactory.buildDbLiveDataList(OutboundAttachment.class, () -> DbManager.getInstance().getOutboundAttachmentDao().getDiscussionDraftAndCopyingAttachments((Id<Discussion>)discussion.getItemId()));
            }
            return null;
        });
        this.attachmentInfosLiveData.addListener(listener);
    }

    public List<OutboundAttachment> getDraftAttachmentList() {
        return this.attachmentInfosLiveData.getValue();
    }

    public ImageLruCache getSmallImageCache() {
        return this.smallImageCache;
    }
}

