/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageEditionState;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.tasks.ForwardMessageTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.InboundEphemeralUnboxTask;
import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopup;
import io.olvid.windows.messenger.fx.custom_components.drag_and_drop.DropAreaController;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.CurrentSearchedItemLivedataListener;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionHeaderController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.discussions.discussion_view.invitation_embedded.EmbeddedInvitationList;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MessageComposerController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.ItemId;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageListCell;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action.DeletePopupInnerController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action.ForwardMessageModalController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action.MessageActionEvent;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.flow_view.CellWithItem;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListConfiguration;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.NodeUtils;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.fx.misc.OpenGraphHelper;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentsViewerModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.CannotForwardMessageModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.FileOpeningWarningModalController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionsDetailsModalController;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.io.IOUtils;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ElementDisplayConfirmationNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ShareCurrentDiscussionNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.fxmisc.flowless.VirtualFlow;

@FXMLView(path="fx/discussions/discussion_view/discussion_view.fxml")
public class DiscussionViewController
extends BaseViewController {
    private final AppLogger logger = new AppLogger(this.getClass());
    @FXML
    private AnchorPane header_container;
    @FXML
    private VBox conversation_vbox;
    @FXML
    private AnchorPane message_list_view_container;
    @FXML
    private EmbeddedInvitationList embeddedInvitationList;
    @FXML
    private HBox channel_creating_pane;
    @FXML
    private AnchorPane message_composer_container;
    private final Button scrollToBottonButton = new Button();
    private final DiscussionHeaderController headerController;
    private final MessageComposerController messageComposerController;
    private final FlowListViewController<MessageItem> messagesListViewController;
    private final DiscussionViewModel discussionViewModel;
    private final LiveDataListener<Discussion> onCurrentDiscussionChanged = this::onUISelectedDiscussionChanged;
    private final LiveDataListener<Optional<DiscussionInfoWithState>> onCurrentDbDiscussionChanged = this::onCurrentDbDiscussionChanged;
    final NotificationListener<GenericNotification<Id<Discussion>>> scrollToNotificationListener = this::scrollToNotificationListener;
    public final ScrollInfo scrollInfo = new ScrollInfo();
    final FlowListConfiguration<MessageItem> flowListConfiguration = new FlowListConfiguration<MessageItem>(){
        private static final boolean DEBUG_SCROLL_TO = false;

        private static boolean isDiscussionChange(List<MessageItem> newValues, List<MessageItem> oldValues) {
            Id<Discussion> oldDiscussionId;
            if (oldValues == null || oldValues.isEmpty() || newValues == null || newValues.isEmpty()) {
                return true;
            }
            Id<Discussion> newDiscussionId = newValues.get(0).getDiscussionId();
            return !newDiscussionId.equals(oldDiscussionId = oldValues.get(0).getDiscussionId());
        }

        @Override
        public void listWillChange(List<MessageItem> newValues, List<MessageItem> oldValues) {
            if (1.isDiscussionChange(newValues, oldValues)) {
                DiscussionViewController.this.scrollInfo.disable();
            }
        }

        @Override
        public boolean isDeepChange(List<MessageItem> newValues, List<MessageItem> oldValues) {
            return 1.isDiscussionChange(newValues, oldValues);
        }

        private Pair<Integer, FlowListConfiguration.Position> scrollToResult(int index, FlowListConfiguration.Position position, String reason) {
            return Pair.of(index, position);
        }

        @Override
        public Pair<Integer, FlowListConfiguration.Position> scrollTo(List<MessageItem> newValues, List<MessageItem> oldValues) {
            if (newValues == null || newValues.isEmpty()) {
                return this.scrollToResult(0, FlowListConfiguration.Position.NONE, "No new values");
            }
            Optional<MessageItem> firstUnreadMessage = newValues.stream().filter(messageItem -> messageItem.getUnreadCount() > 0).findFirst();
            Optional<Integer> firstUnreadMessageIdx = firstUnreadMessage.map(newValues::indexOf);
            int lastIndex = newValues.size() - 1;
            if (1.isDiscussionChange(newValues, oldValues)) {
                if (firstUnreadMessageIdx.isPresent()) {
                    return this.scrollToResult(firstUnreadMessageIdx.get(), FlowListConfiguration.Position.FIRST, "Discussion!= + Found unread");
                }
                return this.scrollToResult(lastIndex, FlowListConfiguration.Position.LAST, "Discussion!= + No unread ");
            }
            assert (!oldValues.isEmpty());
            int oldLastIndex = oldValues.size() - 1;
            MessageItem oldLastMessage = oldValues.get(oldLastIndex);
            MessageItem newLastMessage = newValues.get(lastIndex);
            if (oldLastMessage.getItemId().equals(newLastMessage.getItemId())) {
                if (DiscussionViewController.this.messagesListViewController.getLastVisibleIndex() == newValues.size() - 1) {
                    return this.scrollToResult(DiscussionViewController.this.messagesListViewController.getLastVisibleIndex(), FlowListConfiguration.Position.LAST, "Discussion== + Last message== + Last is visible");
                }
                return this.scrollToResult(0, FlowListConfiguration.Position.NONE, "Discussion== + Last message== + Last is not visible");
            }
            if (!newLastMessage.getLocalDateTime().isAfter(oldLastMessage.getLocalDateTime())) {
                return this.scrollToResult(0, FlowListConfiguration.Position.NONE, "Discussion== + Last message<=");
            }
            boolean penultimateIsVisible = DiscussionViewController.this.messagesListViewController.isVisible(lastIndex - 1);
            if (penultimateIsVisible) {
                return this.scrollToResult(lastIndex, FlowListConfiguration.Position.LAST, "Discussion== + Last message> + penultimate is visible");
            }
            return this.scrollToResult(0, FlowListConfiguration.Position.NONE, "Discussion== + Last message> + penultimate is not visible");
        }

        @Override
        public void scrollWasDone() {
            DiscussionViewController.this.scrollInfo.enableScroll.set(true);
        }
    };

    public DiscussionViewController() {
        this.loadFxml();
        this.discussionViewModel = new DiscussionViewModel(DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData(), (Region)this.conversation_vbox);
        this.headerController = new DiscussionHeaderController(this.discussionViewModel);
        ViewControllerHelper.attachNodeToAnchorPane((Node)this.headerController.getLayout(), (Pane)this.header_container);
        this.messagesListViewController = FlowListViewController.builder(MessageItem.class, this.discussionViewModel.getMessageListLiveData(), this::buildMessageCell).withLastItemVisibilityProperty().autoScroll(this.flowListConfiguration).unsorted().clickAction(this::itemClickedConsumerHandler).build();
        this.messagesListViewController.model.bindSearchModeProperty(this.discussionViewModel.getSearchMode());
        AnchorPane.setBottomAnchor(this.messagesListViewController.getLayout(), (Double)0.0);
        AnchorPane.setLeftAnchor(this.messagesListViewController.getLayout(), (Double)4.0);
        AnchorPane.setRightAnchor(this.messagesListViewController.getLayout(), (Double)0.0);
        AnchorPane.setTopAnchor(this.messagesListViewController.getLayout(), (Double)0.0);
        this.message_list_view_container.getChildren().add(this.messagesListViewController.getLayout());
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().addListener(this.onCurrentDiscussionChanged);
        this.discussionViewModel.getDbSelectedDiscussion().addListener(this.onCurrentDbDiscussionChanged);
        this.messageComposerController = new MessageComposerController(this.discussionViewModel);
        AnchorPane.setBottomAnchor((Node)this.messageComposerController.getLayout(), (Double)12.0);
        AnchorPane.setLeftAnchor((Node)this.messageComposerController.getLayout(), (Double)12.0);
        AnchorPane.setRightAnchor((Node)this.messageComposerController.getLayout(), (Double)12.0);
        this.message_composer_container.getChildren().add((Object)this.messageComposerController.getLayout());
        DropAreaController.addDropArea(this.messageComposerController, (Pane)this.conversation_vbox, false, Optional.of(new Insets(16.0)));
        this.discussionViewModel.getCurrentSearchedItemLiveData().addListener(new CurrentSearchedItemLivedataListener(this.messagesListViewController));
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.SCROLL_TO_BOTTOM, this.scrollToNotificationListener);
        ((VirtualFlow)this.messagesListViewController.getLayout().getContent()).estimatedScrollYProperty().addListener((observable, oldValue, newValue) -> this.discussionViewModel.scrollChange((Double)newValue));
        this.scrollToBottonButton.getStyleClass().add((Object)"scroll-to-bottom-button");
        this.message_list_view_container.getChildren().add((Object)this.scrollToBottonButton);
        SvgSizeable icon = new SvgSizeable();
        icon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "icon-black", "svg-arrow-bottom"});
        this.scrollToBottonButton.setGraphic((Node)icon);
        this.scrollToBottonButton.setOnMouseClicked(e -> this.messagesListViewController.scrollToBottom());
        AnchorPane.setBottomAnchor((Node)this.scrollToBottonButton, (Double)16.0);
        AnchorPane.setRightAnchor((Node)this.scrollToBottonButton, (Double)12.0);
        this.scrollToBottonButton.visibleProperty().bind((ObservableValue)this.messagesListViewController.isLastItemVisible().not());
    }

    private void scrollToNotificationListener(GenericNotification<Id<Discussion>> notification) {
        if (notification == null) {
            return;
        }
        Id<Discussion> discussionID = notification.getIncomingValue();
        if (discussionID == null) {
            return;
        }
        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        if (discussion == null || !((Id)discussion.getItemId()).equals(discussionID)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(this.messagesListViewController::scrollToBottom);
    }

    private CellWithItem<MessageItem> buildMessageCell(ObjectProperty<MessageItem> messageItem) {
        MessageListCell cell = new MessageListCell((DoubleExpression)this.message_list_view_container.widthProperty(), (DoubleExpression)this.message_list_view_container.heightProperty(), this.discussionViewModel, this.discussionViewModel, this.scrollInfo, this.messagesListViewController);
        cell.addEventHandler(MessageActionEvent.MESSAGE_EVENT, event -> cell.getItem().ifPresent(cellMessageItem -> this.handleMessageEvent((MessageActionEvent)event, (MessageItem)cellMessageItem)));
        cell.updateItem(messageItem);
        return cell;
    }

    @Override
    public void onLayoutAttached() {
        this.getLayout().getScene().setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F) {
                if (event.isControlDown()) {
                    this.discussionViewModel.getSearchMode().set(true);
                }
            } else if (event.getCode() == KeyCode.ESCAPE) {
                this.discussionViewModel.getSearchMode().set(false);
            }
        });
    }

    @Override
    public void onLayoutDetached() {
    }

    public void onUISelectedDiscussionChanged(Discussion newDiscussion, Discussion oldDiscussion) {
        List ownedMessages;
        List outboundMessages;
        if (newDiscussion != null && newDiscussion.equals(oldDiscussion)) {
            AsyncTaskExecutor.submitTask(() -> DiscussionApi.markDiscussionMessagesAsReadUpTo((Id<Discussion>)newDiscussion.getItemId(), Optional.empty()));
            return;
        }
        NCRegistry.getUtilityNC().postNotification(new ShareCurrentDiscussionNotification(newDiscussion));
        List inboundMessages = DbManager.getInstance().getInboundMessageDao().get(this.discussionViewModel.getReadInboundMessagesToAnnihilate());
        if (!inboundMessages.isEmpty()) {
            MessageDeletionHelper.deleteMessagesDbTask(inboundMessages, false);
            this.discussionViewModel.getReadInboundMessagesToAnnihilate().clear();
        }
        if (!(outboundMessages = DbManager.getInstance().getOutboundMessageDao().get(this.discussionViewModel.getReadOutboundMessagesToAnnihilate())).isEmpty()) {
            MessageDeletionHelper.deleteMessagesDbTask(outboundMessages, false);
            this.discussionViewModel.getReadOutboundMessagesToAnnihilate().clear();
        }
        if (!(ownedMessages = DbManager.getInstance().getOwnedMessageDao().get(this.discussionViewModel.getReadOwnedMessagesToAnnihilate())).isEmpty()) {
            MessageDeletionHelper.deleteMessagesDbTask(ownedMessages, false);
            this.discussionViewModel.getReadOwnedMessagesToAnnihilate().clear();
        }
        ElementDisplayConfirmationNotification.fireDiscussionDisplayNotification(newDiscussion);
    }

    private void onCurrentDbDiscussionChanged(Optional<DiscussionInfoWithState> newDiscussion, Optional<DiscussionInfoWithState> oldDiscussion) {
        long lastUnreadTimestamp;
        boolean discussionChanged;
        Optional<DiscussionInfoWithState> newDiscussionOpt = Objects.requireNonNullElse(newDiscussion, Optional.empty());
        Optional<DiscussionInfoWithState> oldDiscussionOpt = Objects.requireNonNullElse(oldDiscussion, Optional.empty());
        boolean bl = discussionChanged = !newDiscussionOpt.map(DiscussionInfoWithState::id).equals(oldDiscussionOpt.map(DiscussionInfoWithState::id));
        if (oldDiscussionOpt.isPresent() && discussionChanged && (lastUnreadTimestamp = this.scrollInfo.lastUnreadTimestamp.getThenReset()) > 0L) {
            DiscussionApi.markDiscussionMessagesAsReadUpTo(((DiscussionInfoWithState)oldDiscussionOpt.get()).id(), Optional.of(lastUnreadTimestamp));
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newDiscussionOpt.isEmpty()) {
                ViewControllerHelper.hideNode((Node)this.conversation_vbox);
                ViewControllerHelper.hideNode((Node)this.embeddedInvitationList);
                ViewControllerHelper.hideNode((Node)this.channel_creating_pane);
                ViewControllerHelper.hideNode((Node)this.messageComposerController.getLayout());
                return;
            }
            this.refreshChildNodesVisibility((DiscussionInfoWithState)newDiscussionOpt.get());
            if (discussionChanged) {
                this.discussionViewModel.getSearchMode().set(false);
            }
        });
    }

    private void refreshChildNodesVisibility(DiscussionInfoWithState discussion) {
        ViewControllerHelper.checkUIThread();
        ViewControllerHelper.showNode((Node)this.conversation_vbox);
        ViewControllerHelper.showNode((Node)this.embeddedInvitationList);
        if (discussion.channelCreation()) {
            ViewControllerHelper.showNode((Node)this.channel_creating_pane);
        } else {
            ViewControllerHelper.hideNode((Node)this.channel_creating_pane);
        }
        switch (discussion.info().kind()) {
            case CONTACT: 
            case GROUP: {
                ViewControllerHelper.showNode((Node)this.messageComposerController.getLayout());
                this.messageComposerController.getLayout().disableProperty().set(!discussion.canPostMessage());
                break;
            }
            case PRE_CONTACT: 
            case PRE_GROUP: 
            case LOCKED: {
                ViewControllerHelper.hideNode((Node)this.messageComposerController.getLayout());
            }
        }
    }

    public VBox getLayout() {
        return this.conversation_vbox;
    }

    private void handleMessageEvent(MessageActionEvent messageActionEvent, MessageItem messageItem) {
        Optional<MessageView.Action> action = MessageView.Action.of(messageActionEvent.getEventType());
        if (action.isEmpty()) {
            return;
        }
        this.discussionViewModel.runAction(action.get(), messageItem, messageActionEvent.getTarget(), this.messagesListViewController);
    }

    private Optional<AbstractAttachmentGenerated<?>> findAttachment(Node node) {
        Optional<PreviewUtils.Preview> previewOpt = NodeUtils.getFirstParentOfType(node, PreviewUtils.Preview.class);
        if (previewOpt.isEmpty()) {
            return Optional.empty();
        }
        PreviewUtils.Preview preview = previewOpt.get();
        AbstractAttachmentGenerated<?> attachment = preview.getAttachment();
        return Optional.of(attachment);
    }

    private Optional<Action> findAction(MessageItem message, Node node) {
        if (message.getKind() == MessageKind.INBOUND && message.getInboundMessage().isBoxed()) {
            if (NodeUtils.getFirstParentById(node, "messageBubbleVBox").isPresent()) {
                return Optional.of(new UnboxAction((Id<InboundMessage>)message.getInboundMessage().getItemId()));
            }
            return Optional.empty();
        }
        Optional<AbstractAttachmentGenerated<?>> attachmentOpt = this.findAttachment(node);
        if (attachmentOpt.isPresent()) {
            ReceivedAttachmentGenerated receivedAttachment;
            AbstractAttachmentGenerated<?> attachment = attachmentOpt.get();
            if (attachment instanceof ReceivedAttachmentGenerated && (receivedAttachment = (ReceivedAttachmentGenerated)attachment).getStatus() == ReceivedAttachmentGenerated.Status.DOWNLOADABLE) {
                return Optional.of(new DownloadAction(receivedAttachment));
            }
            if ("olvid/link-preview".equals(attachment.getMimeType())) {
                return Optional.of(new OpenBrowserAction(attachment));
            }
            if (ImageUtils.isImage(attachment.getMimeType())) {
                return Optional.of(new OpenViewerAction(message, attachment, this.discussionViewModel));
            }
            return Optional.of(new OpenAction(attachment));
        }
        return Optional.empty();
    }

    private void itemClickedConsumerHandler(MessageItem message, Node node) {
        if (message == null) {
            AppLogger.d("Clic on null message");
            return;
        }
        AppLogger.d("Click on message id --> " + String.valueOf(message.getItemId()));
        Optional<Action> action = this.findAction(message, node);
        if (action.isPresent()) {
            AsyncTaskExecutor.submitTask(action.get());
        } else if (AppRuntimeHelper.isDebugMode) {
            Optional<MessageListCell> cell = NodeUtils.getFirstParentOfType(node, MessageListCell.class);
            cell.ifPresent(c -> {
                this.logger.debug(c.getItem().toString());
                NodeUtils.printNodeHierarchy((Node)c);
            });
        }
    }

    public static class ScrollInfo {
        private final AtomicBoolean enableScroll = new AtomicBoolean(true);
        private final LongAccumulator lastUnreadTimestamp = new LongAccumulator(Long::max, 0L);

        public synchronized void disable() {
            this.lastUnreadTimestamp.reset();
            this.enableScroll.set(false);
        }

        public void update(long timestamp) {
            if (!this.enableScroll.get()) {
                AppLogger.e("Try to update lastUnreadTimestamp with disabled scroll");
                return;
            }
            this.lastUnreadTimestamp.accumulate(timestamp);
        }
    }

    record UnboxAction(Id<InboundMessage> messageId) implements Action
    {
        @Override
        public void run() {
            InboundMessage message = DbManager.getInstance().getInboundMessageDao().get(this.messageId);
            if (!message.isBoxed()) {
                return;
            }
            new InboundEphemeralUnboxTask(this.messageId, 0L, false).run();
        }
    }

    record DownloadAction(ReceivedAttachmentGenerated<?> attachment) implements Action
    {
        @Override
        public void run() {
            byte[] engineMessageIdentifier = this.attachment.getEngineMessageIdentifier();
            int index = this.attachment.getIdx();
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(this.attachment.getDiscussionId());
            if (discussion != null) {
                OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
                byte[] bytesOwnedIdentity = ownedIdentity.getBytesOwnedIdentity();
                Api.getAttachmentApi().downloadLargeAttachment(bytesOwnedIdentity, this.attachment.getItemId(), engineMessageIdentifier, index);
            }
        }
    }

    record OpenBrowserAction(AbstractAttachmentGenerated<?> attachment) implements Action
    {
        private static String startByProtocol = "^(https?|ftp)://.*$";
        private static final Pattern startByProtocolPattern = Pattern.compile(startByProtocol, 2);

        @Override
        public void run() {
            AsyncTaskExecutor.submitTask(() -> {
                try {
                    Object url;
                    Matcher matcher;
                    Optional<String> urlOpt = Optional.empty();
                    if ("olvid/link-preview".equals(this.attachment.getMimeType())) {
                        urlOpt = this.getLocalOpenGraph();
                    }
                    if (!(matcher = startByProtocolPattern.matcher((CharSequence)(url = urlOpt.orElseGet(this.attachment::getFilename)))).find()) {
                        url = "https://" + (String)url;
                    }
                    AppRuntimeHelper.launchBrowser((String)url);
                }
                catch (Exception ex) {
                    AppLogger.e("The browser could not be open.", ex);
                }
            });
        }

        private Optional<String> getLocalOpenGraph() {
            Result<OpenGraph, Throwable> openGraph;
            Fyle openGraphFyle = DbManager.getInstance().getFyleDao().get(this.attachment.getFyleId());
            if (openGraphFyle != null && (openGraph = OpenGraphHelper.loadOpenGraph(openGraphFyle.getFilePath())).isSuccess()) {
                return Optional.of(openGraph.getSuccess().getUrl());
            }
            return Optional.empty();
        }
    }

    record OpenViewerAction(MessageItem messageItem, AbstractAttachmentGenerated<?> attachment, DiscussionViewModel model) implements Action
    {
        @Override
        public void run() {
            AttachmentInfos attachmentInfos = AttachmentInfos.of(this.attachment);
            ViewControllerHelper.smartUIUpdate(() -> {
                AttachmentsViewerModalController controller = new AttachmentsViewerModalController(this.model);
                controller.update(this.messageItem, attachmentInfos);
                NCRegistry.getUIActionNC().postNotification(new ModalNotification(controller));
            });
        }
    }

    record OpenAction(AbstractAttachmentGenerated<?> attachment) implements Action
    {
        private static final AppLogger logger = new AppLogger(OpenAction.class);

        @Override
        public void run() {
            String tempDir = AppRuntimeHelper.JRE_TEMP_DIR;
            AttachmentInfos attachmentInfos = AttachmentInfos.of(this.attachment);
            File tmp = new File(tempDir);
            String[] list = tmp.list();
            if (list == null) {
                logger.error("Cannot list tmp directory files");
                return;
            }
            List<String> files = Arrays.asList(list);
            String filename = StringUtils.sanitizeFilename(AppRuntimeHelper.isWindows(), attachmentInfos.getFilename());
            int maxTries = files.size() + 1;
            for (int tryCount = 0; files.contains(filename) && tryCount < maxTries; ++tryCount) {
                filename = StringUtils.sanitizeFilename(AppRuntimeHelper.isWindows(), tryCount + attachmentInfos.getFilename());
            }
            if (files.contains(filename)) {
                logger.error("Unable to find a valid filename");
                return;
            }
            if (IOUtils.isWinExecutableFile(filename)) {
                ViewControllerHelper.smartUIUpdate(() -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(FileOpeningWarningModalController.of(false), false)));
                return;
            }
            File file = new File(tempDir, filename);
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachmentInfos.getFyleId());
            SecureFile secureInputFile = new SecureFile(FileApi.absolutePathFromRelative(fyle.getFilePath()));
            try (SecureFileInputStream secureFileInputStream = new SecureFileInputStream(secureInputFile);
                 FileOutputStream outputStream = new FileOutputStream(file);){
                secureFileInputStream.transferTo((OutputStream)outputStream);
            }
            catch (Exception e) {
                logger.error("Cannot save attachment in tmp dir ", e);
                ViewControllerHelper.smartUIUpdate(() -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(FileOpeningWarningModalController.of(true), false)));
                return;
            }
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception e) {
                logger.error("Cannot open attachment in tmp dir ", e);
                ViewControllerHelper.smartUIUpdate(() -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(FileOpeningWarningModalController.of(true), false)));
            }
        }
    }

    record REACTIONSDETAILSAction(MessageItem messageItem, DiscussionViewModel discussionViewModel) implements Action
    {
        @Override
        public void run() {
            ReactionsDetailsModalController controller = new ReactionsDetailsModalController(this.messageItem, this.discussionViewModel);
            NCRegistry.getUIActionNC().postNotification(ModalNotification.of(controller, false));
        }
    }

    record CopyAction(MessageItem messageItem) implements Action
    {
        @Override
        public void run() {
            if (this.messageItem.getKind() == MessageKind.DISCLAIMER || this.messageItem.getKind() == MessageKind.SYSTEM) {
                return;
            }
            ViewControllerHelper.smartUIUpdate(() -> {
                AbstractUserMessageGenerated.Interface message;
                Clipboard clipboard = Clipboard.getSystemClipboard();
                AbstractMessageGenerated.Interface<?> weakenedMessage = this.messageItem.getWeakenedMessageInterface();
                if (weakenedMessage instanceof AbstractUserMessageGenerated.Interface && (message = (AbstractUserMessageGenerated.Interface)weakenedMessage).getBody().isPresent()) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(message.getBody().get());
                    clipboard.setContent((Map)content);
                }
            });
        }
    }

    record OpenInfoAction(MessageItem messageItem) implements Action
    {
        @Override
        public void run() {
            ItemId itemId = this.messageItem.getItemId().itemId();
            switch (this.messageItem.getKind()) {
                case INBOUND: {
                    ViewControllerHelper.smartUIUpdate(() -> {
                        InfoController infoController = new InfoController(new InfoController.InfoState.InboundMessageInfoState((Id)itemId.inbound));
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(infoController, false));
                    });
                    break;
                }
                case OUTBOUND: {
                    List<MessageRecipientInfo> recipientInfos = DbManager.getInstance().getMessageRecipientInfoDao().getAllByMessage((Id)itemId.outbound);
                    boolean hasOwnedDevice = false;
                    for (MessageRecipientInfo info : recipientInfos) {
                        Id<IdentityRef> recipientRefId = info.getRecipientRefId();
                        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().get(recipientRefId);
                        if (!identityRef.getOwnedIdentityId().isPresent()) continue;
                        hasOwnedDevice = true;
                        break;
                    }
                    boolean finalHasOwnedDevice = hasOwnedDevice;
                    ViewControllerHelper.smartUIUpdate(() -> {
                        InfoController infoController = new InfoController(new InfoController.InfoState.OutboundMessageInfoState((Id)itemId.outbound, recipientInfos.size(), finalHasOwnedDevice));
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(infoController, false));
                    });
                    break;
                }
                case OWNED: {
                    ViewControllerHelper.smartUIUpdate(() -> {
                        InfoController infoController = new InfoController(new InfoController.InfoState.OwnedMessageInfoState((Id)itemId.owned));
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(infoController, false));
                    });
                    break;
                }
            }
        }
    }

    record EditAction(MessageItem messageItem, ObjectProperty<Optional<MessageEditionState>> editionStateProperty, Consumer<MessageItem> show) implements Action
    {
        @Override
        public void run() {
            Optional editionStateOpt = (Optional)this.editionStateProperty.get();
            switch (this.messageItem.kind) {
                case OUTBOUND: {
                    Object outboundId = this.messageItem.getOutboundMessage().getItemId();
                    if (editionStateOpt.isPresent() && ((MessageEditionState)editionStateOpt.get()).getItemId().equals(outboundId)) {
                        this.editionStateProperty.set(Optional.empty());
                        break;
                    }
                    this.editionStateProperty.set(Optional.of(MessageEditionState.ofOutbound((Id<OutboundMessage>)outboundId)));
                    this.show.accept(this.messageItem);
                    break;
                }
                case OWNED: {
                    Object ownedId = this.messageItem.getOwnedMessage().getItemId();
                    if (editionStateOpt.isPresent() && ((MessageEditionState)editionStateOpt.get()).getItemId().equals(ownedId)) {
                        this.editionStateProperty.set(Optional.empty());
                        break;
                    }
                    this.editionStateProperty.set(Optional.of(MessageEditionState.ofOwned((Id<OwnedMessage>)ownedId)));
                    this.show.accept(this.messageItem);
                    break;
                }
            }
        }
    }

    record ForwardAction(MessageItem messageItem) implements Action
    {
        @Override
        public void run() {
            if (this.messageItem.getKind() == MessageKind.DISCLAIMER || this.messageItem.getKind() == MessageKind.SYSTEM) {
                return;
            }
            AbstractMessageGenerated<?> message = this.messageItem.getWeakenedMessage();
            if (!(message instanceof AbstractUserMessageGenerated)) {
                throw new IllegalStateException("Try to forward system message");
            }
            AbstractUserMessageGenerated userMessage = (AbstractUserMessageGenerated)message;
            List<AbstractAttachmentGenerated<?>> attachments = ForwardMessageTask.getAttachmentsForMessage(userMessage);
            ViewControllerHelper.smartUIUpdate(() -> {
                if (!attachments.stream().allMatch(ForwardMessageTask::isAttachmentAvailable)) {
                    NCRegistry.getUIActionNC().postNotification(ModalNotification.of(CannotForwardMessageModalController.of(), false));
                    return;
                }
                ForwardMessageModalController controller = new ForwardMessageModalController(userMessage);
                NCRegistry.getUIActionNC().postNotification(new ModalNotification(controller));
            });
        }
    }

    record ReplyAction(MessageItem messageItem) implements Action
    {
        @Override
        public void run() {
            InboundMessage userMessage;
            switch (this.messageItem.getKind()) {
                default: {
                    throw new MatchException(null, null);
                }
                case INBOUND: {
                    AbstractUserMessageGenerated abstractUserMessageGenerated = (InboundMessage)DbManager.getInstance().getInboundMessageDao().get(this.messageItem.getInboundMessage().getItemId());
                    break;
                }
                case OUTBOUND: {
                    AbstractUserMessageGenerated abstractUserMessageGenerated = (OutboundMessage)DbManager.getInstance().getOutboundMessageDao().get(this.messageItem.getOutboundMessage().getItemId());
                    break;
                }
                case OWNED: {
                    AbstractUserMessageGenerated abstractUserMessageGenerated = (OwnedMessage)DbManager.getInstance().getOwnedMessageDao().get(this.messageItem.getOwnedMessage().getItemId());
                    break;
                }
                case SYSTEM: 
                case DISCLAIMER: {
                    AbstractUserMessageGenerated abstractUserMessageGenerated = userMessage = null;
                }
            }
            if (userMessage == null) {
                return;
            }
            MessageRef messageRef = DbManager.getInstance().getMessageRefDao().getOrCreate(userMessage);
            DiscussionApi.updateDraftReplyTo(this.messageItem.getDiscussionId(), Optional.of(messageRef));
        }
    }

    record DeleteAction(MessageItem messageItem, Node node) implements Action
    {
        @Override
        public void run() {
            GroupMemberPermissions ownPermission;
            if (this.messageItem.getKind() == MessageKind.DISCLAIMER) {
                return;
            }
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(this.messageItem.getDiscussionId());
            boolean wasRemotelyDeleted = this.messageItem.wasRemotelyDeleted();
            boolean allowedToDeleteEverywhere = wasRemotelyDeleted ? false : (discussion.isPreDiscussion() ? false : (discussion.isLocked() ? false : (discussion.isGroupDiscussion() ? (ownPermission = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission(discussion.getGroupId().get())).hasPermissionRemoteDeleteAnything() || this.messageItem.wasSentByMe() && ownPermission.hasPermissionEditOrRemoteDeleteOwnMessages() : this.messageItem.wasSentByMe())));
            AbstractMessageGenerated<?> abstractMessageGenerated = this.messageItem.getWeakenedMessage();
            if (abstractMessageGenerated instanceof AbstractUserMessageGenerated) {
                AbstractUserMessageGenerated userMessage = (AbstractUserMessageGenerated)abstractMessageGenerated;
                switch (userMessage.getWipeStatus()) {
                    case NONE: 
                    case WIPE_ON_READ: {
                        break;
                    }
                    case WIPED: 
                    case REMOTE_DELETED: {
                        MessageDeletionHelper.deleteMessagesDbTask(List.of(this.messageItem.getWeakenedMessage()), false);
                        return;
                    }
                }
            }
            boolean finalAmIAllowed = allowedToDeleteEverywhere;
            ViewControllerHelper.smartUIUpdate(() -> {
                DeletePopupInnerController deletePopupInnerController = new DeletePopupInnerController(finalAmIAllowed, everyWhere -> AsyncTaskExecutor.submitTask(() -> MessageDeletionHelper.deleteMessagesDbTask(List.of(this.messageItem.getWeakenedMessage()), everyWhere)));
                Optional<Region> firstRegionOpt = NodeUtils.getFirstParentOfType(this.node, Region.class);
                if (firstRegionOpt.isPresent()) {
                    CustomPopup.loadPopupOnNodeWithPos(deletePopupInnerController.getLayout(), firstRegionOpt.get(), Pos.TOP_CENTER);
                }
            });
        }
    }

    static interface Action
    extends Runnable {
    }
}

