/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_modal_new;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactToggledList;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakDirSearchViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionTabController;
import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FlowConstructor;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/discussions/discussion_modal_new/new_discussion.fxml")
public class NewDiscussionModalController
extends BaseModalController {
    @FXML
    private VBox root;
    @FXML
    private StackPane list_container;
    @FXML
    private VBox new_button_container;
    final KeycloakDirSearchViewModel keycloakDirSearchViewModel = new KeycloakDirSearchViewModel();
    private final Consumer<ActionEvent> contactAction;
    private final Consumer<ActionEvent> groupAction;
    private Runnable close;
    private ChangeListener<String> searchBarsTextPropertyListener = this::searchBarsTextPropertyListener;
    ContactToggledList contactToggledList;

    public void setClose(Runnable close) {
        this.close = close;
    }

    public NewDiscussionModalController(SimpleContext<DiscussionFlowId> context, Runnable close) {
        this.contactAction = event -> context.pushState(DiscussionTabController.DiscussionFlow.NEW_CONTACT);
        this.groupAction = event -> context.pushState(FlowConstructor.GroupFlowStateId.MEMBER_SELECTION);
        this.close = close;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.contactToggledList = new ContactToggledList(Optional.empty(), true);
        this.contactToggledList.createContactListView(this::createNewDiscussionOnClick, false, SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity, false);
        this.contactToggledList.createKeyCloakListView(this.keycloakDirSearchViewModel, Optional.empty(), Optional.of(this.close));
        this.contactToggledList.setHoverable(true);
        this.contactToggledList.init();
        this.list_container.getChildren().add((Object)this.contactToggledList.getLayout());
        this.bindSceneProperty();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.contactToggledList.getOneToOneSearchBarController().getTextProperty().addListener(this.searchBarsTextPropertyListener);
        this.contactToggledList.getOtherSearchBarController().getTextProperty().addListener(this.searchBarsTextPropertyListener);
    }

    @Override
    public void onLayoutDetached() {
        this.contactToggledList.getOneToOneSearchBarController().getTextProperty().removeListener(this.searchBarsTextPropertyListener);
        this.contactToggledList.getOtherSearchBarController().getTextProperty().removeListener(this.searchBarsTextPropertyListener);
    }

    private void searchBarsTextPropertyListener(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
        if (!newValue.isBlank() && oldValue.isBlank() && this.new_button_container.getOpacity() == 1.0 && this.new_button_container.isVisible()) {
            AnimationUtils.vanishOnVBox((Region)this.new_button_container, this.root, 200).play();
        }
        if (newValue.isBlank()) {
            this.new_button_container.setManaged(true);
            this.new_button_container.setVisible(true);
        }
    }

    private void createNewDiscussionOnClick(ContactInfo contact, Node node) {
        if (contact != null) {
            Discussion associatedDiscussion = DbManager.getInstance().getDiscussionDao().getDiscussionByContactId(contact.genId());
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, associatedDiscussion.getItemId()));
            this.close.run();
        }
    }

    @FXML
    private void new_contact(ActionEvent event) {
        this.contactAction.accept(event);
    }

    @FXML
    private void new_group(ActionEvent event) {
        this.groupAction.accept(event);
    }
}

