/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.toggle_switch;

import io.olvid.windows.messenger.fx.custom_components.toggle_switch.SizableRectangle;
import io.olvid.windows.messenger.fx.custom_components.toggle_switch.TSwitch;
import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.skin.LabeledSkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class TSwitchSkin
extends LabeledSkinBase<TSwitch> {
    private final StackPane thumb = new StackPane();
    private final SizableRectangle thumbArea = new SizableRectangle();
    private final TranslateTransition translateTransition = new TranslateTransition();
    private ParallelTransition parallelTransition;
    private final TSwitch control;

    public TSwitchSkin(TSwitch control) {
        super((Labeled)control);
        this.control = control;
        this.initTransition(control);
        this.createInnerPanel();
        this.handleSelectEvent(control);
        this.updateChildren();
        this.selectedStateChanged();
    }

    private void initTransition(TSwitch control) {
        FillTransition paneColorTransition = new FillTransition();
        paneColorTransition.setShape((Shape)this.thumbArea);
        paneColorTransition.toValueProperty().bind(control.colorOnProperty());
        paneColorTransition.fromValueProperty().bind(control.colorOffProperty());
        paneColorTransition.durationProperty().bind(control.animationDurationProperty());
        this.parallelTransition = new ParallelTransition(new Animation[]{paneColorTransition, this.translateTransition});
        this.translateTransition.setNode((Node)this.thumb);
        this.translateTransition.durationProperty().bind(control.animationDurationProperty());
        control.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != oldValue) {
                this.selectedStateChanged();
            }
        });
    }

    private void createInnerPanel() {
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
    }

    private void handleSelectEvent(TSwitch control) {
        control.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.SPACE) {
                control.fire();
            }
        });
        this.thumbArea.setOnMouseReleased(event -> control.fire());
        this.thumb.setOnMouseReleased(event -> control.fire());
    }

    private void selectedStateChanged() {
        Duration currentTime = this.parallelTransition.getCurrentTime();
        this.parallelTransition.stop();
        double rate = 1.0;
        if (this.control.disableAnimationOnNextTransition.getAndSet(false)) {
            rate = 1000.0;
        }
        if (((TSwitch)this.getSkinnable()).isSelected()) {
            this.parallelTransition.setRate(rate);
            this.parallelTransition.jumpTo(currentTime);
        } else {
            this.parallelTransition.setRate(-rate);
            this.parallelTransition.jumpTo(currentTime);
        }
        this.parallelTransition.play();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.thumbArea.minWidth(-1.0));
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(this.snapSizeY(super.computeMinHeight(width - this.thumbArea.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset)), topInset + this.thumbArea.minHeight(-1.0) + bottomInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.thumbArea.prefWidth(-1.0));
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(this.snapSizeY(super.computePrefHeight(width - this.thumbArea.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset)), topInset + this.thumbArea.prefHeight(-1.0) + bottomInset);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double thumbWidth = this.snapSizeX(this.thumb.prefWidth(-1.0));
        double thumbHeight = this.snapSizeY(this.thumb.prefHeight(-1.0));
        this.thumb.resize(thumbWidth, thumbHeight);
        double thumbAreaWidth = this.snapSizeX(this.thumbArea.prefWidth(-1.0));
        double thumbAreaHeight = this.snapSizeY(this.thumbArea.prefHeight(-1.0));
        double thumbAreaY = this.snapPositionY(contentY + contentHeight / 2.0 - thumbAreaHeight / 2.0);
        this.thumbArea.resize(thumbAreaWidth, thumbAreaHeight);
        this.thumbArea.setLayoutX(contentWidth - thumbAreaWidth);
        this.thumbArea.setLayoutX(thumbAreaY);
        double border = (thumbAreaHeight - thumbHeight) / 2.0;
        this.thumb.setLayoutX(this.thumbArea.getLayoutX() + border);
        this.thumb.setLayoutY(thumbAreaY + (thumbAreaHeight - thumbHeight) / 2.0);
        this.translateTransition.setFromX(0.0);
        this.translateTransition.setToX(thumbAreaWidth - thumbWidth - 2.0 * border);
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.thumbArea != null && this.thumb != null) {
            this.getChildren().addAll((Object[])new Node[]{this.thumbArea, this.thumb});
        }
    }
}

