/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.toggle_switch;

import io.olvid.windows.messenger.fx.custom_components.toggle_switch.TSwitchSkin;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class TSwitch
extends ToggleButton {
    private static final String DEFAULT_STYLE_CLASS = "t-switch";
    public static final double DURATION_INITIAL_VALUE = 200.0;
    private static String switchDefaultStyleSheet;
    private static final StyleablePropertyFactory<TSwitch> FACTORY;
    private static final CssMetaData<TSwitch, Color> COLOR_OFF;
    private final StyleableProperty<Color> colorOff = new SimpleStyleableObjectProperty(COLOR_OFF, (Object)this, "color_off");
    private static final CssMetaData<TSwitch, Duration> ANIMATION_DURATION;
    private final StyleableProperty<Duration> animationDuration = new SimpleStyleableObjectProperty(ANIMATION_DURATION, (Object)this, "animation_duration");
    private static final CssMetaData<TSwitch, Color> COLOR_ON;
    private final StyleableProperty<Color> colorOn = new SimpleStyleableObjectProperty(COLOR_ON, (Object)this, "color_on");
    public AtomicBoolean disableAnimationOnNextTransition = new AtomicBoolean(false);

    public TSwitch() {
        this.initialize();
    }

    public TSwitch(String text) {
        super(text);
        this.initialize();
    }

    private void initialize() {
        this.getStylesheets().add((Object)ViewControllerHelper.class.getClassLoader().getResource("fx/custom_ui_components/toggle_switch/tswitch.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.colorOn.setValue((Object)((Color)COLOR_ON.getInitialValue((Styleable)this)));
        this.colorOff.setValue((Object)((Color)COLOR_OFF.getInitialValue((Styleable)this)));
        this.animationDuration.setValue((Object)((Duration)ANIMATION_DURATION.getInitialValue((Styleable)this)));
    }

    protected Skin<?> createDefaultSkin() {
        return new TSwitchSkin(this);
    }

    public ObjectProperty<Color> colorOffProperty() {
        return (ObjectProperty)this.colorOff;
    }

    public ObjectProperty<Color> colorOnProperty() {
        return (ObjectProperty)this.colorOn;
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return (ObjectProperty)this.animationDuration;
    }

    public Color getColorOff() {
        return (Color)this.colorOff.getValue();
    }

    public Color getColorOn() {
        return (Color)this.colorOn.getValue();
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDuration.getValue();
    }

    public void fire() {
        if (!this.isDisabled()) {
            if (!this.selectedProperty().isBound()) {
                this.setSelected(!this.isSelected());
            }
            this.fireEvent((Event)new ActionEvent());
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public void setSelectedWithoutAnimation(boolean value) {
        if (value != this.isSelected()) {
            this.disableAnimationOnNextTransition.set(true);
            this.setSelected(value);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    static {
        FACTORY = new StyleablePropertyFactory(ToggleButton.getClassCssMetaData());
        COLOR_OFF = FACTORY.createColorCssMetaData("-color-off", s -> s.colorOff, Color.GRAY, false);
        ANIMATION_DURATION = FACTORY.createDurationCssMetaData("-animation-duration", s -> s.animationDuration, Duration.millis((double)200.0), false);
        COLOR_ON = FACTORY.createColorCssMetaData("-color-on", s -> s.colorOn, Color.DARKTURQUOISE, false);
    }
}

