/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.file;

import io.olvid.windows.messenger.fx.custom_components.file.LinkPreview;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.OpenGraphLruCache;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;

public class HighDefLinkPreview
extends LinkPreview {
    public HighDefLinkPreview(OpenGraphLruCache openGraphLruCache, DoubleExpression maxWidthBinding) {
        super(openGraphLruCache, maxWidthBinding);
        this.setTop((Node)this.imageView);
        this.getStyleClass().add((Object)"link-preview-image");
        BorderPane.setAlignment((Node)this.imageView, (Pos)Pos.BOTTOM_CENTER);
        this.imageView.fitWidthProperty().bind((ObservableValue)this.maxWidthProperty());
        this.imageView.fitHeightProperty().bind((ObservableValue)this.maxWidthProperty().divide(1.8));
        this.imageView.setPreserveRatio(true);
        this.imageView.fitWidthProperty().addListener((observable, oldValue, newValue) -> this.updateViewPort());
        this.imageView.fitHeightProperty().addListener((observable, oldValue, newValue) -> this.updateViewPort());
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        this.updateViewPort();
    }

    private void updateViewPort() {
        if (this.imageView.getImage() == null) {
            return;
        }
        Rectangle2D rectangle = ImageHelper.croppedImageViewPort(this.imageView.getImage(), this.imageView.getFitWidth(), this.imageView.getFitHeight());
        this.imageView.setViewport(rectangle);
    }

    public static final class Outbound
    extends HighDefLinkPreview {
        public Outbound(OpenGraphLruCache openGraphLruCache, DoubleExpression maxWidthBinding) {
            super(openGraphLruCache, maxWidthBinding);
        }
    }

    public static final class Inbound
    extends HighDefLinkPreview {
        public Inbound(OpenGraphLruCache openGraphLruCache, DoubleExpression maxWidthBinding) {
            super(openGraphLruCache, maxWidthBinding);
        }
    }
}

