/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.custom_controls.popup;

import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopupSkin;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.stage.Window;

public class CustomPopup
extends PopupControl {
    private static final AnchorPane popupControlContainer = new AnchorPane();
    private final Node popupContent;
    private static CustomPopup currentPopUpRef;

    public CustomPopup(Node popupContent) {
        this.popupContent = popupContent;
        if (popupControlContainer.getChildren().isEmpty()) {
            popupControlContainer.getChildren().add(0, (Object)this.popupContent);
        } else {
            popupControlContainer.getChildren().set(0, (Object)this.popupContent);
        }
        this.showingProperty().addListener((o, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                currentPopUpRef = null;
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomPopupSkin(this, popupControlContainer);
    }

    public static void loadCustomPopupWithNodeCoordinates(Node containedNode, double X, double Y) {
        CustomPopup customContextMenu = new CustomPopup(containedNode);
        customContextMenu.setAutoHide(true);
        customContextMenu.show((Window)ViewControllerHelper.MAIN_STAGE, X, Y);
        currentPopUpRef = customContextMenu;
    }

    public static CustomPopup loadPopupOnNodeWithPos(Region containedNode, Region referenceNode, Pos pos) {
        return CustomPopup.loadPopupOnNodeWithPos(containedNode, referenceNode, pos, new Insets(5.0));
    }

    public static CustomPopup loadPopupOnNodeWithPos(Region containedNode, Region referenceNode, Pos pos, Insets insets) {
        CustomPopup customContextMenu = new CustomPopup((Node)containedNode);
        customContextMenu.setAutoHide(true);
        SimpleDoubleProperty refX = new SimpleDoubleProperty();
        SimpleDoubleProperty refY = new SimpleDoubleProperty();
        switch (pos) {
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                refX.bind((ObservableValue)Bindings.createDoubleBinding(() -> referenceNode.localToScreen(referenceNode.getBoundsInLocal()).getCenterX(), (Observable[])new Observable[]{referenceNode.localToSceneTransformProperty(), referenceNode.boundsInLocalProperty(), referenceNode.getScene().getWindow().xProperty()}));
                break;
            }
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                refX.bind((ObservableValue)Bindings.createDoubleBinding(() -> referenceNode.localToScreen(referenceNode.getBoundsInLocal()).getMaxX() + insets.getRight(), (Observable[])new Observable[]{referenceNode.localToSceneTransformProperty(), referenceNode.boundsInLocalProperty(), containedNode.widthProperty(), referenceNode.getScene().getWindow().xProperty()}));
                break;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                refX.bind((ObservableValue)Bindings.createDoubleBinding(() -> referenceNode.localToScreen(referenceNode.getBoundsInLocal()).getMinX() - insets.getLeft(), (Observable[])new Observable[]{referenceNode.localToSceneTransformProperty(), referenceNode.boundsInLocalProperty(), referenceNode.getScene().getWindow().xProperty()}));
                break;
            }
            default: {
                AppLogger.e("The position " + String.valueOf(pos) + " is not supported yet", new IllegalArgumentException());
            }
        }
        switch (pos) {
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                refY.bind((ObservableValue)Bindings.createDoubleBinding(() -> referenceNode.localToScreen(referenceNode.getBoundsInLocal()).getMinY() - insets.getBottom(), (Observable[])new Observable[]{referenceNode.localToSceneTransformProperty(), referenceNode.boundsInLocalProperty(), referenceNode.getScene().getWindow().yProperty()}));
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                refY.bind((ObservableValue)Bindings.createDoubleBinding(() -> referenceNode.localToScreen(referenceNode.getBoundsInLocal()).getMaxY() + insets.getTop(), (Observable[])new Observable[]{referenceNode.localToSceneTransformProperty(), referenceNode.boundsInLocalProperty(), referenceNode.getScene().getWindow().yProperty()}));
                break;
            }
            default: {
                AppLogger.e("The position " + String.valueOf(pos) + " is not supported yet", new IllegalArgumentException());
            }
        }
        SimpleDoubleProperty x = new SimpleDoubleProperty();
        SimpleDoubleProperty y = new SimpleDoubleProperty();
        switch (pos) {
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                y.bind((ObservableValue)Bindings.createDoubleBinding(() -> CustomPopup.lambda$loadPopupOnNodeWithPos$6((DoubleProperty)refY, containedNode), (Observable[])new Observable[]{refY, containedNode.heightProperty()}));
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                y.bind((ObservableValue)refY);
                break;
            }
            default: {
                AppLogger.e("The position " + String.valueOf(pos) + " is not supported yet", new IllegalArgumentException());
            }
        }
        switch (pos) {
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                x.bind((ObservableValue)Bindings.createDoubleBinding(() -> CustomPopup.lambda$loadPopupOnNodeWithPos$7((DoubleProperty)refX, containedNode), (Observable[])new Observable[]{refX, containedNode.widthProperty()}));
                break;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                x.bind((ObservableValue)refX);
                break;
            }
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                x.bind((ObservableValue)Bindings.createDoubleBinding(() -> CustomPopup.lambda$loadPopupOnNodeWithPos$8((DoubleProperty)refX, containedNode), (Observable[])new Observable[]{refX}));
                break;
            }
            default: {
                AppLogger.e("The position " + String.valueOf(pos) + " is not supported yet", new IllegalArgumentException());
            }
        }
        x.addListener((arg_0, arg_1, arg_2) -> CustomPopup.lambda$loadPopupOnNodeWithPos$9(customContextMenu, (DoubleProperty)x, arg_0, arg_1, arg_2));
        y.addListener((arg_0, arg_1, arg_2) -> CustomPopup.lambda$loadPopupOnNodeWithPos$10(customContextMenu, (DoubleProperty)y, arg_0, arg_1, arg_2));
        customContextMenu.show((Window)ViewControllerHelper.MAIN_STAGE, x.get(), y.get());
        currentPopUpRef = customContextMenu;
        customContextMenu.showingProperty().addListener((arg_0, arg_1, arg_2) -> CustomPopup.lambda$loadPopupOnNodeWithPos$11((DoubleProperty)refX, (DoubleProperty)refY, (DoubleProperty)x, (DoubleProperty)y, arg_0, arg_1, arg_2));
        return customContextMenu;
    }

    public static CustomPopup getCurrentPopUpRef() {
        return currentPopUpRef;
    }

    private static /* synthetic */ void lambda$loadPopupOnNodeWithPos$11(DoubleProperty refX, DoubleProperty refY, DoubleProperty x, DoubleProperty y, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (!newVal.booleanValue()) {
            refX.unbind();
            refY.unbind();
            x.unbind();
            y.unbind();
        }
    }

    private static /* synthetic */ void lambda$loadPopupOnNodeWithPos$10(CustomPopup customContextMenu, DoubleProperty y, ObservableValue o, Number oldY, Number newY) {
        customContextMenu.setAnchorY(y.get());
    }

    private static /* synthetic */ void lambda$loadPopupOnNodeWithPos$9(CustomPopup customContextMenu, DoubleProperty x, ObservableValue o, Number oldX, Number newX) {
        customContextMenu.setAnchorX(x.get());
    }

    private static /* synthetic */ Double lambda$loadPopupOnNodeWithPos$8(DoubleProperty refX, Region containedNode) throws Exception {
        return refX.get() - containedNode.getWidth();
    }

    private static /* synthetic */ Double lambda$loadPopupOnNodeWithPos$7(DoubleProperty refX, Region containedNode) throws Exception {
        return refX.get() - containedNode.getWidth() / 2.0;
    }

    private static /* synthetic */ Double lambda$loadPopupOnNodeWithPos$6(DoubleProperty refY, Region containedNode) throws Exception {
        return refY.get() - containedNode.getHeight();
    }
}

