/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.bubbles;

import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class PolarPane
extends Pane {
    private static final String RADIUS = "polar-pane-radius";
    private static final String ANGLE = "polar-pane-angle";
    private boolean square = true;
    private boolean adaptive = true;

    public PolarPane(boolean square, boolean adaptive) {
        this.square = square;
        this.adaptive = adaptive;
    }

    public PolarPane() {
        this.getStyleClass().add((Object)"polar-pane");
    }

    public static void setRadius(Node child, Number radius) {
        PolarPane.setConstraint(child, RADIUS, radius);
    }

    public static void setAngle(Node child, Number angle) {
        PolarPane.setConstraint(child, ANGLE, angle);
    }

    public static void setCoordinate(Node child, Number radius, Number angle) {
        PolarPane.setRadius(child, radius);
        PolarPane.setAngle(child, angle);
    }

    public static Double getRadius(Node child) {
        Object constraint = PolarPane.getConstraint(child, RADIUS);
        if (constraint instanceof Number) {
            Number radius = (Number)constraint;
            return radius.doubleValue();
        }
        return 0.0;
    }

    public static Double getAngle(Node child) {
        Object constraint = PolarPane.getConstraint(child, ANGLE);
        if (constraint instanceof Number) {
            Number angle = (Number)constraint;
            return angle.doubleValue();
        }
        return 0.0;
    }

    protected void layoutChildren() {
        List children = this.getManagedChildren();
        children.forEach(child -> {
            double radius = PolarPane.getRadius(child);
            double angle = PolarPane.getAngle(child);
            double x = this.getWidth() / 2.0 + radius * Math.cos(Math.toRadians(angle)) - child.prefWidth(-1.0) / 2.0;
            double y = this.getHeight() / 2.0 + radius * Math.sin(Math.toRadians(angle)) - child.prefHeight(-1.0) / 2.0;
            this.layoutInArea((Node)child, x, y, child.prefWidth(-1.0), child.prefHeight(-1.0), 0.0, HPos.CENTER, VPos.CENTER);
        });
    }

    protected double computeMinWidth(double height) {
        if (!this.adaptive) {
            return super.computeMinWidth(height);
        }
        if (this.square) {
            return Math.max(this.computeInnerWidth(), this.computeInnerHeight());
        }
        return this.computeInnerWidth();
    }

    protected double computeMinHeight(double width) {
        if (!this.adaptive) {
            return super.computeMinHeight(width);
        }
        if (this.square) {
            return Math.max(this.computeInnerWidth(), this.computeInnerHeight());
        }
        return this.computeInnerHeight();
    }

    protected double computePrefWidth(double height) {
        if (!this.adaptive) {
            return super.computePrefWidth(height);
        }
        return this.computeMinWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (!this.adaptive) {
            return super.computePrefHeight(width);
        }
        return this.computeMinHeight(width);
    }

    private double computeInnerWidth() {
        List children = this.getManagedChildren();
        double max = children.stream().map(child -> {
            Double radius = PolarPane.getRadius(child);
            Double angle = PolarPane.getAngle(child);
            return Math.abs(radius * Math.cos(Math.toRadians(angle))) + child.prefWidth(-1.0) / 2.0;
        }).reduce(0.0, Math::max) * 2.0;
        Insets insets = this.getInsets();
        return insets.getLeft() + max + insets.getRight();
    }

    private double computeInnerHeight() {
        List children = this.getManagedChildren();
        double max = children.stream().map(child -> {
            Double radius = PolarPane.getRadius(child);
            Double angle = PolarPane.getAngle(child);
            return Math.abs(radius * Math.cos(Math.toRadians(angle))) + child.prefWidth(-1.0) / 2.0;
        }).reduce(0.0, Math::max) * 2.0;
        Insets insets = this.getInsets();
        return insets.getTop() + max + insets.getBottom();
    }

    public boolean isSquare() {
        return this.square;
    }

    public void setSquare(boolean square) {
        this.square = square;
    }

    public boolean isAdaptive() {
        return this.adaptive;
    }

    public void setAdaptive(boolean adaptive) {
        this.adaptive = adaptive;
    }

    private static void setConstraint(Node node, Object key, Object value) {
        if (value == null) {
            node.getProperties().remove(key);
        } else {
            node.getProperties().put(key, value);
        }
        if (node.getParent() != null) {
            node.getParent().requestLayout();
        }
    }

    private static Object getConstraint(Node node, Object key) {
        if (node.hasProperties()) {
            return node.getProperties().get(key);
        }
        return null;
    }
}

