/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.bubbles;

import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.Optional;

public class BubbleUtils {
    public static void resetBubbleData(IdentityBubble bubble) {
        bubble.setKeycloakManaged(false);
        bubble.setInitial(Optional.empty());
        bubble.setColorByteSource(new byte[0]);
        bubble.setPhotoUrlRelPath(Optional.empty());
        bubble.setProfilePictureKey(Optional.empty());
        bubble.setGroup(false);
        bubble.setInactive(false);
    }

    public static void setBubbleData(DiscussionInfo discussionInfo, IdentityBubble bubble) {
        if (discussionInfo != null && bubble != null) {
            bubble.setKeycloakManaged(discussionInfo.isKeycloakManaged());
            bubble.setInitial(StringUtils.firstChar(discussionInfo.title().orElse(null)));
            bubble.setColorByteSource(discussionInfo.bytesForInitialView());
            bubble.setPhotoUrlRelPath(discussionInfo.photoUrl());
            bubble.setGroup(discussionInfo.kind() == Discussion.Kind.GROUP || discussionInfo.kind() == Discussion.Kind.PRE_GROUP);
            bubble.setInactive(false);
            bubble.setLocked(discussionInfo.kind() == Discussion.Kind.LOCKED);
        }
    }

    public static void setBubbleData(ContactInfo contact, IdentityBubble contactBubble) {
        if (contact != null && contactBubble != null) {
            contactBubble.setKeycloakManaged(contact.isKeycloakManaged());
            contactBubble.setInitial(StringUtils.firstChar(contact.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
            contactBubble.setColorByteSource(contact.bytesContactIdentity());
            contactBubble.setPhotoUrlRelPath(contact.getCustomPhotoUrlOrPhotoUrl());
            contactBubble.setGroup(false);
            contactBubble.setInactive(false);
        }
    }

    public static void setBubbleData(KeycloakUserDetailsListItemData keycloakUserDetailsListItemData, IdentityBubble contactBubble) {
        if (keycloakUserDetailsListItemData != null && contactBubble != null) {
            contactBubble.setKeycloakManaged(true);
            contactBubble.setInitial(StringUtils.firstChar(keycloakUserDetailsListItemData.firstName));
            contactBubble.setColorByteSource(keycloakUserDetailsListItemData.identity);
            contactBubble.setPhotoUrlRelPath(Optional.empty());
            contactBubble.setGroup(false);
            contactBubble.setInactive(false);
        }
    }

    public static void setBubbleData(OwnedIdentityInfo ownedIdentityInfo, IdentityBubble bubble) {
        if (ownedIdentityInfo != null && bubble != null) {
            bubble.setKeycloakManaged(ownedIdentityInfo.isKeycloakManaged());
            bubble.setInitial(StringUtils.firstChar(ownedIdentityInfo.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
            bubble.setColorByteSource(ownedIdentityInfo.bytesOwnedIdentity());
            bubble.setPhotoUrlRelPath(ownedIdentityInfo.detailsInfo().photoUrl());
            bubble.setGroup(false);
            bubble.setInactive(!ownedIdentityInfo.isActive());
        }
    }

    public static void setBubbleDataTEST(OwnedIdentityInfo ownedIdentityInfo, IdentityBubble bubble, boolean setUrl) {
        if (ownedIdentityInfo != null && bubble != null) {
            bubble.setKeycloakManaged(ownedIdentityInfo.isKeycloakManaged());
            bubble.setInitial(StringUtils.firstChar(ownedIdentityInfo.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
            bubble.setColorByteSource(ownedIdentityInfo.bytesOwnedIdentity());
            if (setUrl) {
                bubble.setPhotoUrlRelPath(ownedIdentityInfo.detailsInfo().photoUrl());
            }
            bubble.setGroup(false);
            bubble.setInactive(!ownedIdentityInfo.isActive());
        }
    }

    public static void setBubbleData(Group group, IdentityBubble groupBubble) {
        if (group != null && groupBubble != null) {
            groupBubble.setKeycloakManaged(group.isKeycloakManaged());
            groupBubble.setColorByteSource(group.getBytesGroupIdentifier());
            groupBubble.setPhotoUrlRelPath(group.getCustomPhotoUrlOrPhotoUrl());
            groupBubble.setGroup(true);
            groupBubble.setInactive(false);
        }
    }

    public static void setBubbleData(PendingGroupMemberInfo pendingGroupMember, IdentityBubble groupBubble) {
        IdentityDetailsInfo identityDetailsInfo = pendingGroupMember.detailsInfo();
        groupBubble.setInitial(StringUtils.firstChar(identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY)));
        groupBubble.setColorByteSource(pendingGroupMember.bytesContactIdentity());
        if (pendingGroupMember.contactInfo().isEmpty()) {
            groupBubble.setPhotoUrlRelPath(identityDetailsInfo.photoUrl());
            groupBubble.setKeycloakManaged(false);
        } else {
            groupBubble.setKeycloakManaged(pendingGroupMember.contactInfo().get().isKeycloakManaged());
            groupBubble.setPhotoUrlRelPath(pendingGroupMember.contactInfo().get().getCustomPhotoUrlOrPhotoUrl());
        }
        groupBubble.setGroup(false);
        groupBubble.setInactive(false);
    }

    public static void setBubbleData(IdentityInfo identityInfo, IdentityBubble bubble) {
        if (identityInfo == null || bubble == null) {
            return;
        }
        if (identityInfo.isMe()) {
            BubbleUtils.setBubbleData(identityInfo.getOwnedIdentityInfo(), bubble);
        } else {
            identityInfo.getContactInfo().ifPresent(contact -> BubbleUtils.setBubbleData(contact, bubble));
        }
    }
}

