/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.misc.Result;
import java.util.Objects;
import java.util.concurrent.Callable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class LoadingViewController<View extends Pane, Configuration, Failure>
extends BaseViewController {
    private final View view;
    private final ConfiguratorDelegate<View, Configuration, Failure> configurator;
    private final StackPane stackPane = new StackPane();
    final StackPane viewAndLabel = new StackPane();
    private final ProgressIndicator progressIndicator = new ProgressIndicator();
    private final Button button = new Button();
    private final Label label = new Label();

    private LoadingViewController(View view, ConfiguratorDelegate<View, Configuration, Failure> configurator) {
        Objects.requireNonNull(view);
        Objects.requireNonNull(configurator);
        this.view = view;
        this.configurator = configurator;
        this.stackPane.getChildren().add((Object)this.viewAndLabel);
        this.viewAndLabel.setAlignment(Pos.CENTER);
        this.viewAndLabel.getChildren().add(view);
        this.viewAndLabel.getChildren().add((Object)this.label);
        this.stackPane.getChildren().add((Object)this.progressIndicator);
        this.stackPane.getChildren().add((Object)this.button);
        this.updateViewToShow(State.PROGRESS);
    }

    public static <View extends Pane, Configuration, Failure> LoadingViewController<View, Configuration, Failure> make(View view, ConfiguratorDelegate<View, Configuration, Failure> configurator) {
        return new LoadingViewController<View, Configuration, Failure>(view, configurator);
    }

    public void run(Callable<Result<Configuration, Failure>> computeConfiguration) {
        this.updateViewToProgress();
        AsyncTaskExecutor.submitTask(() -> {
            try {
                Result configurationResult = (Result)computeConfiguration.call();
                this.displayOnImageResult(configurationResult);
            }
            catch (Exception e) {
                this.onImageComputeFail(e);
            }
        });
    }

    private void onImageComputeFail(Exception e) {
        ViewControllerHelper.smartUIUpdate(() -> this.configurator.configureError(Result.failure(e)));
    }

    public void displayOnImageResult(Result<Configuration, Failure> configurationResult) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (configurationResult.isSuccess()) {
                this.configurator.configureView(this.view, configurationResult.getSuccess());
                this.updateViewToShow(State.STATE);
            } else {
                this.configurator.configureError(configurationResult);
            }
        });
    }

    public void updateViewToProgress() {
        this.updateViewToShow(State.PROGRESS);
    }

    public void showButton() {
        this.configurator.configureButton(this.button);
        this.button.setOnMouseClicked(e -> this.configurator.buttonHandler());
        this.updateViewToShow(State.BUTTON);
    }

    public void showLabel(String text) {
        this.configurator.configureLabel(this.label);
        this.label.setText(text);
        this.updateViewToShow(State.LABEL);
    }

    public void showProgression(float progress) {
        this.progressIndicator.setProgress((double)progress);
        this.updateViewToShow(State.PROGRESS);
    }

    public View getView() {
        return this.view;
    }

    @Override
    public Region getLayout() {
        return this.stackPane;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void updateViewToShow(State status) {
        if (status.showButton()) {
            ViewControllerHelper.showNode((Node)this.button);
        } else {
            ViewControllerHelper.hideNode((Node)this.button);
        }
        if (status.showProgress()) {
            ViewControllerHelper.showNode((Node)this.progressIndicator);
        } else {
            ViewControllerHelper.hideNode((Node)this.progressIndicator);
        }
        if (status.showView() || status.showLabel()) {
            ViewControllerHelper.showNode((Node)this.viewAndLabel);
        } else {
            ViewControllerHelper.hideNode((Node)this.viewAndLabel);
        }
        if (status.showView()) {
            ViewControllerHelper.showNode(this.view);
        } else {
            ViewControllerHelper.hideNode(this.view);
        }
        if (status.showLabel()) {
            ViewControllerHelper.showNode((Node)this.label);
        } else {
            ViewControllerHelper.hideNode((Node)this.label);
        }
    }

    public static interface ConfiguratorDelegate<View extends Node, Configuration, Failure> {
        public void configureView(View var1, Configuration var2);

        public void configureError(Result<Configuration, Failure> var1);

        public void configureButton(Button var1);

        public void configureLabel(Label var1);

        public void buttonHandler();
    }

    private static enum State {
        STATE,
        PROGRESS,
        BUTTON,
        LABEL,
        VIEW_AND_LABEL;


        boolean showButton() {
            return this == BUTTON;
        }

        boolean showProgress() {
            return this == PROGRESS;
        }

        boolean showView() {
            return this == STATE || this == VIEW_AND_LABEL;
        }

        boolean showLabel() {
            return this == LABEL || this == VIEW_AND_LABEL;
        }
    }
}

