/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Text;

public class HeightBindTextArea
extends TextArea {
    public static final String MAX_SIZE_LETTER = "W";
    private final Text sizeHelper = new Text();
    private final DoubleProperty textHeight = new SimpleDoubleProperty();
    private final ReadOnlyDoubleProperty containerWidth;

    public HeightBindTextArea(ReadOnlyDoubleProperty readOnlyDoubleProperty) {
        this.setWrapText(true);
        this.prefHeightProperty().bind((ObservableValue)this.textHeight);
        this.containerWidth = readOnlyDoubleProperty;
        this.containerWidth.addListener((observable, oldValue, newValue) -> this.layoutChildren());
        this.setTextFormatter(new TextFormatter(change -> {
            change.setText(change.getText().replace("\n", ""));
            return change;
        }));
        this.addEventHandler(KeyEvent.KEY_TYPED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.getTextBounds();
    }

    protected double computePrefWidth(double width) {
        return this.containerWidth.get();
    }

    protected double computePrefHeight(double height) {
        Bounds bounds = this.getTextBounds();
        Insets insets = this.getInsets();
        return Math.ceil(bounds.getHeight() + insets.getLeft() + insets.getRight());
    }

    public Bounds getTextBounds() {
        Object text = "";
        text = this.getParagraphs().stream().map(p -> String.valueOf(p) + "W\n").reduce((String)text, String::concat);
        text = (String)text + MAX_SIZE_LETTER;
        this.sizeHelper.setText((String)text);
        this.sizeHelper.setFont(this.getFont());
        this.sizeHelper.setWrappingWidth(this.containerWidth.get());
        Bounds layoutBounds = this.sizeHelper.getLayoutBounds();
        this.textHeight.set(layoutBounds.getHeight());
        return layoutBounds;
    }
}

