/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components;

import com.sun.javafx.collections.MappingChange;
import io.olvid.windows.messenger.fx.custom_components.CastedList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class CastedObservableList<T extends S, S>
extends CastedList<T, S>
implements ObservableList<T> {
    private final ObservableList<S> source;
    private final Map<ListChangeListener<? super T>, ListChangeListener<? super S>> listenerMap = new IdentityHashMap<ListChangeListener<? super T>, ListChangeListener<? super S>>();

    public CastedObservableList(Class<T> clazz, ObservableList<S> source) {
        super(clazz, source);
        this.source = source;
    }

    public void addListener(ListChangeListener<? super T> tListener) {
        if (this.listenerMap.containsKey(tListener)) {
            return;
        }
        ListChangeListener sListener = cs -> {
            MappingChange ct = new MappingChange(cs, this.clazz::cast, (ObservableList)this);
            tListener.onChanged((ListChangeListener.Change)ct);
        };
        this.listenerMap.put(tListener, sListener);
        this.source.addListener(sListener);
    }

    public void removeListener(ListChangeListener<? super T> tListener) {
        if (!this.listenerMap.containsKey(tListener)) {
            return;
        }
        ListChangeListener<? super S> sListener = this.listenerMap.get(tListener);
        this.source.removeListener(sListener);
    }

    @SafeVarargs
    public final boolean addAll(T ... elements) {
        return this.source.addAll((Object[])elements);
    }

    @SafeVarargs
    public final boolean setAll(T ... elements) {
        return this.source.setAll((Object[])elements);
    }

    public boolean setAll(Collection<? extends T> col) {
        return this.source.setAll(col);
    }

    @SafeVarargs
    public final boolean removeAll(T ... elements) {
        return this.source.removeAll((Object[])elements);
    }

    @SafeVarargs
    public final boolean retainAll(T ... elements) {
        return this.source.retainAll((Object[])elements);
    }

    public void remove(int from, int to) {
        this.source.remove(from, to);
    }

    public void addListener(InvalidationListener listener) {
        this.source.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.source.removeListener(listener);
    }
}

