/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.keycloak;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class KeycloakSearchResultCellController
extends AbstractListCell<KeycloakUserDetailsListItemData> {
    private final BubbleAndDescription bubbleAndDescription;
    public final StackPane check_stack_pane = new StackPane();

    public KeycloakSearchResultCellController(boolean selectable) {
        this.bubbleAndDescription = new BubbleAndDescription();
        this.bubbleAndDescription.rightVBox.getChildren().add((Object)this.check_stack_pane);
        this.initListCell(selectable);
        BorderPane.setMargin((Node)this.bubbleAndDescription.bubble, (Insets)new Insets(0.0, 12.0, 0.0, 4.0));
    }

    @Override
    protected void updateItem(KeycloakUserDetailsListItemData keycloakUserDetailsListItemData, boolean empty) {
        super.updateItem(keycloakUserDetailsListItemData, empty);
        if (empty || keycloakUserDetailsListItemData == null) {
            this.setGraphic(null);
            return;
        }
        JsonIdentityDetails jsonIdentityDetails = new JsonIdentityDetails(keycloakUserDetailsListItemData.firstName, keycloakUserDetailsListItemData.lastName, keycloakUserDetailsListItemData.position, keycloakUserDetailsListItemData.company);
        this.bubbleAndDescription.title.setText(jsonIdentityDetails.formatDisplayName("%f %l", false));
        this.bubbleAndDescription.setSubtitle(Optional.ofNullable(jsonIdentityDetails.formatPositionAndCompany("%f %l (%p @ %c)")));
        BubbleUtils.setBubbleData(keycloakUserDetailsListItemData, this.bubbleAndDescription.bubble);
        this.setGraphic((Node)this.bubbleAndDescription);
    }

    @Override
    protected Pane getCheckBoxParent() {
        return this.check_stack_pane;
    }
}

