/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list.toggle;

import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactTab;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactToggleFilterController;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakDirSearchViewModel;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakSearchResultCellController;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerManager;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.BuilderInterface;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.jetbrains.annotations.NotNull;

public class ContactToggledList
extends BaseViewController {
    public static final double BOTTOM_MARGIN = 70.0;
    private final ContactToggleFilterController contactToggleFilterController;
    private final StackPane listviewStack = new StackPane();
    private final VBox root;
    private final Optional<Double> bottomMargin;
    private KeycloakDirSearchViewModel keycloakDirSearchViewModel;
    private final SearchBarController oneToOneSearchBarController;
    private final SearchBarController otherSearchBarController;
    private final SearchBarController keycloakSearchBarController;
    private ListPanelSelectModel<ContactInfo> contactSelectModel;
    private final ChangeListener<ContactTab> contactTabChangeListener = this::contactSegControlChangeListener;
    private final ViewControllerManager<ContactTab> viewControllerManager = new ViewControllerManager(ViewControllerManager.ManagementMode.LAZY);
    private final HashMap<ContactTab, Callable<BaseViewController>> controllerFactories = new HashMap();
    private final LiveDataListener<Optional<OwnedIdentityInfo>> selectedOwnedIdListener = this::selectedOwnedIdentityListener;
    private boolean hoverable;
    private final boolean addKeycloakDirectoryTab;

    public ContactToggledList(Optional<Double> bottomMargin, boolean addKeycloakDirectoryTab) {
        this.bottomMargin = bottomMargin;
        this.addKeycloakDirectoryTab = addKeycloakDirectoryTab;
        this.listviewStack.setId("list_view_container");
        this.root = new VBox();
        this.root.setId("ListViewContainer");
        this.root.setFillWidth(true);
        this.oneToOneSearchBarController = new SearchBarController();
        VBox.setMargin((Node)this.oneToOneSearchBarController.getLayout(), (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.otherSearchBarController = new SearchBarController();
        VBox.setMargin((Node)this.otherSearchBarController.getLayout(), (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.keycloakSearchBarController = new SearchBarController();
        VBox.setMargin((Node)this.keycloakSearchBarController.getLayout(), (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.contactToggleFilterController = new ContactToggleFilterController();
        VBox.setMargin((Node)this.contactToggleFilterController.getLayout(), (Insets)new Insets(18.0, 10.0, 16.0, 10.0));
        this.root.getChildren().add((Object)this.contactToggleFilterController.getLayout());
        this.root.getChildren().addAll((Object[])new Node[]{this.listviewStack});
        VBox.setVgrow((Node)this.listviewStack, (Priority)Priority.ALWAYS);
        this.contactToggleFilterController.getTabProperty().addListener(this.contactTabChangeListener);
        SelectedOwnedIdentitySingleton.getInstance().addListener(this.selectedOwnedIdListener);
    }

    private void contactSegControlChangeListener(ObservableValue<? extends ContactTab> observable, ContactTab oldValue, ContactTab newValue) {
        this.viewControllerManager.replaceView(newValue, (Pane)this.listviewStack, null, null);
        if (newValue == ContactTab.DIRECTORY) {
            this.keycloakDirSearchViewModel.customReSearch("");
        }
    }

    private void selectedOwnedIdentityListener(Optional<OwnedIdentityInfo> newVal, Optional<OwnedIdentityInfo> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (oldValue != null && oldValue.isPresent()) {
                this.oneToOneSearchBarController.textField.replaceText("");
                this.otherSearchBarController.textField.replaceText("");
            }
            if (newVal != null && newVal.isPresent() && !newVal.equals(oldValue)) {
                this.contactToggleFilterController.setKeycloakAvailable(this.addKeycloakDirectoryTab && ((OwnedIdentityInfo)newVal.get()).isKeycloakManaged());
                if (ContactTab.DIRECTORY == this.contactToggleFilterController.getTabProperty().get()) {
                    this.contactToggleFilterController.selectContact();
                }
            }
        });
    }

    public void createContactListView(BiConsumer<ContactInfo, Node> onItemClickAction, Boolean selectable, LiveData<List<ContactInfo>> liveData, boolean multiSelectionEnabled) {
        this.createContactListView(onItemClickAction, liveData, multiSelectionEnabled, (Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>>)((Callback)param -> new ContactListCell(selectable)));
    }

    public void createContactListView(BiConsumer<ContactInfo, Node> onItemClickAction, LiveData<List<ContactInfo>> contactsLiveData, boolean multiSelectionEnabled, Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>> listViewListCellCallback) {
        Objects.requireNonNull(contactsLiveData);
        this.contactSelectModel = new ListPanelSelectModel(multiSelectionEnabled, false);
        LiveData<List<ContactInfo>> oneToOneFilteredLivedata = ListLiveData.filter(contactsLiveData, ContactInfo::isOneToOne);
        LiveData<List<ContactInfo>> collectedFilteredLiveData = ListLiveData.filter(contactsLiveData, Predicate.not(ContactInfo::isOneToOne));
        this.controllerFactories.put(ContactTab.CONTACT, () -> this.buildContactListViewController(onItemClickAction, listViewListCellCallback, oneToOneFilteredLivedata, this.oneToOneSearchBarController));
        this.controllerFactories.put(ContactTab.OTHER, () -> this.buildContactListViewController(onItemClickAction, listViewListCellCallback, collectedFilteredLiveData, this.otherSearchBarController));
    }

    private BaseViewController buildContactListViewController(BiConsumer<ContactInfo, Node> onItemClickAction, Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>> listViewListCellCallback, LiveData<List<ContactInfo>> contactsLiveData, SearchBarController searchBarController) {
        StandardPanelListController<ContactInfo> standardListViewController = StandardPanelListController.builder().withLiveData(contactsLiveData).withDataClass(ContactInfo.class).withCellFactory(listViewListCellCallback).withFixBottomMargin(this.bottomMargin).setComparator(Comparator.naturalOrder()).noFilter().setSearchBar(searchBarController).setSearchPredicate(ListItemSearchHelper::contactSearchPredicate).setListSelectionModel(this.contactSelectModel).withSingleSelection().withDisableUnselect(true).withoutButton(onItemClickAction).build();
        standardListViewController.getListView().setFixedCellSize(70.0);
        VBox.setMargin(standardListViewController.getListView(), (Insets)new Insets(12.0, 8.0, 0.0, 8.0));
        if (this.hoverable) {
            standardListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        }
        return standardListViewController;
    }

    private BaseViewController buildKeycloakSearchResultListViewController(LiveData<List<KeycloakUserDetailsListItemData>> keycloakUserDetailsListItemDataListFilterLiveData, Consumer<String> customSearchTextConsumer, Optional<ListPanelSelectModel<KeycloakUserDetailsListItemData>> selectionModel, Callback<ListView<KeycloakUserDetailsListItemData>, AbstractListCell<KeycloakUserDetailsListItemData>> listViewListCellCallback, BiConsumer<KeycloakUserDetailsListItemData, Node> onClick) {
        this.contactToggleFilterController.setKeycloakAvailable(true);
        BuilderInterface.Selectable<KeycloakUserDetailsListItemData> selectable = StandardPanelListController.builder().withLiveData(keycloakUserDetailsListItemDataListFilterLiveData).withDataClass(KeycloakUserDetailsListItemData.class).withCellFactory(listViewListCellCallback).withFixBottomMargin(this.bottomMargin).setComparator(Comparator.comparing(ContactToggledList::keyExtractor)).noFilter().setSearchBar(this.keycloakSearchBarController).setCustomSearchTextConsumer(customSearchTextConsumer);
        if (selectionModel.isPresent()) {
            selectable = selectable.setListSelectionModel(selectionModel.get());
        }
        StandardPanelListController<KeycloakUserDetailsListItemData> standardListViewController = selectable.withMultipleSelection().withoutButton(onClick).build();
        standardListViewController.getListView().setFixedCellSize(70.0);
        VBox.setMargin(standardListViewController.getListView(), (Insets)new Insets(12.0, 8.0, 0.0, 8.0));
        if (this.hoverable) {
            standardListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        }
        return standardListViewController;
    }

    @NotNull
    private static String keyExtractor(KeycloakUserDetailsListItemData item) {
        if (item.lastName == null || item.lastName.isEmpty()) {
            if (item.firstName == null || item.firstName.isEmpty()) {
                return " ";
            }
            return " " + item.firstName;
        }
        return item.lastName;
    }

    public void createKeyCloakListView(KeycloakDirSearchViewModel keycloakDirSearchViewModel, Optional<ListPanelSelectModel<KeycloakUserDetailsListItemData>> selectionModel, Optional<Runnable> closeDelegateOpt) {
        this.createKeyCloakListView(keycloakDirSearchViewModel, selectionModel, (Callback<ListView<KeycloakUserDetailsListItemData>, AbstractListCell<KeycloakUserDetailsListItemData>>)((Callback)param -> new KeycloakSearchResultCellController(false)), (keycloakUserDetailsListItemData, node) -> {
            UIActionNC.fireKeycloakSelectedNotification(Optional.of(keycloakUserDetailsListItemData), true);
            closeDelegateOpt.ifPresent(Runnable::run);
        });
    }

    public void createKeyCloakListView(KeycloakDirSearchViewModel keycloakDirSearchViewModel, Optional<ListPanelSelectModel<KeycloakUserDetailsListItemData>> selectionModel, Callback<ListView<KeycloakUserDetailsListItemData>, AbstractListCell<KeycloakUserDetailsListItemData>> cellFactory, BiConsumer<KeycloakUserDetailsListItemData, Node> onClick) {
        this.keycloakDirSearchViewModel = keycloakDirSearchViewModel;
        this.contactToggleFilterController.setKeycloakAvailable(true);
        this.controllerFactories.put(ContactTab.DIRECTORY, () -> this.buildKeycloakSearchResultListViewController(this.keycloakDirSearchViewModel.getKeycloakUserDetailsList(), s -> this.keycloakDirSearchViewModel.customReSearch((String)s), selectionModel, cellFactory, onClick));
    }

    public void init() {
        this.viewControllerManager.registerChildrenControllers(this.controllerFactories);
        this.viewControllerManager.replaceView((ContactTab)((Object)this.contactToggleFilterController.getTabProperty().get()), (Pane)this.listviewStack, AnimationConfiguration.AnimationEnumType.FADE_IN, AnimationConfiguration.AnimationEnumType.FADE_OUT);
    }

    public void configureSearchBarListener() {
    }

    public VBox getLayout() {
        return this.root;
    }

    public SearchBarController getOneToOneSearchBarController() {
        return this.oneToOneSearchBarController;
    }

    public SearchBarController getOtherSearchBarController() {
        return this.otherSearchBarController;
    }

    public ListPanelSelectModel<ContactInfo> getContactSelectModel() {
        return this.contactSelectModel;
    }

    @Override
    public void onLayoutAttached() {
        SelectedOwnedIdentitySingleton.getInstance().addListener(this.selectedOwnedIdListener);
    }

    @Override
    public void onLayoutDetached() {
        SelectedOwnedIdentitySingleton.getInstance().removeListener(this.selectedOwnedIdListener);
    }

    public void setHoverable(boolean b) {
        this.hoverable = b;
    }
}

