/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class ContactListCell
extends AbstractListCell<ContactInfo> {
    private final BubbleAndDescription bubbleAndDescription;
    private final StackPane checkBoxContainer = new StackPane();
    private Optional<ContactInfo> lastKnownContactInfo = Optional.empty();

    public ContactListCell(boolean selectable) {
        this.bubbleAndDescription = new BubbleAndDescription();
        this.bubbleAndDescription.setRight((Node)this.checkBoxContainer);
        this.initListCell(selectable);
        BorderPane.setMargin((Node)this.bubbleAndDescription.bubble, (Insets)new Insets(0.0, 12.0, 0.0, 4.0));
    }

    @Override
    public void updateItem(ContactInfo contact, boolean empty) {
        super.updateItem(contact, empty);
        if (empty || contact == null) {
            this.lastKnownContactInfo = Optional.empty();
            this.setGraphic(null);
            return;
        }
        if (this.lastKnownContactInfo.isPresent() && this.lastKnownContactInfo.get().equals(contact)) {
            return;
        }
        BubbleUtils.setBubbleData(contact, this.bubbleAndDescription.bubble);
        this.bubbleAndDescription.title.setText(contact.customDisplayName().orElse(contact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
        this.bubbleAndDescription.setSubtitle(Optional.ofNullable(contact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY)));
        this.lastKnownContactInfo = Optional.of(contact);
        this.setGraphic((Node)this.bubbleAndDescription);
    }

    @Override
    protected Pane getCheckBoxParent() {
        return this.checkBoxContainer;
    }
}

