/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalListSelectionView;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class AddGroupMemberModalController
extends BaseModalController {
    public static final double BOTTOM_MARGIN = 70.0;
    private final Group group;
    private final ListPanelSelectModel<ContactInfo> selectModel;
    private final Consumer<List<Id<Contact>>> onAdd;
    private final StackPane container = new StackPane();
    private final ModalListSelectionView modalListSelectionView;

    public AddGroupMemberModalController(Group group, Consumer<List<Id<Contact>>> onAdd, List<ContactInfo> alreadySelected) {
        AppLogger.t("AddGroupMemberModalController::AddGroupMemberModalController()");
        this.group = group;
        this.onAdd = onAdd;
        LiveData nonMembersLiveData = LiveDataFactory.buildDbLiveDataList(Contact.class, () -> DbManager.getInstance().getContactDao().getSortedNonGroupMembers(this.group));
        LiveData<List<Contact>> allowedNonMembersLiveData = ListLiveData.filter(nonMembersLiveData, contact -> {
            if (contact.getEstablishedChannelCount() == 0) {
                return false;
            }
            if (group.isV2()) {
                Id<Capabilities> capabilitiesId = contact.getCapabilitiesId();
                Capabilities capabilities = DbManager.getInstance().getCapabilitiesDao().get(capabilitiesId);
                return capabilities.isGroupsV2();
            }
            return true;
        });
        LiveData allowedNonMembersInfoLiveData = SelectedOwnedIdentitySingleton.getInstance().of(allowedNonMembersLiveData);
        StandardPanelListController<ContactInfo> selectableContactListViewController = StandardPanelListController.builder().withLiveData(allowedNonMembersInfoLiveData).withDataClass(ContactInfo.class).withCellFactory((Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>>)((Callback)param -> {
            ContactListCell listCell = new ContactListCell(true);
            listCell.prefWidthProperty().bind((ObservableValue)param.widthProperty());
            listCell.setMaxWidth(Double.NEGATIVE_INFINITY);
            listCell.setMinWidth(Double.NEGATIVE_INFINITY);
            return listCell;
        })).withFixBottomMargin(Optional.of(70.0)).defaultComparator().noFilter().setSearchPredicate(ListItemSearchHelper::contactSearchPredicate).withMultipleSelection().withoutButton().build();
        ViewControllerHelper.smartUIUpdate(() -> {
            selectableContactListViewController.getListView().setFixedCellSize(70.0);
            selectableContactListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        });
        this.selectModel = selectableContactListViewController.getSelectionModel();
        alreadySelected.forEach(this.selectModel::selectItem);
        this.modalListSelectionView = new ModalListSelectionView((Node)selectableContactListViewController.getLayout());
        this.modalListSelectionView.title.setText(ViewControllerHelper.getString("modal.add_group_members.title").formatted(group.getDisplayName().orElse(ViewControllerHelper.getString("unnamed_group"))));
        this.container.getChildren().setAll((Object[])new Node[]{this.modalListSelectionView});
        this.modalListSelectionView.closeButton.setOnMouseClicked(event -> this.closeModalDelegate.run());
        this.modalListSelectionView.validateButton.setOnMouseClicked(this::onValidateClicked);
        this.setSize(ModalConfiguration.ModalSize.MEDIUM);
    }

    protected void onValidateClicked(MouseEvent mouseEvent) {
        if (this.selectModel.getSelectedItems() == null) {
            AppLogger.d("Empty contact list selected fo presentation");
            this.closeModalDelegate.run();
            return;
        }
        this.onAdd.accept(this.selectModel.getSelectedItems().stream().map(ContactInfo::getItemId).toList());
        this.closeModalDelegate.run();
    }

    public StackPane getLayout() {
        return this.container;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
    }
}

