/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list;

import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.ButtonController;
import io.olvid.windows.messenger.fx.helpers.SizeObserver;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/contacts/contacts_list/contact_selection_view.fxml")
public abstract class AbstractContactSelectionModalController<InputType extends Diffable>
extends BaseModalController {
    @FXML
    protected VBox container;
    protected InputType associatedEntity;
    protected StandardPanelListController<ContactInfo> selectableContactListViewController;
    protected ButtonController buttonController = new ButtonController((EventHandler<MouseEvent>)((EventHandler)this::validateHandler), (EventHandler<MouseEvent>)((EventHandler)this::cancelHandler));

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        AppLogger.t("SimpleContactSelectionModalController::Initialize");
        this.container.getChildren().add(0, (Object)this.selectableContactListViewController.getLayout());
        VBox.setVgrow((Node)this.selectableContactListViewController.getLayout(), (Priority)Priority.ALWAYS);
        if (!this.getSize().equals((Object)ModalConfiguration.ModalSize.SELF_SIZE)) {
            ReadOnlyDoubleProperty buttonWidth = SizeObserver.getObservableSizePercent((ReadOnlyDoubleProperty)this.getModalWidth(), 50);
            this.buttonController.bindButtonWidth(buttonWidth);
            ReadOnlyDoubleProperty buttonHeight = SizeObserver.getObservableSizePercentWithMax((ReadOnlyDoubleProperty)this.getModalWidth(), 20, 40.0);
            this.buttonController.bindButtonHeight(buttonHeight);
            this.selectableContactListViewController.getListView().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        }
    }

    @Override
    public Region getLayout() {
        return this.container;
    }

    protected void cancelHandler(MouseEvent event) {
        AppLogger.t("RemoveGroupMemberModalController::cancelHandler");
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (this.closeModalDelegate != null) {
            this.closeModalDelegate.run();
        }
    }

    protected abstract void validateHandler(MouseEvent var1);
}

