/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contact_details;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;

public class ContactCardModel {
    private final LiveData<List<Group>> customAssociatedGroupListLiveData;
    private final BooleanProperty editMode = new SimpleBooleanProperty(false);
    private final BooleanProperty oneToOne = new SimpleBooleanProperty(false);
    private final StringProperty photoTempPath = new SimpleStringProperty();
    private final BooleanProperty keycloakManaged = new SimpleBooleanProperty(false);
    private final BooleanProperty contactActive = new SimpleBooleanProperty(false);
    private final BooleanProperty isReachable = new SimpleBooleanProperty(false);
    private final BooleanProperty disableInviteProperty = new SimpleBooleanProperty(false);
    public final Id<Contact> contactId;

    public ContactCardModel(Id<Contact> contactId) {
        this.contactId = contactId;
        this.customAssociatedGroupListLiveData = LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact(contactId, true), List.of(Group.class, ContactGroupJoin.class));
        this.disableInviteProperty.bind((ObservableValue)this.oneToOne.or((ObservableBooleanValue)this.isReachable.not().and((ObservableBooleanValue)this.keycloakManaged.not())).or((ObservableBooleanValue)this.contactActive.not()));
    }

    public Optional<ContactInfo> getContactInfo() {
        return DbCache.getInstance().getContactInfo(this.contactId);
    }

    public LiveData<List<Group>> getCustomAssociatedGroupListLiveData() {
        return this.customAssociatedGroupListLiveData;
    }

    public Discussion getAssociatedDiscussion() {
        return DbManager.getInstance().getDiscussionDao().getDiscussionByContactId(this.contactId);
    }

    public boolean isEditMode() {
        return this.editMode.get();
    }

    public BooleanProperty editModeProperty() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode.set(editMode);
    }

    public boolean isOneToOne() {
        return this.oneToOne.get();
    }

    public BooleanProperty oneToOneProperty() {
        return this.oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne.set(oneToOne);
    }

    public String getPhotoTempPath() {
        return (String)this.photoTempPath.get();
    }

    public StringProperty photoTempPathProperty() {
        return this.photoTempPath;
    }

    public void setPhotoTempPath(String photoTempPath) {
        this.photoTempPath.set((Object)photoTempPath);
    }

    public BooleanProperty keycloakManagedProperty() {
        return this.keycloakManaged;
    }

    public void setKeycloak(boolean keycloak) {
        this.keycloakManaged.set(keycloak);
    }

    public boolean getIsReachable() {
        return this.isReachable.get();
    }

    public BooleanProperty isReachableProperty() {
        return this.isReachable;
    }

    public void setIsReachable(boolean isReachable) {
        this.isReachable.set(isReachable);
    }

    public void setContactActive(boolean active) {
        this.contactActive.set(active);
    }

    public BooleanProperty disableInvite() {
        return this.disableInviteProperty;
    }

    public BooleanProperty activeProperty() {
        return this.contactActive;
    }
}

