/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contact_details;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;
import io.olvid.windows.messenger.fx.contacts.contact_details.ContactCardModel;
import io.olvid.windows.messenger.fx.contacts.contact_details.GroupItem;
import io.olvid.windows.messenger.fx.contacts.contacts_list.IntroduceContactModalController;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.bubbles.PolarPane;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.lib.OlvidBindings;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextHolder;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;

@FXMLView(path="fx/contacts/contact_details/contact_card.fxml")
public class ContactCardController
extends BaseViewController {
    @FXML
    private VBox groups_box;
    @FXML
    private Region root;
    @FXML
    private Label name_label;
    @FXML
    private TextField name_text_field;
    @FXML
    private Label position_label;
    @FXML
    private Button recreate_channel;
    @FXML
    private Button delete_contact;
    @FXML
    private Button bubble_button;
    @FXML
    private Button open_discussion;
    @FXML
    private Button add_contact;
    @FXML
    private Button introduce_contact;
    @FXML
    private Button close_button;
    @FXML
    private Button previous_button;
    @FXML
    private Button modification_button;
    @FXML
    private StackPane camera;
    @FXML
    private IdentityBubble contact_bubble;
    @FXML
    private Button channel_creation_button;
    @FXML
    private VBox channel_creation_box;
    private LiveDataListener<List<Group>> groupListener;
    private final ContactCardModel model;
    private final LiveDataListener<Optional<ContactInfo>> listener = this::onContactChange;
    private final RightPanelContextHolder navigation;
    private LiveDataListener<Boolean> navigationEmptyLiveDataListener;
    private final ObservableList<Group> groups = FXCollections.observableArrayList();

    public ContactCardController(Id<Contact> contactID, RightPanelContextHolder navigation) {
        this.logger.trace("ContactCard::ContactCard");
        this.navigation = navigation;
        this.model = new ContactCardModel(contactID);
        this.loadFxml();
        DbCache.getInstance().contactInfoMapLiveData.addListener(contactID, this.listener);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.logger.trace("ContactCard::initialize");
        this.groupListener = (newValue, oldValue) -> {
            if (newValue != null) {
                ViewControllerHelper.smartUIUpdate(() -> this.groups.setAll((Collection)newValue));
            }
        };
        OlvidBindings.bindMappedContent(this.groups_box.getChildren(), this.groups, this::createGroupItem);
        this.model.getCustomAssociatedGroupListLiveData().addListener(this.groupListener);
        this.initButtonModification();
        this.initBubble();
        this.initTextArea();
        this.initDiscussionButtons();
        this.delete_contact.setOnAction(this::handleDeleteButton);
        this.recreate_channel.setOnAction(event -> {
            if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isEmpty() || this.model.getContactInfo().isEmpty()) {
                return;
            }
            byte[] bytesOwnedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity();
            byte[] bytesContactIdentity = this.model.getContactInfo().get().bytesContactIdentity();
            try {
                EngineWrapper.getInstance().recreateAllChannels(bytesOwnedIdentity, bytesContactIdentity);
            }
            catch (Exception e) {
                this.logger.error("Cannot recreate channels with %s".formatted(this.model.getContactInfo().get().genId()), e);
            }
        });
        this.close_button.setOnAction(event -> this.close());
        this.previous_button.managedProperty().bind((ObservableValue)this.previous_button.visibleProperty());
        this.navigationEmptyLiveDataListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.previous_button.visibleProperty().set(newValue == false));
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().addListener(this.navigationEmptyLiveDataListener);
        this.previous_button.disableProperty().bind((ObservableValue)this.model.editModeProperty());
        this.previous_button.setOnAction(event -> this.navigation.goToPrevious());
        this.channel_creation_box.managedProperty().bind((ObservableValue)this.channel_creation_box.visibleProperty());
        this.channel_creation_box.visibleProperty().bind((ObservableValue)this.model.isReachableProperty().not().and((ObservableBooleanValue)this.model.keycloakManagedProperty().not()));
        this.handleChannelCreation();
    }

    private void close() {
        if (this.model.editModeProperty().get()) {
            this.stopEditing();
        } else {
            this.navigation.close();
        }
    }

    private void handleChannelCreation() {
        this.channel_creation_button.setOnAction(event -> this.model.getContactInfo().ifPresent(contactInfo -> {
            try {
                EngineWrapper.getInstance().recreateAllChannels(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().orElseThrow(IllegalStateException::new).bytesOwnedIdentity(), this.model.getContactInfo().get().bytesContactIdentity());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private Node createGroupItem(Group group) {
        Button item = new GroupItem(group).getLayout();
        item.setOnAction(event -> this.handleGroupSelected((Id<Group>)group.getItemId()));
        return item;
    }

    private void initDiscussionButtons() {
        this.open_discussion.setOnAction(this::handleGoToDiscussion);
        this.open_discussion.managedProperty().bind((ObservableValue)this.open_discussion.visibleProperty());
        this.open_discussion.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty());
        this.add_contact.setOnAction(this::handleUpgradeOneToOneButton);
        this.add_contact.managedProperty().bind((ObservableValue)this.add_contact.visibleProperty());
        this.add_contact.visibleProperty().bind((ObservableValue)this.model.disableInvite().not());
        this.introduce_contact.setOnAction(this::handlePresentationButton);
        this.introduce_contact.managedProperty().bind((ObservableValue)this.introduce_contact.visibleProperty());
        this.introduce_contact.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty());
    }

    private void initBubble() {
        OlvidBindings.bindClass((Node)this.bubble_button).to((ObservableValue<String>)Bindings.when((ObservableBooleanValue)this.model.editModeProperty()).then("bubble_edit").otherwise("bubble_inert"));
        this.bubble_button.disableProperty().bind((ObservableValue)this.model.editModeProperty().not());
        this.bubble_button.setOnAction(this::handleModifyContactPhoto);
        this.bubble_button.setGraphic((Node)this.contact_bubble);
        this.camera.managedProperty().bind((ObservableValue)this.camera.visibleProperty());
        this.camera.visibleProperty().bind((ObservableValue)this.model.editModeProperty());
        PolarPane.setAngle((Node)this.camera, 45);
        PolarPane.setRadius((Node)this.camera, this.contact_bubble.getRadius());
    }

    private void initTextArea() {
        this.name_label.managedProperty().bind((ObservableValue)this.name_label.visibleProperty());
        this.name_label.visibleProperty().bind((ObservableValue)this.model.editModeProperty().not());
        this.name_text_field.managedProperty().bind((ObservableValue)this.name_text_field.visibleProperty());
        this.name_text_field.visibleProperty().bind((ObservableValue)this.model.editModeProperty());
    }

    private void initButtonModification() {
        this.modification_button.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.model.editModeProperty()).then(ViewControllerHelper.getString("group_card_modification_button_save")).otherwise(ViewControllerHelper.getString("group_card_modification_button_modify")));
        this.modification_button.setOnAction(event -> {
            if (this.model.editModeProperty().get()) {
                this.save();
                this.model.editModeProperty().set(false);
            } else {
                this.model.editModeProperty().set(true);
            }
        });
    }

    private void save() {
        String currentPhoto;
        String displayName;
        this.logger.trace("ContactCard::handleEditContactNickname");
        if (this.model.getContactInfo().isEmpty()) {
            return;
        }
        ContactInfo contact = this.model.getContactInfo().get();
        String currentTitle = this.name_text_field.getText() == null ? null : this.name_text_field.getText().trim().replace("\n", " ");
        if (!Objects.equals(currentTitle, displayName = contact.customDisplayName().orElse(contact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)))) {
            if (currentTitle == null || currentTitle.isEmpty()) {
                AsyncTaskExecutor.submitTask(() -> ContactApi.editContactNicknameDbTask(contact.genId(), Optional.empty()));
            } else {
                AsyncTaskExecutor.submitTask(() -> ContactApi.editContactNicknameDbTask(contact.genId(), Optional.of(currentTitle)));
            }
        }
        if (!Objects.equals(currentPhoto = (String)this.model.photoTempPathProperty().get(), this.model.getContactInfo().get().getCustomPhotoUrlOrPhotoUrl().orElse(null))) {
            this.model.getContactInfo().ifPresent(contactInfo -> AsyncTaskExecutor.submitTask(() -> DbManager.getInstance().getContactDao().updateContactCustomUrl(contactInfo.genId(), currentPhoto)));
        }
    }

    private void stopEditing() {
        this.model.getContactInfo().flatMap(ContactInfo::getCustomPhotoUrlOrPhotoUrl).ifPresentOrElse(s -> {
            if (!Objects.equals(s, this.model.getPhotoTempPath())) {
                this.model.setPhotoTempPath((String)s);
                this.contact_bubble.setPhotoUrlRelPath(Optional.of(s));
            }
        }, () -> {
            this.model.setPhotoTempPath(null);
            this.contact_bubble.setPhotoUrlRelPath(Optional.empty());
        });
        this.model.editModeProperty().set(false);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.logger.trace("ContactCard::onLayoutDetached");
        DbCache.getInstance().contactInfoMapLiveData.removeListener(this.model.contactId, this.listener);
        this.model.getCustomAssociatedGroupListLiveData().removeListener(this.groupListener);
        OlvidBindings.unbindMappedContent(this.groups_box.getChildren(), this.groups);
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().removeListener(this.navigationEmptyLiveDataListener);
    }

    private void onContactChange(Optional<ContactInfo> newContactOpt, Optional<ContactInfo> oldContact) {
        this.logger.trace("ContactCard::onChange");
        if (newContactOpt.isEmpty()) {
            if (oldContact != null && oldContact.isPresent() && !this.navigation.goToPrevious()) {
                this.navigation.close();
            }
            return;
        }
        ContactInfo newContact = newContactOpt.get();
        if (!newContact.areContentTheSame(oldContact)) {
            this.logger.trace("ContactCard::setContent");
            ViewControllerHelper.smartUIUpdate(() -> {
                this.model.setKeycloak(newContact.isKeycloakManaged());
                this.model.setOneToOne(newContact.isOneToOne());
                this.model.setIsReachable(newContact.isReachable());
                this.model.setContactActive(newContact.isActive());
                this.model.setPhotoTempPath(newContact.getCustomPhotoUrlOrPhotoUrl().orElse(null));
                BubbleUtils.setBubbleData(newContact, this.contact_bubble);
                String displayName = newContact.customDisplayName().orElse(newContact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
                this.name_label.setText(displayName);
                String position = newContact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY);
                this.position_label.setText(position);
                this.name_text_field.setText((String)newContact.customDisplayName().orElse(null));
            });
        }
    }

    private void handleGroupSelected(Id<Group> group) {
        if (group == null) {
            return;
        }
        RightPanelContextState.GroupCard newState = new RightPanelContextState.GroupCard(group);
        this.navigation.getRightPanelContext().updateLocalContext(newState, false);
    }

    private void handlePresentationButton(Event event) {
        this.logger.trace("ContactCard::handlePresentationButton");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(new IntroduceContactModalController(contactInfoOpt.get())));
    }

    private void handleDeleteButton(Event event) {
        this.logger.trace("ContactCard::handleDeleteButton");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        ContactInfo contactInfo = contactInfoOpt.get();
        String displayName = contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY);
        AsyncTaskExecutor.submitTask(() -> {
            Contact contact = DbManager.getInstance().getContactDao().get(contactInfo.genId());
            Boolean result = ContactApi.deleteContactDbTask(contact);
            if (result == null) {
                this.logger.debug("Unexpected error when deleting: " + displayName);
            } else if (!result.booleanValue()) {
                this.logger.debug("Unable to delete " + displayName + ", contact still in group");
            } else {
                this.logger.debug("Deleted Contact: " + displayName);
                Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
                if (discussion != null && discussion.isContactDiscussion() && discussion.getContactId().isPresent() && DbCache.getInstance().getContactInfo(discussion.getContactId().get()).isPresent() && Arrays.equals(DbCache.getInstance().getContactInfo(discussion.getContactId().get()).get().bytesContactIdentity(), contact.getBytesContactIdentity())) {
                    NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, null));
                    this.navigation.close();
                }
            }
        });
    }

    private void handleUpgradeOneToOneButton(Event event) {
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        ContactInfo contactInfo = contactInfoOpt.get();
        if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent()) {
            OwnedIdentityInfo ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get();
            if (this.model.keycloakManagedProperty().get()) {
                KeycloakManager.getInstance().addContactWithEngineSignedDetails(ownedIdentity.bytesOwnedIdentity(), contactInfo.bytesContactIdentity());
            }
            AsyncTaskExecutor.submitTask(() -> ContactApi.upgradeContactToOneToOne((ContactInfo)contactInfoOpt.get(), ownedIdentity.bytesOwnedIdentity()));
        }
    }

    private void handleGoToDiscussion(Event event) {
        this.logger.trace("ContactCard::handleGoToDiscussion");
        AsyncTaskExecutor.submitTask(() -> {
            Discussion associatedDiscussion = this.model.getAssociatedDiscussion();
            DiscussionApi.unHideDiscussionIfHiddenDbTask(associatedDiscussion);
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, associatedDiscussion.getItemId()));
        });
    }

    private void handleModifyContactPhoto(ActionEvent event) {
        this.logger.trace("ContactCard::handleModifyContactPhoto");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("photo_chooser_title"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File homeFile = homePath == null ? null : new File(homePath);
        fileChooser.setInitialDirectory(homeFile);
        File photo = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (photo != null && !photo.getAbsolutePath().isEmpty()) {
            AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(photo.getAbsolutePath(), 1080, 1080, photoTempPath -> {
                this.model.setPhotoTempPath((String)photoTempPath);
                this.contact_bubble.setPhotoUrlRelPath(Optional.of(photoTempPath));
            }, error -> this.logger.error("GroupManagementService: importAndUpdateGroupPhotoTask: task error: ", (Exception)error)));
        }
    }
}

