/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactToggledList;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakDirSearchViewModel;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakSearchResultCellController;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.invitations.InvitationViewController;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.BaseNavBarTab;
import io.olvid.windows.messenger.fx.modal.qrcode.QrCodeModalController;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.SingleId;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class ContactsTabController
extends BaseNavBarTab {
    final KeycloakDirSearchViewModel keycloakDirSearchViewModel = new KeycloakDirSearchViewModel();
    private final VBox listViewContainer = this.initiateInnerNode(this.keycloakDirSearchViewModel);
    private Button tabButton;
    private ContactToggledList contactToggledList;

    public ContactsTabController() {
        VBox.setVgrow((Node)this.listViewContainer, (Priority)Priority.ALWAYS);
        super.buildStandardTab(Either.left(ViewControllerHelper.RESOURCE_BUNDLE.getString("left.panel.contact.title")), Optional.empty(), Optional.of("svg-new-contact"), Optional.of(ContactsTabController::newContactModal), Optional.empty(), AppRuntimeHelper.isDevMode ? Optional.of(ContactsTabController::toDELETEParameters) : Optional.empty(), Optional.empty(), new Node[]{this.listViewContainer});
        this.tabButton = this.createButton("svg-contacts");
    }

    private VBox initiateInnerNode(KeycloakDirSearchViewModel keycloakDirSearchViewModel) {
        this.contactToggledList = new ContactToggledList(Optional.empty(), true);
        this.contactToggledList.createContactListView((contact, node) -> AsyncTaskExecutor.submitTask(() -> {
            Discussion discussion;
            if (contact != null && contact.isOneToOne() && (discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByContactId(contact.genId())) != null) {
                NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, discussion.getItemId()));
                return;
            }
            UIActionNC.fireContactSelectedNotification(Optional.ofNullable(contact).map(ContactInfo::genId), true);
        }), SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity, false, (Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>>)((Callback)param -> new ChevronContactListCell()));
        ListPanelSelectModel keycloakUserSelectModel = new ListPanelSelectModel(true, false);
        this.contactToggledList.createKeyCloakListView(keycloakDirSearchViewModel, Optional.of(keycloakUserSelectModel), (Callback<ListView<KeycloakUserDetailsListItemData>, AbstractListCell<KeycloakUserDetailsListItemData>>)((Callback)param -> new KeycloakSearchResultCellController(false)), (keycloakUser, node) -> UIActionNC.fireKeycloakSelectedNotification(Optional.ofNullable(keycloakUser), true));
        this.contactToggledList.setHoverable(true);
        this.contactToggledList.init();
        return this.contactToggledList.getLayout();
    }

    public static void newContactModal(ActionEvent event) {
        ModalFlowController<SingleId> flowController = new ModalFlowController<SingleId>();
        QrCodeModalController.builder(flowController).addInModalStateFlow(SingleId.SINGLE_STATE, flowController);
        flowController.setState(SingleId.SINGLE_STATE);
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(flowController));
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        UIActionNC.fireContactSelectedNotification(Optional.empty(), true);
    }

    @Override
    public Region getLayout() {
        return this.tabContainer;
    }

    @Override
    public Button getNavBarButton() {
        return this.tabButton;
    }

    @Override
    public SvgSizeable getNavBarButtonIcon() {
        return (SvgSizeable)this.tabButton.getGraphic();
    }

    private static void toDELETEParameters(ActionEvent event) {
        InvitationViewController invitationViewController = new InvitationViewController();
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(invitationViewController));
        AppLogger.i("Parameters ... contact button not implement yet: TODO MODEL");
    }

    private static class ChevronContactListCell
    extends ContactListCell {
        public ChevronContactListCell() {
            super(false);
            SvgSizeable svgSizeable = new SvgSizeable();
            svgSizeable.getStyleClass().addAll((Object[])new String[]{"svg-chevron", "icon-medium"});
            this.getCheckBoxParent().getChildren().add((Object)svgSizeable);
        }
    }
}

