/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SettingsSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String SEND_READ_RECEIPT = "send_read_receipt";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(List.of("send_read_receipt"));
    public Boolean send_read_receipt;
    public String auto_join_groups;
    public HashSet<String> domain;

    public static SettingsSyncSnapshot of(DbManager dbManager) {
        SettingsSyncSnapshot settingsSyncSnapshot = new SettingsSyncSnapshot();
        settingsSyncSnapshot.send_read_receipt = dbManager.getApplicationSettingsDao().getSendReadReceiptSetting();
        settingsSyncSnapshot.domain = DEFAULT_DOMAIN;
        return settingsSyncSnapshot;
    }

    @JsonIgnore
    public void restore(DbManager db) {
        if (this.domain.contains(SEND_READ_RECEIPT)) {
            db.getApplicationSettingsDao().updateApplicationSetting(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY, Optional.of(String.valueOf(this.send_read_receipt != null && this.send_read_receipt != false)));
        }
    }

    @JsonIgnore
    public boolean getSend_read_receipt() {
        return this.send_read_receipt != null && this.send_read_receipt != false;
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof SettingsSyncSnapshot)) {
            return false;
        }
        SettingsSyncSnapshot other = (SettingsSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "send_read_receipt": {
                    if (this.getSend_read_receipt() == other.getSend_read_receipt()) break;
                    return false;
                }
            }
        }
        return true;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        if (!(otherSnapshotNode instanceof SettingsSyncSnapshot)) {
            throw new Exception();
        }
        SettingsSyncSnapshot other = (SettingsSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        ArrayList<ObvSyncDiff> diffs = new ArrayList<ObvSyncDiff>();
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "send_read_receipt": {
                    if (this.getSend_read_receipt() == other.getSend_read_receipt()) break;
                    diffs.add(ObvSyncDiff.createSettingSendReadReceipt((boolean)this.getSend_read_receipt(), (boolean)other.getSend_read_receipt()));
                }
            }
        }
        return diffs;
    }
}

