/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.sync.OwnedIdentitySyncSnapshot;
import io.olvid.windows.messenger.engine.sync.SettingsSyncSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String OWNED_IDENTITY = "owned_identity";
    public static final String SETTINGS = "settings";
    public static final String OWNED_IDENTITY_NODE = "owned_identity_node";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("owned_identity", "settings", "owned_identity_node"));
    public byte[] owned_identity;
    public SettingsSyncSnapshot settings;
    public OwnedIdentitySyncSnapshot owned_identity_node;
    public HashSet<String> domain;

    public static AppSyncSnapshot of(DbManager db, byte[] bytesOwnedIdentity) {
        AppSyncSnapshot appSyncSnapshot = new AppSyncSnapshot();
        appSyncSnapshot.owned_identity = bytesOwnedIdentity;
        OwnedIdentity ownedIdentity = db.getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity != null) {
            appSyncSnapshot.settings = SettingsSyncSnapshot.of(db);
            appSyncSnapshot.owned_identity_node = OwnedIdentitySyncSnapshot.of(db, ownedIdentity);
        }
        appSyncSnapshot.domain = DEFAULT_DOMAIN;
        return appSyncSnapshot;
    }

    @JsonIgnore
    public void restore(DbManager db) throws Exception {
        if (!this.domain.contains(OWNED_IDENTITY) || !this.domain.contains(OWNED_IDENTITY_NODE)) {
            Logger.e((String)("Trying to restore an incomplete IdentityManagerSyncSnapshot. Domain: " + String.valueOf(this.domain)));
            throw new Exception();
        }
        OwnedIdentity ownedIdentity = db.getOwnedIdentityDao().get(this.owned_identity);
        if (ownedIdentity == null) {
            Logger.e((String)"Trying to restore a snapshot of an unknown owned identity");
            throw new Exception();
        }
        TransactionWrapper.startStatementTransaction(() -> {
            if (this.domain.contains(SETTINGS) && this.settings != null) {
                this.settings.restore(db);
            }
            this.owned_identity_node.restore(db, ownedIdentity);
            return null;
        });
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof AppSyncSnapshot)) {
            return false;
        }
        AppSyncSnapshot other = (AppSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "owned_identity": {
                    if (Arrays.equals(this.owned_identity, other.owned_identity)) break;
                    return false;
                }
                case "settings": {
                    if (this.settings.areContentsTheSame(other.settings)) break;
                    return false;
                }
                case "owned_identity_node": {
                    if (this.owned_identity_node.areContentsTheSame(other.owned_identity_node)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        if (!(otherSnapshotNode instanceof AppSyncSnapshot)) {
            throw new Exception();
        }
        AppSyncSnapshot other = (AppSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        ArrayList<ObvSyncDiff> diffs = new ArrayList<ObvSyncDiff>();
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "owned_identity": {
                    if (Arrays.equals(this.owned_identity, other.owned_identity)) break;
                    throw new Exception();
                }
                case "settings": {
                    diffs.addAll(this.settings.computeDiff(other.settings));
                    break;
                }
                case "owned_identity_node": {
                    diffs.addAll(this.owned_identity_node.computeDiff(other.owned_identity_node));
                }
            }
        }
        return diffs;
    }
}

