/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.sync.OwnedIdentityDeviceSnapshot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppDeviceSnapshot
implements ObvSyncSnapshotNode {
    public static final String OWNED_IDENTITIES = "owned_identities";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(List.of("owned_identities"));
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, OwnedIdentityDeviceSnapshot> owned_identities;
    public HashSet<String> domain;

    public static AppDeviceSnapshot of(DbManager db) {
        AppDeviceSnapshot appDeviceSnapshot = new AppDeviceSnapshot();
        appDeviceSnapshot.owned_identities = new HashMap();
        for (OwnedIdentity ownedIdentity : db.getOwnedIdentityDao().getAll()) {
            appDeviceSnapshot.owned_identities.put(new ObvBytesKey(ownedIdentity.getBytesOwnedIdentity()), OwnedIdentityDeviceSnapshot.of(db, ownedIdentity));
        }
        appDeviceSnapshot.domain = DEFAULT_DOMAIN;
        return appDeviceSnapshot;
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

