/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.engine.types.EngineNotificationListener;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.SimpleEngineNotificationListener;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.sync.AppDeviceSnapshot;
import io.olvid.windows.messenger.engine.sync.AppSyncSnapshot;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;

public class AppBackupAndSyncDelegate
implements ObvBackupAndSyncDelegate {
    EngineNotificationListener engineNotificationListener;

    public String getTag() {
        return "app";
    }

    public ObvSyncSnapshotNode getSyncSnapshot(Identity ownedIdentity) {
        return AppSyncSnapshot.of(DbManager.getInstance(), ownedIdentity.getBytes());
    }

    public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreOwnedIdentity(final ObvIdentity obvOwnedIdentity, final ObvSyncSnapshotNode node) throws Exception {
        if (!(node instanceof AppSyncSnapshot)) {
            throw new Exception();
        }
        if (!Arrays.equals(((AppSyncSnapshot)node).owned_identity, obvOwnedIdentity.getBytesIdentity())) {
            Logger.e((String)"Trying to restoreOwnedIdentity for the wrong owned identity");
            throw new Exception();
        }
        IdentityDetails details = new IdentityDetails(obvOwnedIdentity.getIdentityDetails());
        Capabilities capabilities = new Capabilities(ObvCapability.currentCapabilities.contains(ObvCapability.WEBRTC_CONTINUOUS_ICE), ObvCapability.currentCapabilities.contains(ObvCapability.GROUPS_V2), ObvCapability.currentCapabilities.contains(ObvCapability.ONE_TO_ONE_CONTACTS));
        capabilities = DbManager.getInstance().getCapabilitiesDao().createIfNotExists(capabilities);
        details = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(details);
        Objects.requireNonNull(capabilities);
        Objects.requireNonNull(details);
        OwnedIdentity ownedIdentity = new OwnedIdentity(obvOwnedIdentity, OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN, details, capabilities);
        DbManager.getInstance().getOwnedIdentityDao().insert(ownedIdentity);
        return new ObvBackupAndSyncDelegate.RestoreFinishedCallback(){

            public void onRestoreSuccess() {
                AsyncTaskExecutor.submitTask(() -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        EngineWrapper.getInstance().registerToPushNotification(obvOwnedIdentity.getBytesIdentity(), false, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (obvOwnedIdentity.isKeycloakManaged()) {
                        try {
                            ObvKeycloakState keycloakState = EngineWrapper.getInstance().getOwnedIdentityKeycloakState(obvOwnedIdentity.getBytesIdentity());
                            if (keycloakState != null) {
                                KeycloakManager.getInstance().registerKeycloakManagedIdentity(obvOwnedIdentity.getBytesIdentity(), keycloakState.keycloakServer, keycloakState.clientId, keycloakState.clientSecret, keycloakState.jwks, keycloakState.signatureKey, keycloakState.serializedAuthState, null, 0L, true, keycloakState.transferRestricted);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity(DbManager.getInstance().getOwnedIdentityDao().get(((AppSyncSnapshot)node2).owned_identity));
                });
            }

            public void onRestoreFailure() {
                OwnedIdentity ownedIdentityObject = DbManager.getInstance().getOwnedIdentityDao().get(obvOwnedIdentity.getBytesIdentity());
                if (ownedIdentityObject != null) {
                    DbManager.getInstance().getOwnedIdentityDao().customDelete(ownedIdentityObject);
                }
            }
        };
    }

    public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreSyncSnapshot(final ObvSyncSnapshotNode node) throws Exception {
        if (!(node instanceof AppSyncSnapshot)) {
            throw new Exception();
        }
        if (this.engineNotificationListener != null) {
            EngineWrapper.getInstance().removeNotificationListener("engine_notification_engine_snapshot_restoration_finished", this.engineNotificationListener);
        }
        this.engineNotificationListener = new SimpleEngineNotificationListener("engine_notification_engine_snapshot_restoration_finished"){

            public void callback(HashMap<String, Object> userInfo) {
                EngineWrapper.getInstance().removeNotificationListener("engine_notification_engine_snapshot_restoration_finished", (EngineNotificationListener)this);
                AppBackupAndSyncDelegate.this.engineNotificationListener = null;
                try {
                    ((AppSyncSnapshot)node).restore(DbManager.getInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return new ObvBackupAndSyncDelegate.RestoreFinishedCallback(){

            public void onRestoreSuccess() {
                EngineWrapper.getInstance().addNotificationListener("engine_notification_engine_snapshot_restoration_finished", AppBackupAndSyncDelegate.this.engineNotificationListener);
            }

            public void onRestoreFailure() {
                AppBackupAndSyncDelegate.this.engineNotificationListener = null;
            }
        };
    }

    public ObvSyncSnapshotNode getDeviceSnapshot() {
        return AppDeviceSnapshot.of(DbManager.getInstance());
    }

    public Map<String, String> getAdditionalProfileInfo(Identity ownedIdentity) {
        return Map.of("platform", AppRuntimeHelper.platform.toString());
    }

    public byte[] serialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, ObvSyncSnapshotNode snapshotNode) throws Exception {
        switch (serializationContext) {
            case DEVICE: {
                if (snapshotNode instanceof AppDeviceSnapshot) break;
                throw new Exception("AppBackupDelegate can only serialize AppDeviceSnapshot");
            }
            case PROFILE: {
                if (snapshotNode instanceof AppSyncSnapshot) break;
                throw new Exception("AppBackupDelegate can only serialize AppSyncSnapshot");
            }
        }
        return EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)snapshotNode);
    }

    public ObvSyncSnapshotNode deserialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, byte[] serializedSnapshotNode) throws Exception {
        return switch (serializationContext) {
            default -> throw new MatchException(null, null);
            case ObvBackupAndSyncDelegate.SerializationContext.DEVICE -> (AppDeviceSnapshot)EngineWrapper.getJsonObjectMapper().readValue(serializedSnapshotNode, AppDeviceSnapshot.class);
            case ObvBackupAndSyncDelegate.SerializationContext.PROFILE -> (AppSyncSnapshot)EngineWrapper.getJsonObjectMapper().readValue(serializedSnapshotNode, AppSyncSnapshot.class);
        };
    }

    private static class AppRestoreFinishedCallback
    implements ObvBackupAndSyncDelegate.RestoreFinishedCallback {
        private final Semaphore callbackSemaphore;
        public boolean success = false;

        public AppRestoreFinishedCallback(Semaphore callbackSemaphore) {
            this.callbackSemaphore = callbackSemaphore;
        }

        public void onRestoreSuccess() {
            this.success = true;
            this.callbackSemaphore.release();
        }

        public void onRestoreFailure() {
            this.callbackSemaphore.release();
        }
    }
}

