/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.service;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.OutboundMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.OwnedMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.engine.service.AbstractExpirationTimerService;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ForceScheduleNextMessageExpirationTaskNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ShareCurrentDiscussionNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class MessageExpirationService
extends AbstractExpirationTimerService {
    private static Discussion selectedDiscussion = null;
    static NotificationType.NotificationEnumType[] notificationsToListen = new NotificationType.NotificationEnumType[]{UtilityNC.UtilityNotificationEnumType.FORCE_SCHEDULE_NEXT_EXPIRATION_HANDLING_TASK, UtilityNC.UtilityNotificationEnumType.SHARE_CURRENT_DISCUSSION_FOR_NEXT_EXPIRATION_HANDLING_TASK};
    private static final MessageExpirationService instance = new MessageExpirationService();

    public static MessageExpirationService getInstance() {
        return instance;
    }

    private MessageExpirationService() {
        NCRegistry.getUtilityNC().subscribe(notificationsToListen, this::messageExpirationServiceNotificationListener);
    }

    private void messageExpirationServiceNotificationListener(NotificationType notification) {
        if (notification instanceof ForceScheduleNextMessageExpirationTaskNotification) {
            this.scheduleNextExpiration();
        } else if (notification instanceof ShareCurrentDiscussionNotification) {
            selectedDiscussion = ((ShareCurrentDiscussionNotification)notification).currentSelectedDiscussion;
        } else {
            this.logger.debug("messageExpirationServiceNotificationListener : we don't handle this notification here " + String.valueOf(notification.getNotificationType()));
        }
    }

    @Override
    protected Optional<Long> getNextExpiration() {
        Optional<Long> inboundExpirationTimestamp = DbManager.getInstance().getInboundMessageEphemeralInfoDao().getNextExpiration();
        Optional<Long> outboundExpirationTimestamp = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().getNextExpiration();
        Optional<Long> ownedExpirationTimestamp = DbManager.getInstance().getOwnedMessageEphemeralInfoDao().getNextExpiration();
        return OptionalUtils.longMin(OptionalUtils.longMin(inboundExpirationTimestamp, outboundExpirationTimestamp), ownedExpirationTimestamp);
    }

    @Override
    protected void expirationAction() {
        boolean retain;
        AbstractUserMessageGenerated message;
        this.logger.debug("MessageExpirationHelper::wipeExpiredMessages");
        long currentTimeMillis = System.currentTimeMillis();
        List inboundMessageEphemeralInfos = DbManager.getInstance().getInboundMessageEphemeralInfoDao().getAllExpired(currentTimeMillis);
        List outboundMessageEphemeralInfos = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().getAllExpired(currentTimeMillis);
        List ownedMessageEphemeralInfos = DbManager.getInstance().getOwnedMessageEphemeralInfoDao().getAllExpired(currentTimeMillis);
        this.logger.info("%d outbound message(s) to delete", outboundMessageEphemeralInfos.size());
        this.logger.info("%d inbound message(s) to delete", inboundMessageEphemeralInfos.size());
        this.logger.info("%d owned message(s) to delete", ownedMessageEphemeralInfos.size());
        ArrayList<AbstractUserMessageGenerated> messagesToWipe = new ArrayList<AbstractUserMessageGenerated>();
        ArrayList<AbstractUserMessageGenerated> messagesToDelete = new ArrayList<AbstractUserMessageGenerated>();
        for (AbstractMessageEphemeralInfoGenerated info : inboundMessageEphemeralInfos) {
            message = (InboundMessage)DbManager.getInstance().getInboundMessageDao().getMessage(info.getItemId());
            if (message == null) {
                this.logger.debug("MessageExpirationHelper::wipeExpiredMessages cannot found inbound message for expiration info %d", ((Id)info.getItemId()).getId());
                continue;
            }
            messagesToDelete.add(message);
        }
        for (AbstractMessageEphemeralInfoGenerated info : outboundMessageEphemeralInfos) {
            message = DbManager.getInstance().getOutboundMessageDao().getMessage((Id<OutboundMessageEphemeralInfo>)info.getItemId());
            if (message == null) {
                this.logger.debug("MessageExpirationHelper::wipeExpiredMessages cannot found outbound message for expiration info %d", ((Id)info.getItemId()).getId());
                continue;
            }
            if (((OutboundMessageEphemeralInfoGenerated)info).isRetainWipedMessage()) {
                messagesToWipe.add(message);
                continue;
            }
            messagesToDelete.add(message);
        }
        for (AbstractMessageEphemeralInfoGenerated info : ownedMessageEphemeralInfos) {
            message = DbManager.getInstance().getOwnedMessageDao().getMessage((Id)info.getItemId());
            if (message == null) {
                this.logger.debug("MessageExpirationHelper::wipeExpiredMessages cannot found owned message for expiration info %d", ((Id)info.getItemId()).getId());
                continue;
            }
            if (((OwnedMessageEphemeralInfoGenerated)info).isRetainWipedMessage()) {
                messagesToWipe.add(message);
                continue;
            }
            messagesToDelete.add(message);
        }
        for (InboundMessage message2 : DbManager.getInstance().getInboundMessageDao().getAllWipeOnRead()) {
            if (selectedDiscussion != null && Objects.equals(message2.getDiscussionId(), selectedDiscussion.getItemId())) continue;
            messagesToDelete.add(message2);
        }
        boolean defaultRetainPolicy = false;
        HashMap<Id, Boolean> discussionRetainMap = new HashMap<Id, Boolean>();
        Function<Id, Boolean> isDiscussionRetain = discussionId -> {
            DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussionId);
            if (discussionCustomization == null) {
                return defaultRetainPolicy;
            }
            return discussionCustomization.getPrefRetainWipedOutboundMessages().orElse(defaultRetainPolicy);
        };
        for (AbstractUserMessageGenerated message3 : DbManager.getInstance().getOutboundMessageDao().getAllWipeOnRead()) {
            if (selectedDiscussion != null && Objects.equals(message3.getDiscussionId(), selectedDiscussion.getItemId())) continue;
            retain = discussionRetainMap.computeIfAbsent(message3.getDiscussionId(), isDiscussionRetain);
            if (retain) {
                messagesToWipe.add(message3);
                continue;
            }
            messagesToDelete.add(message3);
        }
        for (AbstractUserMessageGenerated message3 : DbManager.getInstance().getOwnedMessageDao().getAllWipeOnRead()) {
            if (selectedDiscussion != null && Objects.equals(message3.getDiscussionId(), selectedDiscussion.getItemId())) continue;
            retain = discussionRetainMap.computeIfAbsent(message3.getDiscussionId(), isDiscussionRetain);
            if (retain) {
                messagesToWipe.add(message3);
                continue;
            }
            messagesToDelete.add(message3);
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                this.logger.debug("MessageExpirationHelper::delete");
                MessageDeletionHelper.deleteMessagesDbTask(messagesToDelete, false);
                this.logger.debug("MessageExpirationHelper::wipe");
                MessageDeletionHelper.wipeMessagesContentDbTask(messagesToWipe);
                return null;
            });
        }
        catch (SQLException e) {
            this.logger.error("MessageExpirationHelper:: couldn't delete/wipe messages", e);
        }
    }
}

