/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.GroupV2DeletedNotificationHandler;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.GroupV2PhotoChangedNotificationHandler;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.GroupV2UpdateInProgressNotificationHandler;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.GroupV2UpsertNotificationHandler;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import java.util.HashMap;

public class GroupV2NotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_group_v2_created_or_updated", "engine_notification_group_v2_photo_changed", "engine_notification_group_v2_update_in_progress_changed", "engine_notification_group_v2_deleted", "engine_notification_group_v2_update_failed"};

    public GroupV2NotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("GroupV2NotificationListener: notification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_group_v2_created_or_updated": {
                    ObvGroupV2 groupV2 = (ObvGroupV2)userInfo.get("group");
                    Boolean groupWasJustCreatedByMe = (Boolean)userInfo.get("new_group");
                    Boolean updatedByMe = (Boolean)userInfo.get("by_me");
                    if (groupV2 == null || groupWasJustCreatedByMe == null || updatedByMe == null) break;
                    new GroupV2UpsertNotificationHandler(groupV2, groupWasJustCreatedByMe, updatedByMe, false, false).run();
                    break;
                }
                case "engine_notification_group_v2_photo_changed": {
                    byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
                    byte[] bytesGroupIdentifier = (byte[])userInfo.get("bytes_group_identifier");
                    if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) break;
                    OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
                    if (ownedIdentity == null) {
                        return;
                    }
                    AsyncTaskExecutor.submitTask(new GroupV2PhotoChangedNotificationHandler(ownedIdentity, bytesGroupIdentifier));
                    break;
                }
                case "engine_notification_group_v2_update_in_progress_changed": {
                    byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
                    byte[] bytesGroupIdentifier = (byte[])userInfo.get("bytes_group_identifier");
                    Boolean updating = (Boolean)userInfo.get("updating");
                    Boolean creating = (Boolean)userInfo.get("creating");
                    if (bytesOwnedIdentity == null || bytesGroupIdentifier == null || updating == null || creating == null) break;
                    new GroupV2UpdateInProgressNotificationHandler(bytesOwnedIdentity, bytesGroupIdentifier, updating.booleanValue() ? (creating.booleanValue() ? GroupGenerated.Update.CREATING : GroupGenerated.Update.SYNCING) : GroupGenerated.Update.NONE).run();
                    break;
                }
                case "engine_notification_group_v2_deleted": {
                    byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
                    byte[] bytesGroupIdentifier = (byte[])userInfo.get("bytes_group_identifier");
                    OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
                    if (bytesOwnedIdentity == null || bytesGroupIdentifier == null || associatedOwnedIdentity == null) break;
                    new GroupV2DeletedNotificationHandler(associatedOwnedIdentity, bytesGroupIdentifier).run();
                    break;
                }
                case "engine_notification_group_v2_update_failed": {
                    byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
                    byte[] bytesGroupIdentifier = (byte[])userInfo.get("bytes_group_identifier");
                    Boolean error = (Boolean)userInfo.get("error");
                    if (bytesOwnedIdentity == null || bytesGroupIdentifier == null || error == null) break;
                    this.logger.error("GroupV2NotificationListener: Group update failed " + notificationName);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("GroupV2NotificationListener: Something went wrong handling notification " + notificationName, e);
        }
    }
}

