/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvContactDeviceCount;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionCreationHelper;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.UnknownRecipientObvMessagesHelper;
import io.olvid.windows.messenger.engine.helpers.message.tasks.PostPendingMessageTask;
import io.olvid.windows.messenger.engine.helpers.owned_device.OwnedDevicesSynchronisationWithEngineTask;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.DiscussionCustomizationApi;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.engine.notifications.tools.InsertContactRevokedMessageTask;
import io.olvid.windows.messenger.engine.notifications.tools.UpdateContactActiveTask;
import io.olvid.windows.messenger.engine.notifications.tools.UpdateContactDisplayNameAndPhotoDbTask;
import io.olvid.windows.messenger.engine.notifications.tools.UpdateContactKeycloakManagedTask;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class ContactNotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_new_contact", "engine_notification_channel_confirmed_or_deleted", "engine_notification_contact_deleted", "engine_notification_contact_devices_updated", "engine_notification_new_contact_photo", "engine_notification_new_contact_published_details", "engine_notification_contact_published_details_trusted", "engine_notification_contact_capabilities_updated", "engine_notification_contact_one_to_one_changed", "engine_notification_contact_trust_level_increased", "engine_notification_contact_keycloak_managed_changed", "engine_notification_contact_active_changed", "engine_notification_contact_revoked"};

    ContactNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("ContactNotificationListener: notification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_new_contact": {
                    this.newContact(userInfo);
                    break;
                }
                case "engine_notification_channel_confirmed_or_deleted": {
                    this.channelConfirmedOrDeleted(userInfo);
                    break;
                }
                case "engine_notification_contact_deleted": {
                    this.contactDeleted(userInfo);
                    break;
                }
                case "engine_notification_contact_devices_updated": {
                    this.contactDeviceUpdated(userInfo);
                    break;
                }
                case "engine_notification_new_contact_photo": {
                    this.newContactPhoto(userInfo);
                    break;
                }
                case "engine_notification_new_contact_published_details": {
                    this.newContactPublishedDetails(userInfo);
                    break;
                }
                case "engine_notification_contact_published_details_trusted": {
                    this.contactPublishedDetailsTrusted(userInfo);
                    break;
                }
                case "engine_notification_contact_capabilities_updated": {
                    this.contactCapabilitiesUpdated(userInfo);
                    break;
                }
                case "engine_notification_contact_one_to_one_changed": {
                    this.contactOneToOneChanged(userInfo);
                    break;
                }
                case "engine_notification_contact_trust_level_increased": {
                    this.contactTrustLevelIncreased(userInfo);
                    break;
                }
                case "engine_notification_contact_keycloak_managed_changed": {
                    this.contactKeycloakManagedChanged(userInfo);
                    break;
                }
                case "engine_notification_contact_active_changed": {
                    this.contactActiveChanged(userInfo);
                    break;
                }
                case "engine_notification_contact_revoked": {
                    this.contactRevoked(userInfo);
                    break;
                }
                default: {
                    this.logger.error("ContactNotificationListener: invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("ContactNotificationListener: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void newContact(HashMap<String, Object> userInfo) {
        ObvIdentity contactIdentity = (ObvIdentity)userInfo.get("contact_identity");
        boolean hasUntrustedPublishedDetails = (Boolean)userInfo.get("has_untrusted_published_details");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        boolean oneToOne = (Boolean)userInfo.get("one_to_one");
        Integer trustLevel = (Integer)userInfo.get("trust_level");
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (bytesOwnedIdentity == null || contactIdentity == null || ownedIdentity == null || trustLevel == null) {
            this.logger.error("ContactNotificationListener: newContact: unable to decode obvGroup");
            return;
        }
        try {
            TransactionWrapper.startQueryTransaction(() -> {
                Discussion discussion;
                IdentityDetails identityDetails;
                Contact contact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)ownedIdentity.getItemId(), contactIdentity.getBytesIdentity());
                if (contact != null) {
                    throw new SQLException("ContactNotificationListener: newContact: found a contact that should not be there");
                }
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, contactIdentity.getBytesIdentity());
                PreContact preContact = DbManager.getInstance().getPreContactDao().get(contactRef);
                if (preContact == null) {
                    identityDetails = new IdentityDetails(contactIdentity.getIdentityDetails());
                    identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
                    if (identityDetails == null) {
                        AppLogger.e("IdentityService: newContact: unable to insert IdentityDetails in database");
                        return null;
                    }
                } else {
                    identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(preContact.getIdentityDetailsId());
                    if (!identityDetails.equalsTo(contactIdentity.getIdentityDetails())) {
                        DbManager.getInstance().getIdentityDetailsDao().updateDetails((Id<IdentityDetails>)identityDetails.getItemId(), contactIdentity.getIdentityDetails());
                    }
                }
                Capabilities capabilities = new Capabilities(false, false, false);
                capabilities = DbManager.getInstance().getCapabilitiesDao().createIfNotExists(capabilities);
                if (capabilities == null) {
                    AppLogger.e("IdentityService: newContact: unable to insert Capabilities in database");
                    return null;
                }
                contact = new Contact(contactIdentity.getBytesIdentity(), ownedIdentity, identityDetails, hasUntrustedPublishedDetails, oneToOne, capabilities, trustLevel, contactIdentity.isKeycloakManaged(), contactIdentity.isActive());
                contact = DbManager.getInstance().getContactDao().createIfNotExists(contact);
                if (contact == null) {
                    throw new SQLException("ContactNotificationListener::newContact Couldn't create new contact");
                }
                if (DbManager.getInstance().getContactRefDao().isContactRefExists(ownedIdentity, contact.getBytesContactIdentity())) {
                    DbManager.getInstance().getContactRefDao().updateContact(ownedIdentity, contact.getBytesContactIdentity(), contact);
                }
                if (contact.isOneToOne()) {
                    DiscussionCustomization discussionCustomization;
                    if (preContact != null) {
                        DbManager.getInstance().getPreContactDao().deleteWithIdentityDetails((Id<PreContact>)preContact.getItemId());
                    }
                    IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)ownedIdentity.getItemId());
                    Discussion discussion2 = DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(contact);
                    Optional<Long> messageCount = MessageHelper.countUserMessagesInDiscussion(discussion2);
                    if (messageCount.isPresent() && messageCount.get() > 0L) {
                        MessageInsertionHelper.insertContactReAddedMessage(discussion2, contactRef);
                    }
                    if (!DiscussionCustomizationApi.areSharedPreferencesDefaultValues(discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion2.getItemId()))) {
                        MessageInsertionHelper.insertDiscussionSettingsUpdateMessageDbTask(discussion2, discussionCustomization.getSharedSettingsJson().getJsonExpiration(), ownedIdentityRef, System.currentTimeMillis(), MessageBuilder.MessageSystemPosition.FIRST_MESSAGE);
                    }
                } else if (preContact != null && (discussion = DbManager.getInstance().getDiscussionDao().get(preContact)) == null) {
                    DbManager.getInstance().getPreContactDao().deleteWithIdentityDetails((Id<PreContact>)preContact.getItemId());
                }
                contact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)ownedIdentity.getItemId(), contactIdentity.getBytesIdentity());
                if (contact != null) {
                    try {
                        ObvContactDeviceCount obvContactDeviceCount = EngineWrapper.getInstance().getContactDeviceCount(bytesOwnedIdentity, contact.getBytesContactIdentity());
                        DbManager.getInstance().getContactDao().updateContactDeviceCount((Id<Contact>)contact.getItemId(), obvContactDeviceCount.deviceCount, obvContactDeviceCount.establishedChannelCount, obvContactDeviceCount.preKeyCount);
                        UnknownRecipientObvMessagesHelper.processAllOneToOneMessagesOnHold(bytesOwnedIdentity, contactIdentity.getBytesIdentity());
                    }
                    catch (Exception e) {
                        this.logger.error("ContactNotificationListener: newContact: engine exception when updating device and channel counts");
                    }
                } else {
                    this.logger.error("ContactNotificationListener: newContact: unable to update contact");
                }
                return true;
            });
        }
        catch (SQLException throwables) {
            this.logger.error("ContactNotificationListener: newContact: Error during transaction", throwables);
        }
    }

    private void channelConfirmedOrDeleted(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("contact_identity");
        if (bytesOwnedIdentity != null && Arrays.equals(bytesOwnedIdentity, bytesContactIdentity)) {
            AsyncTaskExecutor.submitTask(new OwnedDevicesSynchronisationWithEngineTask(bytesOwnedIdentity));
        } else {
            ObvContactDeviceCount contactDeviceCount;
            Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
            if (contact == null) {
                this.logger.error("ContactNotificationListener: channelConfirmedOrDeleted: contact not found");
                return;
            }
            try {
                contactDeviceCount = EngineWrapper.getInstance().getContactDeviceCount(bytesOwnedIdentity, contact.getBytesContactIdentity());
            }
            catch (Exception e) {
                this.logger.error("ContactNotificationListener: channelConfirmedOrDeleted: cannot compute established channels count", e);
                return;
            }
            try {
                DbManager.getInstance().getContactDao().updateContactDeviceCount((Id<Contact>)contact.getItemId(), contactDeviceCount.deviceCount, contactDeviceCount.establishedChannelCount, contactDeviceCount.preKeyCount);
            }
            catch (Exception e) {
                this.logger.error("ContactNotificationListener: channelConfirmedOrDeleted: cannot update contact established channel count", e);
                return;
            }
            if (contactDeviceCount.establishedChannelCount > 0 || contactDeviceCount.preKeyCount > 0) {
                Collection<Discussion> groupDiscussion;
                List<PendingMessage> pendingMessages = DbManager.getInstance().getPendingMessageDao().getAllByContact(contact);
                for (PendingMessage pendingMessage : pendingMessages) {
                    new PostPendingMessageTask(pendingMessage).run();
                }
                ArrayList<Discussion> discussions = new ArrayList<Discussion>();
                Discussion oneToOneDiscussion = DbManager.getInstance().getDiscussionDao().get(contact);
                if (oneToOneDiscussion != null) {
                    discussions.add(oneToOneDiscussion);
                }
                if ((groupDiscussion = DbManager.getInstance().getContactGroupJoinDao().getAllOwnedGroupDiscussionIdsWithSpecificContact(contact)) != null) {
                    discussions.addAll(groupDiscussion);
                }
                for (Discussion discussion : discussions) {
                    JsonSharedSettings jsonSharedSettings;
                    DiscussionCustomization discussionCustomization;
                    if (discussion == null || (discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId())) == null || (jsonSharedSettings = discussionCustomization.getSharedSettingsJson()) == null) continue;
                    MessagePostHelper.postDiscussionSettingsUpdatedMessageDbTask(discussion, jsonSharedSettings);
                }
            }
        }
    }

    private void contactDeleted(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("ContactNotificationListener: contactDeleted: contact not found");
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contact.getOwnedIdentityId());
        try {
            TransactionWrapper.startQueryTransaction(() -> {
                Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)ownedIdentity.getItemId(), contact.getBytesContactIdentity());
                if (discussion != null) {
                    Optional<Long> messagesCountOpt = MessageHelper.countUserMessagesInDiscussion(discussion);
                    if (messagesCountOpt.isEmpty()) {
                        throw new SQLException("ContactNotificationListener: contactDeleted: cannot access elements in db");
                    }
                    Long messagesCount = messagesCountOpt.get();
                    if (messagesCount == 0L) {
                        DbManager.getInstance().getDiscussionDao().delete(discussion);
                    } else {
                        if (!discussion.isLocked()) {
                            MessageInsertionHelper.insertContactDeletedMessage(discussion);
                        }
                        DiscussionApi.lockDiscussion(discussion);
                        if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                            throw new SQLException("Cannot update discussion");
                        }
                    }
                }
                DbManager.getInstance().getContactDao().delete(contact);
                DbManager.getInstance().getIdentityDetailsDao().deleteById(contact.getIdentityDetailsId());
                List<MessageRecipientInfo> messageRecipientInfoList = DbManager.getInstance().getMessageRecipientInfoDao().getUnsentForContact(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
                for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfoList) {
                    DbManager.getInstance().getMessageRecipientInfoDao().delete(messageRecipientInfo);
                    Api.getMessageApi().refreshOutboundStatus(messageRecipientInfo.getMessageId());
                }
                return null;
            });
        }
        catch (SQLException e) {
            this.logger.error("ContactNotificationListener: contactDeleted: exception in transaction", e);
        }
    }

    private void contactDeviceUpdated(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("contact_identity");
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("ContactNotificationListener: newContactDevice: contact not found");
            return;
        }
        try {
            ObvContactDeviceCount obvContactDeviceCount = EngineWrapper.getInstance().getContactDeviceCount(bytesOwnedIdentity, bytesContactIdentity);
            DbManager.getInstance().getContactDao().updateContactDeviceCount((Id<Contact>)contact.getItemId(), obvContactDeviceCount.deviceCount, obvContactDeviceCount.establishedChannelCount, obvContactDeviceCount.preKeyCount);
        }
        catch (Exception e) {
            this.logger.error("ContactNotificationListener: newContactDevice: Unable to update device count", e);
        }
    }

    private void newContactPhoto(HashMap<String, Object> userInfo) {
        Contact contact;
        JsonIdentityDetailsWithVersionAndPhoto[] jsons;
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Integer version = (Integer)userInfo.get("version");
        Boolean isTrusted = (Boolean)userInfo.get("is_trusted");
        if (version == null || isTrusted == null) {
            this.logger.error("ContactNotificationListener: newContactPhoto: cannot decode userInfo");
            return;
        }
        if (isTrusted.booleanValue() && (jsons = EngineWrapper.getInstance().getContactPublishedAndTrustedDetails(bytesOwnedIdentity, bytesContactIdentity))[jsons.length - 1].getVersion() == version.intValue() && (contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity)) != null) {
            new UpdateContactDisplayNameAndPhotoDbTask(bytesContactIdentity, bytesOwnedIdentity, jsons[jsons.length - 1]).run();
        }
    }

    private void newContactPublishedDetails(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        EngineWrapper.getInstance().trustPublishedContactDetails(bytesOwnedIdentity, bytesContactIdentity);
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("ContactNotificationListener: newContactDevice: contact not found");
            return;
        }
        DbManager.getInstance().getContactDao().updatedUnpublishedDetails((Id<Contact>)contact.getItemId(), ContactGenerated.UnpublishedDetails.NEW_UNSEEN);
    }

    private void contactPublishedDetailsTrusted(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        JsonIdentityDetailsWithVersionAndPhoto identityDetails = (JsonIdentityDetailsWithVersionAndPhoto)userInfo.get("identity_details");
        if (identityDetails != null) {
            new UpdateContactDisplayNameAndPhotoDbTask(bytesContactIdentity, bytesOwnedIdentity, identityDetails).run();
        }
    }

    private void contactCapabilitiesUpdated(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        List obvCapabilities = (List)userInfo.get("capabilities");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || obvCapabilities == null) {
            this.logger.error("ContactNotificationListener: contactCapabilitiesUpdated: cannot decode userInfo");
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("ContactNotificationListener: contactCapabilitiesUpdated: contact not found in db");
            return;
        }
        Capabilities capabilities = DbManager.getInstance().getCapabilitiesDao().get(contact.getCapabilitiesId());
        if (capabilities == null) {
            this.logger.error("ContactNotificationListener: contactCapabilitiesUpdated: cannot find contact capabilities in db");
            return;
        }
        block5: for (ObvCapability obvCapability : ObvCapability.values()) {
            boolean capable = obvCapabilities.contains(obvCapability);
            switch (obvCapability) {
                case WEBRTC_CONTINUOUS_ICE: {
                    if (capable == capabilities.isWebrtcContinuousIce()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateWebrtcContinuousIce(contact, capable);
                    continue block5;
                }
                case ONE_TO_ONE_CONTACTS: {
                    if (capable == capabilities.isOneToOneContacts()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateOneToOneContacts(contact, capable);
                    continue block5;
                }
                case GROUPS_V2: {
                    if (capable == capabilities.isGroupsV2()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateGroupsV2(contact, capable);
                }
            }
        }
    }

    private void contactOneToOneChanged(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Boolean oneToOne = (Boolean)userInfo.get("one_to_one");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || oneToOne == null) {
            this.logger.error("ContactNotificationListener: contactOneToOneChanged: cannot decode userInfo");
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("ContactNotificationListener: contactOneToOneChanged: contact not found");
            return;
        }
        if (contact.isOneToOne() != oneToOne.booleanValue()) {
            try {
                TransactionWrapper.startStatementTransaction(() -> {
                    DbManager.getInstance().getContactDao().updateIsOneToOne((Id<Contact>)contact.getItemId(), oneToOne);
                    if (oneToOne.booleanValue()) {
                        ContactRef contactRef;
                        Discussion discussion = DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(contact);
                        Optional<Long> messageCount = MessageHelper.countUserMessagesInDiscussion(discussion);
                        if (messageCount.isPresent() && messageCount.get() > 0L) {
                            contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                            SystemMessage contactReAddedMessage = MessageBuilder.createContactReAddedMessage(discussion, contactRef);
                            DbManager.getInstance().getSystemMessageDao().createIfNotExists(contactReAddedMessage);
                        }
                        contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                        PreContact preContact = DbManager.getInstance().getPreContactDao().get(contactRef);
                        if (preContact != null) {
                            DbManager.getInstance().getPreContactDao().deleteWithIdentityDetails((Id<PreContact>)preContact.getItemId());
                        }
                        DiscussionApi.unHideDiscussionIfHiddenDbTask(discussion);
                        UnknownRecipientObvMessagesHelper.processAllOneToOneMessagesOnHold(bytesOwnedIdentity, bytesContactIdentity);
                    } else {
                        Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByContactId((Id<Contact>)contact.getItemId());
                        if (discussion != null) {
                            Optional<Long> messageCountOpt = MessageHelper.countUserMessagesInDiscussion(discussion);
                            if (messageCountOpt.isPresent() && messageCountOpt.get() == 0L) {
                                DiscussionDeletionHelper.deleteDiscussionLocallyDbTask((Id<Discussion>)discussion.getItemId());
                            } else {
                                if (!discussion.isLocked()) {
                                    MessageInsertionHelper.insertContactDeletedMessage(discussion);
                                }
                                DiscussionApi.lockDiscussion(discussion);
                                DbManager.getInstance().getDiscussionDao().update(discussion);
                            }
                        }
                    }
                    return null;
                });
            }
            catch (SQLException e) {
                this.logger.error("contactOneToOneChanged: sql exception during transaction", e);
            }
        }
    }

    private void contactTrustLevelIncreased(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Integer trustLevel = (Integer)userInfo.get("trust_level");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || trustLevel == null) {
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact != null && contact.getTrustLevel() != trustLevel.intValue()) {
            DbManager.getInstance().getContactDao().updateTrustLevel((Id<Contact>)contact.getItemId(), trustLevel);
        }
    }

    private void contactActiveChanged(HashMap<String, Object> userInfo) {
        AppLogger.d("ContactNotificationListener::contactActiveChanged ");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Boolean active = (Boolean)userInfo.get("active");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || active == null) {
            return;
        }
        new UpdateContactActiveTask(bytesOwnedIdentity, bytesContactIdentity, active).run();
    }

    private void contactKeycloakManagedChanged(HashMap<String, Object> userInfo) {
        AppLogger.d("ContactNotificationListener::contactKeycloakManagedChanged ");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        Boolean keycloakManaged = (Boolean)userInfo.get("keycloak_managed");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || keycloakManaged == null) {
            return;
        }
        new UpdateContactKeycloakManagedTask(bytesOwnedIdentity, bytesContactIdentity, keycloakManaged).run();
    }

    private void contactRevoked(HashMap<String, Object> userInfo) {
        AppLogger.d("ContactNotificationListener::contactRevoked ");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        new InsertContactRevokedMessageTask(bytesOwnedIdentity, bytesContactIdentity).run();
    }
}

