/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.util.HashMap;
import java.util.Map;

public class ConnectivityNotificationListener
extends AbstractNotificationListener {
    public static final String LATEST_DESKTOP = "latest_desktop";
    public static final String MIN_DESKTOP = "min_desktop";
    private static long latestNetworkRestart = 0L;
    private static int latestState = 0;
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_websocket_connection_state_changed", "engine_notification_ping_received", "engine_notification_ping_lost", "engine_notification_well_known_download_success", "engine_notification_well_known_download_failed"};

    public ConnectivityNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.trace("ConnectivityNotificationListener: notification received : " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_websocket_connection_state_changed": {
                    this.webSocketConnectionChanged(userInfo);
                    break;
                }
                case "engine_notification_ping_received": {
                    this.pingReceivedHandler(userInfo);
                    break;
                }
                case "engine_notification_ping_lost": {
                    this.pingLostHandler(userInfo);
                    break;
                }
                case "engine_notification_well_known_download_success": {
                    this.wellKnownDownloaded(userInfo);
                    break;
                }
                case "engine_notification_well_known_download_failed": {
                    this.wellKnownDownloadFailed(userInfo);
                    break;
                }
                default: {
                    this.logger.error("Invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("ConnectivityNotificationListener::callback: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void wellKnownDownloadFailed(HashMap<String, Object> userInfo) {
        this.logger.debug("ConnectivityNotificationListener::wellKnownDownloadFailed");
    }

    private void wellKnownDownloaded(HashMap<String, Object> userInfo) {
        this.logger.debug("ConnectivityNotificationListener::wellKnownDownloaded");
        Map appInfo = (Map)userInfo.get("app_info");
        boolean updated = (Boolean)userInfo.get("updated");
        this.logger.debug("ConnectivityNotificationListener::wellKnownDownloaded updated state : %s", updated);
        if (appInfo != null) {
            int latest = appInfo.get(LATEST_DESKTOP) == null ? 0 : (Integer)appInfo.get(LATEST_DESKTOP);
            int min = appInfo.get(MIN_DESKTOP) == null ? 0 : (Integer)appInfo.get(MIN_DESKTOP);
            UtilityNC.fireNewerVersionDetectedNotification(latest, min, updated);
        }
    }

    private void webSocketConnectionChanged(HashMap<String, Object> userInfo) {
        int newState = (Integer)userInfo.get("state");
        this.logger.debug(String.format("ConnectivityNotificationListener::webSocketConnectionChanged new state --> %d", newState));
        if (latestState != newState && newState == 2 && latestNetworkRestart + 5000L < System.currentTimeMillis()) {
            this.logger.trace("ConnectivityNotificationListener::webSocketConnectionChanged state changed to connected, launching tasks accordingly");
            latestNetworkRestart = System.currentTimeMillis();
        }
        latestState = newState;
    }

    private void pingReceivedHandler(HashMap<String, Object> userInfo) {
    }

    private void pingLostHandler(HashMap<String, Object> userInfo) {
    }
}

