/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.standalone_interfaces;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;

public class DiscussionCustomizationApi {
    public static DiscussionCustomization updateEphemeralSettingsForADiscussion(Discussion discussion, boolean readOnce, Long settingExistenceDuration, Long settingVisibilityDuration) {
        if (discussion == null) {
            AppLogger.e("DiscussionCustomizationApi: updateEphemeralSettingsForADiscussion: invalid discussion given");
            return null;
        }
        if (discussion.getGroupId().isPresent() && !GroupHelper.isOwnedIdentityAdmin(discussion.getGroupId().get())) {
            AppLogger.e("DiscussionCustomizationApi: updateEphemeralSettingsForADiscussion: Cannot update shared settings in a group if you are not group owner");
            return null;
        }
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
        if (discussionCustomization == null) {
            AppLogger.e("DiscussionCustomizationApi: updateEphemeralSettingsForADiscussion: unable to find discussion customization for this discussion");
            return null;
        }
        discussionCustomization.setSharedSettingsVersion(discussionCustomization.getSharedSettingsVersion() + 1);
        discussionCustomization.setSettingReadOnce(readOnce);
        discussionCustomization.setSettingExistenceDuration(Optional.ofNullable(settingExistenceDuration));
        discussionCustomization.setSettingVisibilityDuration(Optional.ofNullable(settingVisibilityDuration));
        if (!MessagePostHelper.postDiscussionSettingsUpdatedMessageDbTask(discussion, discussionCustomization.getSharedSettingsJson())) {
            AppLogger.e("DiscussionCustomizationApi: updateEphemeralSettingsForADiscussionUnable to post discussion settings update");
            return null;
        }
        IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
        DbManager.getInstance().getDiscussionCustomizationDao().update(discussionCustomization);
        MessageInsertionHelper.insertDiscussionSettingsUpdateMessageDbTask(discussion, discussionCustomization.getSharedSettingsJson().getJsonExpiration(), ownedIdentityRef, System.currentTimeMillis(), MessageBuilder.MessageSystemPosition.MESSAGE_TIMESTAMP);
        return discussionCustomization;
    }

    public static boolean areSharedPreferencesDefaultValues(DiscussionCustomization discussionCustomization) {
        return !discussionCustomization.isSettingReadOnce() && discussionCustomization.getSettingExistenceDuration().isEmpty() && discussionCustomization.getSettingVisibilityDuration().isEmpty();
    }
}

