/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.standalone_interfaces;

import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.atom.tasks.AtomTasks;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ContactApi {
    public static boolean upgradeContactToOneToOne(ContactInfo contact, byte[] ownedIdentityBytes) {
        try {
            EngineWrapper.getInstance().startOneToOneInvitationProtocol(ownedIdentityBytes, contact.bytesContactIdentity());
            return true;
        }
        catch (Exception e) {
            AppLogger.e("ContactService: upgradeContactToOneToOne: startOneToOneInvitationProtocol: engine exception", e);
            return false;
        }
    }

    public static Boolean deleteContactDbTask(Contact contact) {
        boolean isMemberOfGroup;
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contact.getOwnedIdentityId());
        Capabilities capabilities = DbManager.getInstance().getCapabilitiesDao().get(contact.getCapabilitiesId());
        if (capabilities == null) {
            AppLogger.e("ContactService: deleteContactDbTask: downgradeOneToOneContact: cannot find Capabilities");
        }
        if (capabilities != null && contact.isOneToOne() && capabilities.isOneToOneContacts()) {
            try {
                EngineWrapper.getInstance().downgradeOneToOneContact(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
                return true;
            }
            catch (Exception e) {
                AppLogger.e("ContactService: deleteContactDbTask: downgradeOneToOneContact: engine exception", e);
                return null;
            }
        }
        List<Group> groupsV1WithContact = DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact((Id<Contact>)contact.getItemId(), false).stream().filter(g -> g.getVersion() == GroupGenerated.Version.VERSION_1).toList();
        List<Group> groupsV2WithContact = DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact((Id<Contact>)contact.getItemId(), true).stream().filter(g -> g.getVersion() == GroupGenerated.Version.VERSION_2).toList();
        boolean bl = isMemberOfGroup = !groupsV1WithContact.isEmpty() || !groupsV2WithContact.isEmpty();
        if (isMemberOfGroup) {
            AppLogger.d("ContactService: deleteContactDbTask: Unable to delete contact, still in some groups");
            return false;
        }
        try {
            EngineWrapper.getInstance().deleteContact(ownedIdentity.getBytesOwnedIdentity(), contact.getBytesContactIdentity());
            return true;
        }
        catch (Exception e) {
            AppLogger.e("ContactService: deleteContactDbTask: deleteContact: engine exception", e);
            return null;
        }
    }

    public static boolean removeContactCustomPhotoTask(ContactInfo contact) {
        if (contact == null) {
            AppLogger.e("ContactService: removeContactCustomPhotoTask: invalid params");
            return false;
        }
        DbManager.getInstance().getContactDao().updateContactCustomUrl(contact.genId(), null);
        contact.customPhotoUrl().ifPresent(FileApi::_deleteCustomImageTask);
        return true;
    }

    public static void importAndUpdateContactCustomPhotoTask(Id<Contact> contactId, String originalPhotoPath, @Nullable Runnable onSuccess, @Nullable Runnable onFail) {
        if (originalPhotoPath == null) {
            AppLogger.e("ContactService: importAndUpdateContactCustomPhotoTask: invalid params");
            return;
        }
        FileApi._resizeCompressAndEncryptImageTask(originalPhotoPath, 1080, 1080, path -> {
            DbManager.getInstance().getContactDao().updateContactCustomUrl(contactId, (String)path);
            if (onSuccess != null) {
                onSuccess.run();
            }
        }, error -> {
            AppLogger.e("GroupManagementService: importAndUpdateGroupPhotoTask: task error: " + String.valueOf(error));
            if (onFail != null) {
                onFail.run();
            }
        });
    }

    public static void editContactNicknameDbTask(Id<Contact> contactId, Optional<String> nickname) {
        Contact contact = DbManager.getInstance().getContactDao().get(contactId);
        AtomTasks.updateContactCustomName(contact, nickname, true);
        DbManager.getInstance().getContactDao().updateSortDisplayName(contactId);
        ContactApi.updateAllGroupMemberName(contactId);
    }

    public static void updateAllGroupMemberName(Id<Contact> contactId) {
        List<Group> allGroupsWithSpecificContact = DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact(contactId, true);
        for (Group group : allGroupsWithSpecificContact) {
            Optional<String> groupMembersNames = Optional.of(GroupHelper.getGroupMembersNames(group));
            if (groupMembersNames.equals(group.getGroupMembersNames())) continue;
            group.setGroupMembersNames(groupMembersNames);
            DbManager.getInstance().getGroupDao().update(group);
        }
        List<PreGroup> allPreGroupsWithSpecificContact = DbManager.getInstance().getPreGroupDao().getAllPreGroupsWithSpecificContact(contactId);
        for (PreGroup preGroup : allPreGroupsWithSpecificContact) {
            Optional<String> groupMembersNames = Optional.of(GroupHelper.getGroupMembersNames(preGroup));
            if (groupMembersNames.equals(preGroup.getPreGroupMembersNames())) continue;
            DbManager.getInstance().getPreGroupDao().update(preGroup);
        }
    }

    public static String getDisplayName(Id<Contact> contactId, IdentityDetailsInfo.Format format) {
        Contact contact = DbManager.getInstance().getContactDao().get(contactId);
        IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(contact.getIdentityDetailsId());
        ContactInfo contactInfo = new ContactInfo(contact, identityDetails);
        return contactInfo.getCustomOrDisplayName(format);
    }

    public static Optional<String> getContactSignedDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        JsonIdentityDetailsWithVersionAndPhoto[] contactPublishedAndTrustedDetails = EngineWrapper.getInstance().getContactPublishedAndTrustedDetails(bytesOwnedIdentity, bytesContactIdentity);
        if (contactPublishedAndTrustedDetails == null) {
            return Optional.empty();
        }
        JsonIdentityDetailsWithVersionAndPhoto contactBlaBla = contactPublishedAndTrustedDetails[0];
        return Optional.of(contactBlaBla.getIdentityDetails().getSignedUserDetails());
    }
}

