/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.owned_device;

import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.windows.messenger.database.dao.OwnedDeviceDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OwnedDevicesSynchronisationWithEngineTask
implements Runnable {
    final OwnedIdentity ownedIdentity;

    public OwnedDevicesSynchronisationWithEngineTask(byte[] bytesOwnedIdentity) {
        this.ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
    }

    public OwnedDevicesSynchronisationWithEngineTask(OwnedIdentity ownedIdentity) {
        this.ownedIdentity = ownedIdentity;
    }

    @Override
    public void run() {
        try {
            TransactionWrapper.startQueryTransaction(() -> {
                if (this.ownedIdentity == null) {
                    AppLogger.e("OwnedDevicesSynchronisationWithEngineTask: invalid parameters");
                    return null;
                }
                OwnedDeviceDao deviceDao = DbManager.getInstance().getOwnedDeviceDao();
                List<ObvOwnedDevice> obvOwnedDevices = EngineWrapper.getInstance().getOwnedDevices(this.ownedIdentity.getBytesOwnedIdentity());
                List<OwnedDevice> dbOwnedDevices = deviceDao.getAllSync((Id<OwnedIdentity>)this.ownedIdentity.getItemId());
                HashMap<BytesKey, OwnedDevice> dbDeviceMap = new HashMap<BytesKey, OwnedDevice>();
                for (OwnedDevice ownedDevice2 : dbOwnedDevices) {
                    dbDeviceMap.put(new BytesKey(ownedDevice2.getBytesDeviceUid()), ownedDevice2);
                }
                for (ObvOwnedDevice obvOwnedDevice : obvOwnedDevices) {
                    OwnedDevice dbOwnedDevice = (OwnedDevice)dbDeviceMap.remove(new BytesKey(obvOwnedDevice.bytesDeviceUid));
                    if (dbOwnedDevice == null) {
                        OwnedDevice newOwnedDevice = new OwnedDevice(obvOwnedDevice.bytesDeviceUid, this.ownedIdentity, obvOwnedDevice.serverDeviceInfo.displayName, obvOwnedDevice.currentDevice, obvOwnedDevice.channelConfirmed, obvOwnedDevice.serverDeviceInfo.lastRegistrationTimestamp, obvOwnedDevice.serverDeviceInfo.expirationTimestamp, obvOwnedDevice.hasPreKey);
                        deviceDao.insert(newOwnedDevice);
                        continue;
                    }
                    if (!Objects.equals(obvOwnedDevice.serverDeviceInfo.displayName, dbOwnedDevice.getDisplayName().orElse(null))) {
                        dbOwnedDevice.setDisplayName(Optional.ofNullable(obvOwnedDevice.serverDeviceInfo.displayName));
                        deviceDao.updateDisplayName((Id<OwnedDevice>)dbOwnedDevice.getItemId(), dbOwnedDevice.getDisplayName());
                    }
                    if (obvOwnedDevice.channelConfirmed != dbOwnedDevice.isChannelConfirmed()) {
                        dbOwnedDevice.setChannelConfirmed(obvOwnedDevice.channelConfirmed);
                        deviceDao.updateChannelConfirmed((Id<OwnedDevice>)dbOwnedDevice.getItemId(), dbOwnedDevice.isChannelConfirmed());
                    }
                    if (obvOwnedDevice.hasPreKey != dbOwnedDevice.isHasPrekey()) {
                        dbOwnedDevice.setHasPrekey(obvOwnedDevice.hasPreKey);
                        deviceDao.updateHasPrekey((Id<OwnedDevice>)dbOwnedDevice.getItemId(), dbOwnedDevice.isHasPrekey());
                    }
                    if (obvOwnedDevice.currentDevice != dbOwnedDevice.isCurrentDevice()) {
                        dbOwnedDevice.setCurrentDevice(obvOwnedDevice.currentDevice);
                        deviceDao.updateCurrentDevice((Id<OwnedDevice>)dbOwnedDevice.getItemId(), dbOwnedDevice.isCurrentDevice());
                    }
                    if (Objects.equals(obvOwnedDevice.serverDeviceInfo.lastRegistrationTimestamp, dbOwnedDevice.getLastRegistrationTimestamp().orElse(null)) && Objects.equals(obvOwnedDevice.serverDeviceInfo.expirationTimestamp, dbOwnedDevice.getExpirationTimestamp().orElse(null))) continue;
                    dbOwnedDevice.setLastRegistrationTimestamp(Optional.ofNullable(obvOwnedDevice.serverDeviceInfo.lastRegistrationTimestamp));
                    dbOwnedDevice.setExpirationTimestamp(Optional.ofNullable(obvOwnedDevice.serverDeviceInfo.expirationTimestamp));
                    deviceDao.updateTimestamps((Id<OwnedDevice>)dbOwnedDevice.getItemId(), dbOwnedDevice.getLastRegistrationTimestamp().orElse(null), dbOwnedDevice.getExpirationTimestamp().orElse(null));
                }
                dbDeviceMap.values().forEach(ownedDevice -> {
                    try {
                        deviceDao.delete(ownedDevice);
                    }
                    catch (SQLException e) {
                        AppLogger.w("OwnedDevicesSynchronisationWithEngineTask: Unable to remove obsolete ownedDevice");
                    }
                });
                return null;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

