/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.concurrent.Callable;

public class UpdateReactionsTask
implements Callable<Boolean> {
    final AbstractUserMessageGenerated<?> message;
    final Discussion discussion;
    final Optional<String> emoji;
    final IdentityRef sender;
    private final long reactionTimestamp;
    private final boolean postReactionMessageToDiscussionParticipants;

    public UpdateReactionsTask(AbstractUserMessageGenerated<?> message, Discussion discussion, Optional<String> emoji, Id<IdentityRef> senderId, long reactionTimestamp, boolean postReactionMessageToDiscussionParticipants) {
        this.message = message;
        this.discussion = discussion;
        this.emoji = emoji;
        this.sender = DbManager.getInstance().getIdentityRefDao().get(senderId);
        this.reactionTimestamp = reactionTimestamp;
        this.postReactionMessageToDiscussionParticipants = postReactionMessageToDiscussionParticipants;
    }

    @Override
    public Boolean call() {
        boolean success;
        String emoji;
        if (this.emoji.isPresent() && (emoji = this.emoji.get()).isEmpty()) {
            AppLogger.e("UpdateReactionsTask: Invalid emoji (length 0)");
            return false;
        }
        if (this.postReactionMessageToDiscussionParticipants && !(success = MessagePostHelper.postReactionMessageDbTask(this.message, this.discussion, this.emoji))) {
            AppLogger.e("UpdateReactionsTask: cannot post reaction message");
            return false;
        }
        AbstractUserMessageGenerated<?> abstractUserMessageGenerated = this.message;
        if (abstractUserMessageGenerated instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)abstractUserMessageGenerated;
            reactionOpt = DbManager.getInstance().getInboundMessageReactionDao().getReaction(inboundMessage, this.sender);
            if (reactionOpt.isEmpty()) {
                InboundMessageReaction reaction = new InboundMessageReaction(inboundMessage, this.sender, this.emoji, this.reactionTimestamp);
                DbManager.getInstance().getInboundMessageReactionDao().insert(reaction);
            } else {
                InboundMessageReaction reaction = (InboundMessageReaction)reactionOpt.get();
                if (reaction.getTimestamp() > this.reactionTimestamp) {
                    return true;
                }
                DbManager.getInstance().getInboundMessageReactionDao().updateEmojiAndTimestamp(reaction.getItemId(), this.emoji, this.reactionTimestamp);
            }
        } else {
            reactionOpt = this.message;
            if (reactionOpt instanceof OutboundMessage) {
                OutboundMessage outboundMessage = (OutboundMessage)((Object)reactionOpt);
                reactionOpt = DbManager.getInstance().getOutboundMessageReactionDao().getReaction(outboundMessage, this.sender);
                if (reactionOpt.isEmpty()) {
                    OutboundMessageReaction reaction = new OutboundMessageReaction(outboundMessage, this.sender, this.emoji, this.reactionTimestamp);
                    DbManager.getInstance().getOutboundMessageReactionDao().insert(reaction);
                } else {
                    OutboundMessageReaction reaction = (OutboundMessageReaction)reactionOpt.get();
                    if (reaction.getTimestamp() > this.reactionTimestamp) {
                        return true;
                    }
                    DbManager.getInstance().getOutboundMessageReactionDao().updateEmojiAndTimestamp(reaction.getItemId(), this.emoji, this.reactionTimestamp);
                }
            } else {
                reactionOpt = this.message;
                if (reactionOpt instanceof OwnedMessage) {
                    OwnedMessage ownedMessage = (OwnedMessage)((Object)reactionOpt);
                    reactionOpt = DbManager.getInstance().getOwnedMessageReactionDao().getReaction(ownedMessage, this.sender);
                    if (reactionOpt.isEmpty()) {
                        OwnedMessageReaction reaction = new OwnedMessageReaction(ownedMessage, this.sender, this.emoji, this.reactionTimestamp);
                        DbManager.getInstance().getOwnedMessageReactionDao().insert(reaction);
                    } else {
                        OwnedMessageReaction reaction = (OwnedMessageReaction)reactionOpt.get();
                        if (reaction.getTimestamp() > this.reactionTimestamp) {
                            return true;
                        }
                        DbManager.getInstance().getOwnedMessageReactionDao().updateEmojiAndTimestamp(reaction.getItemId(), this.emoji, this.reactionTimestamp);
                    }
                } else {
                    AppLogger.e("Found a message with an unexpected type");
                }
            }
        }
        return true;
    }
}

