/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;

public class SetDraftJsonExpirationTask
implements Runnable {
    private final Discussion discussion;
    private final boolean readOnce;
    private final Long visibilityDuration;
    private final Long existenceDuration;

    public SetDraftJsonExpirationTask(Discussion discussion, boolean readOnce, Long visibilityDuration, Long existenceDuration) {
        this.discussion = discussion;
        this.readOnce = readOnce;
        this.visibilityDuration = visibilityDuration;
        this.existenceDuration = existenceDuration;
    }

    @Override
    public void run() {
        OutboundMessage draftMessage;
        Discussion discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(this.discussion.getItemId());
        if (discussion == null) {
            return;
        }
        Optional<OutboundMessage> draftMessageOpt = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)discussion.getItemId());
        if (draftMessageOpt.isEmpty()) {
            if (!this.readOnce && this.visibilityDuration == null && this.existenceDuration == null) {
                return;
            }
            draftMessage = MessageBuilder.createEmptyDraft(discussion);
            draftMessage = DbManager.getInstance().getOutboundMessageDao().createIfNotExists(draftMessage);
        } else {
            draftMessage = draftMessageOpt.get();
        }
        if (draftMessage.getOutboundMessageEphemeralInfoId().isEmpty()) {
            OutboundMessageEphemeralInfo messageEphemeralInfo = new OutboundMessageEphemeralInfo(this.readOnce, this.visibilityDuration, this.existenceDuration, false);
            DbManager.getInstance().getOutboundMessageEphemeralInfoDao().insert(messageEphemeralInfo);
            DbManager.getInstance().getOutboundMessageDao().updateEphemeraInfo(draftMessage.getItemId(), messageEphemeralInfo);
        } else {
            Id<OutboundMessageEphemeralInfo> ephemeralInfoId = draftMessage.getOutboundMessageEphemeralInfoId().get();
            if (!this.readOnce && this.visibilityDuration == null && this.existenceDuration == null) {
                DbManager.getInstance().getOutboundMessageEphemeralInfoDao().customDeleteById(ephemeralInfoId);
            } else {
                DbManager.getInstance().getOutboundMessageEphemeralInfoDao().update(ephemeralInfoId, this.readOnce, this.visibilityDuration, this.existenceDuration);
            }
        }
        try {
            DbManager.getInstance().getOutboundMessageDao().updateTimestampAndSortIndex(draftMessage, System.currentTimeMillis());
        }
        catch (Exception e) {
            AppLogger.e("Something went wrong in SetDraftJsonExpirationTask...", e);
        }
    }
}

