/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonPayload;
import io.olvid.windows.messenger.database.datatypes.json.JsonReturnReceipt;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.Optional;

public class PostPendingMessageTask
implements Runnable {
    protected final AppLogger logger = new AppLogger(this.getClass());
    private final PendingMessage pendingMessage;
    private final Id<OutboundMessage> messageId;
    private final Id<ContactRef> contactRefId;

    public PostPendingMessageTask(PendingMessage pendingMessage) {
        this.pendingMessage = pendingMessage;
        this.messageId = pendingMessage.getMessageId();
        this.contactRefId = pendingMessage.getContactRefId();
    }

    @Override
    public void run() {
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                this.doRun();
                return null;
            });
        }
        catch (Exception exception) {
            this.logger.error("Unexpected exception", exception);
            return;
        }
    }

    private void doRun() throws Exception {
        OutboundMessage message = DbManager.getInstance().getOutboundMessageDao().get(this.messageId);
        if (message == null) {
            this.logger.error("Cannot find message in db");
            return;
        }
        Optional<OutboundMessageEphemeralInfo> ephemeralInfo = DbManager.getInstance().getOutboundMessageDao().getEphemeralInfo(message);
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(this.contactRefId);
        Optional<Id<Contact>> contactIdOpt = contactRef.getContactId();
        if (contactIdOpt.isEmpty()) {
            this.logger.error("Cannot find contact in db");
            return;
        }
        Id<Contact> contactId = contactIdOpt.get();
        Contact contact = DbManager.getInstance().getContactDao().get(contactId);
        if (!discussion.canPostMessage()) {
            this.logger.error("Cannot post a message in this discussion: " + String.valueOf(discussion.getItemId()));
            return;
        }
        Long originalServerTimestamp = null;
        Optional<Id<Location>> locationId = message.getLocationId();
        if (locationId.isPresent()) {
            Location location = DbManager.getInstance().getLocationDao().get(locationId.get());
            switch (location.getType()) {
                case SEND: {
                    originalServerTimestamp = DbManager.getInstance().getMessageRecipientInfoDao().getOriginalServerTimestampForMessage(message);
                    break;
                }
                case SHARE: 
                case SHARE_FINISHED: {
                    originalServerTimestamp = location.getTimestamp();
                }
            }
        } else {
            originalServerTimestamp = DbManager.getInstance().getMessageRecipientInfoDao().getOriginalServerTimestampForMessage(message);
        }
        List<byte[]> byteIdentitiesToWhichMessageCanBeSentNow = List.of(contactRef.getBytesContactIdentity());
        List outboundAttachments = DbManager.getInstance().getOutboundAttachmentDao().getAttachmentsForMessage(message.getItemId());
        ObvOutboundAttachment[] obvOutboundAttachments = new ObvOutboundAttachment[outboundAttachments.size()];
        for (int i = 0; i < obvOutboundAttachments.length; ++i) {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(((OutboundAttachment)outboundAttachments.get(i)).getFyleId());
            if (fyle == null) {
                this.logger.warning("This should not happen, Fyle null for attachement : " + String.valueOf(((OutboundAttachment)outboundAttachments.get(i)).getItemId()));
                continue;
            }
            obvOutboundAttachments[i] = new ObvOutboundAttachment(fyle.getFilePath(), ((OutboundAttachment)outboundAttachments.get(i)).getSize(), AttachmentUtils.getMetadata((AbstractAttachmentGenerated)outboundAttachments.get(i), fyle));
            ((OutboundAttachment)outboundAttachments.get(i)).setIdx(i);
            DbManager.getInstance().getOutboundAttachmentDao().update((OutboundAttachment)outboundAttachments.get(i));
        }
        byte[] returnReceiptNonce = EngineWrapper.getInstance().getReturnReceiptNonce();
        byte[] returnReceiptKey = EngineWrapper.getInstance().getReturnReceiptKey();
        JsonMessage jsonMessage = MessageHelper.getJsonMessage(message);
        ephemeralInfo.ifPresent(messageEphemeralInfo -> jsonMessage.setJsonExpiration(MessageHelper.getJsonExpiration(messageEphemeralInfo)));
        jsonMessage.setIdentifier(discussion);
        jsonMessage.setOriginalServerTimestamp(originalServerTimestamp == null || originalServerTimestamp == 0L ? null : originalServerTimestamp);
        JsonReturnReceipt jsonReturnReceipt = new JsonReturnReceipt(returnReceiptNonce, returnReceiptKey);
        JsonPayload jsonPayload = new JsonPayload(jsonMessage, jsonReturnReceipt);
        byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
        ObvPostMessageOutput postMessageOutput = EngineWrapper.getInstance().post(messagePayload, obvOutboundAttachments, byteIdentitiesToWhichMessageCanBeSentNow, ownedIdentity.getBytesOwnedIdentity(), true, false);
        if (!postMessageOutput.isMessagePostedForAtLeastOneContact()) {
            this.logger.error("Sending failed");
            return;
        }
        TransactionWrapper.startStatementTransaction(() -> {
            IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contactRef);
            byte[] engineMessageIdentifier = (byte[])postMessageOutput.getMessageIdentifierByContactIdentity().get(new ObvBytesKey(contact.getBytesContactIdentity()));
            MessageRecipientInfo messageRecipientInfo = new MessageRecipientInfo(message, identityRef, engineMessageIdentifier, returnReceiptNonce, returnReceiptKey);
            DbManager.getInstance().getMessageRecipientInfoDao().create(messageRecipientInfo);
            Api.getMessageApi().refreshOutboundStatus((Id<OutboundMessage>)message.getItemId());
            for (OutboundAttachment outboundAttachment : outboundAttachments) {
                AttachmentRecipientInfo attachmentRecipientInfo = new AttachmentRecipientInfo(messageRecipientInfo, outboundAttachment, messageRecipientInfo.getEngineMessageIdentifier(), null, null, null, null);
                if (DbManager.getInstance().getAttachmentRecipientInfoDao().create(attachmentRecipientInfo) != 1) {
                    throw new Exception("PostPendingMessageTask: couldn't create attachmentRecipientInfos....");
                }
                if (!AttachmentUtils.refreshStatus(outboundAttachment)) continue;
                DbManager.getInstance().getOutboundAttachmentDao().updateStatus((Id<OutboundAttachment>)outboundAttachment.getItemId(), outboundAttachment.getStatus());
            }
            DbManager.getInstance().getPendingMessageDao().delete(this.pendingMessage);
            return null;
        });
    }
}

