/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.dao.ContactGroupJoinDao;
import io.olvid.windows.messenger.database.dao.DiscussionDao;
import io.olvid.windows.messenger.database.dao.GroupDao;
import io.olvid.windows.messenger.database.dao.PendingGroupMemberDao;
import io.olvid.windows.messenger.database.datatypes.fyle.JsonMetadata;
import io.olvid.windows.messenger.database.datatypes.json.JsonDeleteDiscussion;
import io.olvid.windows.messenger.database.datatypes.json.JsonDeleteMessages;
import io.olvid.windows.messenger.database.datatypes.json.JsonDiscussionRead;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonLimitedVisibilityMessageOpened;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.datatypes.json.JsonOneToOneMessageIdentifier;
import io.olvid.windows.messenger.database.datatypes.json.JsonPayload;
import io.olvid.windows.messenger.database.datatypes.json.JsonReaction;
import io.olvid.windows.messenger.database.datatypes.json.JsonReturnReceipt;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.datatypes.json.JsonUpdateMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonWebrtcMessage;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.LocationGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.InboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OwnedMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteDeleteRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteEditRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteReactionRequest;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.helpers.message.UnknownRecipientObvMessagesHelper;
import io.olvid.windows.messenger.engine.helpers.message.tasks.IMessageSender;
import io.olvid.windows.messenger.engine.helpers.message.tasks.InboundEphemeralUnboxTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.UpdateReactionsTask;
import io.olvid.windows.messenger.engine.service.MessageExpirationService;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.notifications.NotificationCenter;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Watches;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ForceScheduleNextMessageExpirationTaskNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.util.Pair;

public class NewMessageReceivedTask
implements Runnable {
    AppLogger logger = new AppLogger(NewMessageReceivedTask.class);
    private final ObvMessage obvMessage;
    private OwnedIdentity ownedIdentity;
    private static final long RECEIVED_MESSAGE_NOTIFICATION_DELAY_THRESHOLD = 300000L;

    public NewMessageReceivedTask(ObvMessage obvMessage) {
        this.obvMessage = obvMessage;
    }

    @Override
    public void run() {
        long count = DbManager.getInstance().getInboundMessageDao().getCountForEngineIdentifier(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
        if ((count += DbManager.getInstance().getOwnedMessageDao().getCountForEngineIdentifier(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier())) > 0L) {
            Api.getMessageApi().markMessageForDeletion(this.obvMessage);
            return;
        }
        try {
            Watches.Watch watch;
            IMessageSender messageSender;
            JsonPayload messagePayload = (JsonPayload)EngineWrapper.getJsonObjectMapper().readValue(this.obvMessage.getMessagePayload(), JsonPayload.class);
            JsonReturnReceipt jsonReturnReceipt = messagePayload.getJsonReturnReceipt();
            JsonMessage jsonMessage = messagePayload.getJsonMessage();
            JsonWebrtcMessage jsonWebrtcMessage = messagePayload.getJsonWebrtcMessage();
            JsonSharedSettings jsonSharedSettings = messagePayload.getJsonSharedSettings();
            JsonDeleteDiscussion jsonDeleteDiscussion = messagePayload.getJsonDeleteDiscussion();
            JsonDeleteMessages jsonDeleteMessages = messagePayload.getJsonDeleteMessages();
            JsonUpdateMessage jsonUpdateMessage = messagePayload.getJsonUpdateMessage();
            JsonReaction jsonReaction = messagePayload.getJsonReaction();
            JsonDiscussionRead jsonDiscussionRead = messagePayload.getJsonDiscussionRead();
            JsonLimitedVisibilityMessageOpened jsonLimitedVisibilityMessageOpened = messagePayload.getJsonLimitedVisibilityMessageOpened();
            byte[] bytesContactIdentity = this.obvMessage.getBytesFromIdentity();
            byte[] bytesOwnedIdentity = this.obvMessage.getBytesToIdentity();
            if (jsonWebrtcMessage != null) {
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            this.ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
            if (this.ownedIdentity == null) {
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (Arrays.equals(bytesOwnedIdentity, bytesContactIdentity)) {
                messageSender = IMessageSender.makeOwnedMessageSender(this.ownedIdentity);
            } else {
                Optional<Contact> contactOpt = Optional.ofNullable(DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity));
                if (contactOpt.isPresent()) {
                    messageSender = IMessageSender.makeContactMessageSender(contactOpt.get());
                } else {
                    EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                    return;
                }
            }
            if (jsonSharedSettings != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonSharedSettings.getGroupV2Identifier()), Optional.ofNullable(jsonSharedSettings.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleSharedSettingsMessage");
                this.handleSharedSettingsMessage(jsonSharedSettings, messageSender, this.obvMessage.getServerTimestamp());
                watch.stop();
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonDeleteDiscussion != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonDeleteDiscussion.getGroupV2Identifier()), Optional.ofNullable(jsonDeleteDiscussion.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleDeleteDiscussion");
                if (this.handleDeleteDiscussion(jsonDeleteDiscussion, messageSender, this.obvMessage.getServerTimestamp())) {
                    EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                }
                watch.stop();
                return;
            }
            if (jsonDeleteMessages != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonDeleteMessages.getGroupV2Identifier()), Optional.ofNullable(jsonDeleteMessages.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleDeleteMessages");
                this.handleDeleteMessages(jsonDeleteMessages, messageSender, this.obvMessage.getServerTimestamp());
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                watch.stop();
                return;
            }
            if (jsonUpdateMessage != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonUpdateMessage.getGroupV2Identifier()), Optional.ofNullable(jsonUpdateMessage.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleUpdateMessage");
                this.handleUpdateMessage(jsonUpdateMessage, messageSender, this.obvMessage.getServerTimestamp());
                watch.stop();
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonReaction != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonReaction.getGroupV2Identifier()), Optional.ofNullable(jsonReaction.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleReactionMessage");
                this.handleReactionMessage(jsonReaction, messageSender, this.obvMessage.getServerTimestamp());
                watch.stop();
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonDiscussionRead != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonDiscussionRead.getGroupV2Identifier()), Optional.ofNullable(jsonDiscussionRead.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleDiscussionReadMessage");
                this.handleDiscussionReadMessage(jsonDiscussionRead, messageSender);
                watch.stop();
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonLimitedVisibilityMessageOpened != null) {
                if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonLimitedVisibilityMessageOpened.getGroupV2Identifier()), Optional.ofNullable(jsonLimitedVisibilityMessageOpened.getOneToOneIdentifier()), this.obvMessage)) {
                    return;
                }
                watch = Watches.getInstance().start("NewMessageReceivedTask#handleLimitedVisibilityOpenedMessage");
                this.handleLimitedVisibilityOpenedMessage(jsonLimitedVisibilityMessageOpened, messageSender, this.obvMessage.getServerTimestamp(), this.obvMessage.getDownloadTimestamp());
                watch.stop();
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonMessage == null) {
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (jsonMessage.isEmpty() && this.obvMessage.getAttachments().length == 0) {
                EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
                return;
            }
            if (this.putMessageOnHoldIfNeeded(messageSender, Optional.ofNullable(jsonMessage.getGroupV2Identifier()), Optional.ofNullable(jsonMessage.getOneToOneIdentifier()), this.obvMessage)) {
                return;
            }
            watch = Watches.getInstance().start("NewMessageReceivedTask#handleMessage");
            if (messageSender.isMe()) {
                this.handleOwnedMessage(jsonMessage, jsonReturnReceipt, messageSender);
            } else {
                this.handleNormalMessage(jsonMessage, jsonReturnReceipt, messageSender);
            }
            watch.stop();
        }
        catch (JsonProcessingException e) {
            this.logger.error("HandleNewMessageTask: cannot deserialize jsonMessage, deleting it", (Exception)((Object)e));
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
        }
        catch (Exception e) {
            this.logger.error("HandleNewMessageTask: unexpected exception during handle", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNormalMessage(JsonMessage jsonMessage, JsonReturnReceipt jsonReturnReceipt, IMessageSender messageSender) {
        InboundMessage message;
        Optional remoteDeleteRequest;
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonMessage.getGroupUid(), jsonMessage.getGroupOwner(), jsonMessage.getGroupV2Identifier(), jsonMessage.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.SEND_MESSAGE));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        Contact contact = messageSender.getContact();
        Optional<MessageRef> messageRefOpt = DbManager.getInstance().getMessageRefDao().get((Id<Discussion>)discussion.getItemId(), jsonMessage.senderSequenceNumber, jsonMessage.senderThreadIdentifier, contact.getBytesContactIdentity());
        if (messageRefOpt.isPresent() && (remoteDeleteRequest = DbManager.getInstance().getRemoteDeleteRequestDao().getByMessageRef(discussion, messageRefOpt.get())).isPresent()) {
            this.handleAlreadyRemotelyDeletedMessage(discussion, messageSender, jsonMessage, jsonReturnReceipt, (RemoteDeleteRequest)remoteDeleteRequest.get());
            return;
        }
        JsonMetadata[] attachmentMetadatas = new JsonMetadata[this.obvMessage.getAttachments().length];
        int imageCount = 0;
        int attachmentCount = 0;
        Optional<Object> linkPreviewInfo = Optional.empty();
        for (int i = 0; i < this.obvMessage.getAttachments().length; ++i) {
            try {
                attachmentMetadatas[i] = (JsonMetadata)EngineWrapper.getJsonObjectMapper().readValue(this.obvMessage.getAttachments()[i].getMetadata(), JsonMetadata.class);
                String type = attachmentMetadatas[i].getType();
                if (ImageUtils.isImage(type)) {
                    ++imageCount;
                }
                if (ImageUtils.isLink(type)) {
                    linkPreviewInfo = Optional.of(new LinkPreviewInfo(Optional.empty(), false, Optional.empty()));
                }
                ++attachmentCount;
                continue;
            }
            catch (Exception e) {
                attachmentMetadatas[i] = null;
            }
        }
        try {
            int finalAttachmentCount = attachmentCount;
            int finalImageCount = imageCount;
            Optional finalLinkPreviewInfo = linkPreviewInfo;
            Pair transactionResult = TransactionWrapper.startQueryTransaction(() -> {
                List reactionRequests;
                Optional remoteEditRequestOpt;
                Group group;
                boolean boxed;
                boolean needToUpdateNextScheduledExpiration = false;
                JsonExpiration jsonExpiration = jsonMessage.getJsonExpiration();
                if (jsonExpiration == null) {
                    boxed = false;
                } else {
                    boolean hasVisibilityDuration = jsonExpiration.getVisibilityDuration() != null;
                    boolean isReadOnce = jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce() != false;
                    boxed = hasVisibilityDuration || isReadOnce;
                }
                long messageServerTimestamp = this.obvMessage.getServerTimestamp();
                if (jsonMessage.getOriginalServerTimestamp() != null && discussion.getGroupId().isPresent() && (group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get())).isV2()) {
                    messageServerTimestamp = Math.min(messageServerTimestamp, jsonMessage.getOriginalServerTimestamp());
                }
                InboundMessageEphemeralInfo messageEphemeralInfo = null;
                if (jsonExpiration != null) {
                    boolean isReadOnce;
                    boolean bl = isReadOnce = jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce() != false;
                    if (isReadOnce || jsonExpiration.getVisibilityDuration() != null || jsonExpiration.getExistenceDuration() != null) {
                        messageEphemeralInfo = new InboundMessageEphemeralInfo(isReadOnce, jsonExpiration.getVisibilityDuration(), jsonExpiration.getExistenceDuration());
                        DbManager.getInstance().getInboundMessageEphemeralInfoDao().createIfNotExists(messageEphemeralInfo);
                    }
                }
                InboundMessage messageToInsert = MessageBuilder.createInboundMessage(discussion, contact, jsonMessage, jsonReturnReceipt, this.obvMessage.getIdentifier(), messageServerTimestamp, finalAttachmentCount, finalImageCount, InboundMessageGenerated.Status.UNREAD, boxed, finalLinkPreviewInfo);
                Long remoteEditRequestServerTimestamp = null;
                if (messageRefOpt.isPresent() && (remoteEditRequestOpt = DbManager.getInstance().getRemoteEditRequestDao().getByMessageRef(discussion, (MessageRef)messageRefOpt.get())).isPresent()) {
                    RemoteEditRequest remoteEditRequest = (RemoteEditRequest)remoteEditRequestOpt.get();
                    Optional<String> newBody = remoteEditRequest.getBody().map(String::trim);
                    if (!Objects.equals(messageToInsert.getBody(), newBody)) {
                        messageToInsert.setBody(newBody);
                        messageToInsert.setEditionStatus(AbstractUserMessageGenerated.EditionStatus.UNSEEN);
                        remoteEditRequestServerTimestamp = remoteEditRequest.getTimestamp();
                    }
                    DbManager.getInstance().getRemoteEditRequestDao().customDelete(remoteEditRequest);
                }
                if ((messageToInsert = DbManager.getInstance().getInboundMessageDao().createIfNotExists(messageToInsert)) == null) {
                    throw new SQLException("Unable to insert message in db");
                }
                if (messageEphemeralInfo != null) {
                    DbManager.getInstance().getInboundMessageDao().updateEphemeraInfo(messageToInsert.getItemId(), messageEphemeralInfo);
                }
                if (messageRefOpt.isPresent()) {
                    DbManager.getInstance().getMessageRefDao().updateMessageRef(messageToInsert);
                }
                if (remoteEditRequestServerTimestamp != null) {
                    DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata(messageToInsert, InboundMessageMetadataGenerated.Kind.EDITED, remoteEditRequestServerTimestamp));
                }
                if (discussion.isHidden()) {
                    discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                    DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                }
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, messageToInsert, false);
                DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata(messageToInsert, InboundMessageMetadataGenerated.Kind.UPLOADED, this.obvMessage.getServerTimestamp()), new InboundMessageMetadata(messageToInsert, InboundMessageMetadataGenerated.Kind.RECEIVED, System.currentTimeMillis()));
                if (messageEphemeralInfo != null && messageEphemeralInfo.getExistenceDuration().isPresent()) {
                    long existenceDuration = messageEphemeralInfo.getExistenceDuration().get();
                    long elapsedTimeBeforeDownload = Math.max(0L, this.obvMessage.getDownloadTimestamp() - this.obvMessage.getServerTimestamp());
                    long expirationTimestamp = this.obvMessage.getLocalDownloadTimestamp() + existenceDuration * 1000L - elapsedTimeBeforeDownload;
                    DbManager.getInstance().getInboundMessageEphemeralInfoDao().updateExistenceExpiration(messageEphemeralInfo.getItemId(), expirationTimestamp);
                    needToUpdateNextScheduledExpiration = true;
                }
                if (messageRefOpt.isPresent() && (reactionRequests = DbManager.getInstance().getReactionRequestDao().getAllByMessageRef(discussion, (MessageRef)messageRefOpt.get())) != null) {
                    for (RemoteReactionRequest reactionRequest : reactionRequests) {
                        new UpdateReactionsTask(messageToInsert, discussion, reactionRequest.getEmoji(), reactionRequest.getIdentityRefId(), reactionRequest.getTimestamp(), false).call();
                    }
                    DbManager.getInstance().getReactionRequestDao().delete(reactionRequests);
                }
                return new Pair((Object)messageToInsert, (Object)needToUpdateNextScheduledExpiration);
            });
            if (((Boolean)transactionResult.getValue()).booleanValue()) {
                NCRegistry.getUtilityNC().postNotification(new ForceScheduleNextMessageExpirationTaskNotification());
            }
            message = (InboundMessage)transactionResult.getKey();
        }
        catch (SQLException e) {
            this.logger.error("NewMessageReceivedTask.handleNormalMessage: unable to insert message or metadata in db", e);
            return;
        }
        if (jsonReturnReceipt != null) {
            Api.getMessageApi().sendMessageReturnReceipt(message, ReturnReceiptStatus.DELIVERED);
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        ArrayList<InboundAttachment> attachmentsToDownload = new ArrayList<InboundAttachment>();
        for (int i = 0; i < this.obvMessage.getAttachments().length; ++i) {
            ObvAttachment obvAttachment = this.obvMessage.getAttachments()[i];
            JsonMetadata attachmentMetadata = attachmentMetadatas[i];
            if (obvAttachment == null) continue;
            try {
                if (attachmentMetadata == null) {
                    throw new Exception();
                }
                byte[] sha256 = attachmentMetadata.getSha256();
                FileApi._acquireLock(obvAttachment.getUrl());
                try {
                    InboundAttachment inboundAttachment;
                    Fyle fyle = DbManager.getInstance().getFyleDao().getFromHash(sha256);
                    if (fyle != null) {
                        if (fyle.isComplete()) {
                            Optional<LinkPreviewInfo> linkPreviewInfoOpt;
                            inboundAttachment = new InboundAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), ReceivedAttachmentGenerated.Status.COMPLETE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                            DbManager.getInstance().getInboundAttachmentDao().insert(inboundAttachment);
                            Api.getMessageApi().sendAttachmentReturnReceipt(message, ReturnReceiptStatus.DELIVERED, obvAttachment.getNumber());
                            EngineWrapper.getInstance().markAttachmentForDeletion(obvAttachment);
                            if (ImageUtils.isLink(attachmentMetadata.getType()) && (linkPreviewInfoOpt = LinkPreviewInfo.of(List.of(inboundAttachment))).isPresent()) {
                                DbManager.getInstance().getInboundMessageDao().updateLinkPreviewInfo(message.getItemId(), linkPreviewInfoOpt);
                            }
                            continue;
                        }
                        inboundAttachment = new InboundAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), obvAttachment.isDownloadRequested() ? ReceivedAttachmentGenerated.Status.DOWNLOADING : ReceivedAttachmentGenerated.Status.DOWNLOADABLE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                        DbManager.getInstance().getInboundAttachmentDao().insert(inboundAttachment);
                        attachmentsToDownload.add(inboundAttachment);
                        continue;
                    }
                    fyle = new Fyle(obvAttachment.getUrl());
                    fyle = DbManager.getInstance().getFyleDao().createIfNotExists(fyle);
                    inboundAttachment = new InboundAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), obvAttachment.isDownloadRequested() ? ReceivedAttachmentGenerated.Status.DOWNLOADING : ReceivedAttachmentGenerated.Status.DOWNLOADABLE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                    DbManager.getInstance().getInboundAttachmentDao().insert(inboundAttachment);
                    attachmentsToDownload.add(inboundAttachment);
                    continue;
                }
                finally {
                    FileApi._releaseLock(obvAttachment.getUrl());
                }
            }
            catch (Exception e) {
                this.logger.error("Error reading an attachment or creating the fyle (or message already expired and deleted)", e);
                Api.getAttachmentApi().markAttachmentForDeletion(obvAttachment);
            }
        }
        Api.getMessageApi().markMessageForDeletion(this.obvMessage);
        Optional<Long> automaticAttachmentDownloadSizeSetting = DbManager.getInstance().getApplicationSettingsDao().getAutomaticAttachmentDownloadSizeSetting();
        long threshold = automaticAttachmentDownloadSizeSetting.orElse(-1L);
        for (InboundAttachment inboundAttachment : attachmentsToDownload) {
            boolean isLinkPreview;
            FileExtension extension = PreviewUtils.toFileExtension(inboundAttachment);
            boolean bl = isLinkPreview = extension == FileExtension.LINK;
            if (threshold != -1L && inboundAttachment.getSize() >= threshold && !isLinkPreview) continue;
            EngineWrapper.getInstance().downloadSmallAttachment(this.obvMessage.getBytesToIdentity(), inboundAttachment.getEngineMessageIdentifier(), inboundAttachment.getIdx());
            inboundAttachment.setStatus(ReceivedAttachmentGenerated.Status.DOWNLOADING);
            DbManager.getInstance().getInboundAttachmentDao().update(inboundAttachment);
        }
        long delay = this.obvMessage.getDownloadTimestamp() - this.obvMessage.getServerTimestamp();
        if (delay < 300000L) {
            NotificationCenter.getInstance().post(message);
        }
        UnreadMessageCountCache.getInstance().incrementUnreadCount((Id<OwnedIdentity>)ownedIdentity.getItemId(), (Id<Discussion>)discussion.getItemId(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOwnedMessage(JsonMessage jsonMessage, JsonReturnReceipt jsonReturnReceipt, IMessageSender messageSender) {
        OwnedMessage message;
        Optional remoteDeleteRequest;
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonMessage.getGroupUid(), jsonMessage.getGroupOwner(), jsonMessage.getGroupV2Identifier(), jsonMessage.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.SEND_MESSAGE));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        JsonExpiration jsonExpiration = jsonMessage.getJsonExpiration();
        if (jsonExpiration != null && jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce().booleanValue()) {
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Optional<MessageRef> messageRefOpt = DbManager.getInstance().getMessageRefDao().get((Id<Discussion>)discussion.getItemId(), jsonMessage.senderSequenceNumber, jsonMessage.senderThreadIdentifier, messageSender.getIdentityBytes());
        if (messageRefOpt.isPresent() && (remoteDeleteRequest = DbManager.getInstance().getRemoteDeleteRequestDao().getByMessageRef(discussion, messageRefOpt.get())).isPresent()) {
            this.handleAlreadyRemotelyDeletedMessage(discussion, messageSender, jsonMessage, jsonReturnReceipt, (RemoteDeleteRequest)remoteDeleteRequest.get());
            return;
        }
        JsonMetadata[] attachmentMetadatas = new JsonMetadata[this.obvMessage.getAttachments().length];
        int imageCount = 0;
        int attachmentCount = 0;
        Optional<Object> linkPreviewInfo = Optional.empty();
        for (int i = 0; i < this.obvMessage.getAttachments().length; ++i) {
            try {
                attachmentMetadatas[i] = (JsonMetadata)EngineWrapper.getJsonObjectMapper().readValue(this.obvMessage.getAttachments()[i].getMetadata(), JsonMetadata.class);
                String type = attachmentMetadatas[i].getType();
                if (ImageUtils.isImage(type)) {
                    ++imageCount;
                }
                if (ImageUtils.isLink(type)) {
                    linkPreviewInfo = Optional.of(new LinkPreviewInfo(Optional.empty(), false, Optional.empty()));
                }
                ++attachmentCount;
                continue;
            }
            catch (Exception e) {
                attachmentMetadatas[i] = null;
            }
        }
        try {
            int finalAttachmentCount = attachmentCount;
            int finalImageCount = imageCount;
            Optional finalLinkPreviewInfo = linkPreviewInfo;
            Pair transactionResult = TransactionWrapper.startQueryTransaction(() -> {
                List reactionRequests;
                Optional remoteEditRequestOpt;
                Group group;
                boolean needToUpdateNextScheduledExpiration = false;
                long messageServerTimestamp = this.obvMessage.getServerTimestamp();
                if (jsonMessage.getOriginalServerTimestamp() != null && discussion.getGroupId().isPresent() && (group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get())).isV2()) {
                    messageServerTimestamp = Math.min(messageServerTimestamp, jsonMessage.getOriginalServerTimestamp());
                }
                OwnedMessageEphemeralInfo messageEphemeralInfo = null;
                if (jsonExpiration != null) {
                    if (jsonExpiration.getVisibilityDuration() != null && (jsonExpiration.getExistenceDuration() == null || jsonExpiration.getExistenceDuration() > jsonExpiration.getVisibilityDuration())) {
                        jsonExpiration.setExistenceDuration(jsonExpiration.getVisibilityDuration());
                    }
                    messageEphemeralInfo = new OwnedMessageEphemeralInfo(false, jsonExpiration.getVisibilityDuration(), jsonExpiration.getExistenceDuration(), false);
                    DbManager.getInstance().getOwnedMessageEphemeralInfoDao().createIfNotExists(messageEphemeralInfo);
                }
                OwnedMessage messageToInsert = MessageBuilder.createOwnedMessage(discussion, jsonMessage, this.obvMessage.getIdentifier(), jsonReturnReceipt, messageServerTimestamp, finalAttachmentCount, finalImageCount, finalLinkPreviewInfo);
                Long remoteEditRequestServerTimestamp = null;
                if (messageRefOpt.isPresent() && (remoteEditRequestOpt = DbManager.getInstance().getRemoteEditRequestDao().getByMessageRef(discussion, (MessageRef)messageRefOpt.get())).isPresent()) {
                    RemoteEditRequest remoteEditRequest = (RemoteEditRequest)remoteEditRequestOpt.get();
                    Optional<String> newBody = remoteEditRequest.getBody().map(String::trim);
                    if (!Objects.equals(messageToInsert.getBody(), newBody)) {
                        messageToInsert.setBody(newBody);
                        messageToInsert.setEditionStatus(AbstractUserMessageGenerated.EditionStatus.UNSEEN);
                        remoteEditRequestServerTimestamp = remoteEditRequest.getTimestamp();
                    }
                    DbManager.getInstance().getRemoteEditRequestDao().customDelete(remoteEditRequest);
                }
                if ((messageToInsert = DbManager.getInstance().getOwnedMessageDao().createIfNotExists(messageToInsert)) == null) {
                    throw new SQLException("Unable to insert message in db");
                }
                if (messageEphemeralInfo != null) {
                    DbManager.getInstance().getOwnedMessageDao().updateEphemeraInfo(messageToInsert.getItemId(), messageEphemeralInfo);
                }
                if (messageRefOpt.isPresent()) {
                    DbManager.getInstance().getMessageRefDao().updateMessageRef(messageToInsert);
                }
                if (remoteEditRequestServerTimestamp != null) {
                    DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata(messageToInsert, OwnedMessageMetadataGenerated.Kind.EDITED, remoteEditRequestServerTimestamp));
                }
                if (discussion.isHidden()) {
                    discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                    DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                }
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, messageToInsert, false);
                DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata(messageToInsert, OwnedMessageMetadataGenerated.Kind.UPLOADED, this.obvMessage.getServerTimestamp()));
                DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata(messageToInsert, OwnedMessageMetadataGenerated.Kind.RECEIVED, System.currentTimeMillis()));
                if (messageEphemeralInfo != null && messageEphemeralInfo.getExistenceDuration().isPresent()) {
                    long existenceDuration = messageEphemeralInfo.getExistenceDuration().get();
                    long elapsedTimeBeforeDownload = Math.max(0L, this.obvMessage.getDownloadTimestamp() - this.obvMessage.getServerTimestamp());
                    long expirationTimestamp = this.obvMessage.getLocalDownloadTimestamp() + existenceDuration * 1000L - elapsedTimeBeforeDownload;
                    DbManager.getInstance().getOwnedMessageEphemeralInfoDao().updateExistenceExpiration(messageEphemeralInfo.getItemId(), expirationTimestamp);
                    needToUpdateNextScheduledExpiration = true;
                }
                if (messageRefOpt.isPresent() && (reactionRequests = DbManager.getInstance().getReactionRequestDao().getAllByMessageRef(discussion, (MessageRef)messageRefOpt.get())) != null) {
                    for (RemoteReactionRequest reactionRequest : reactionRequests) {
                        new UpdateReactionsTask(messageToInsert, discussion, reactionRequest.getEmoji(), reactionRequest.getIdentityRefId(), reactionRequest.getTimestamp(), false).call();
                    }
                    DbManager.getInstance().getReactionRequestDao().delete(reactionRequests);
                }
                return new Pair((Object)messageToInsert, (Object)needToUpdateNextScheduledExpiration);
            });
            if (((Boolean)transactionResult.getValue()).booleanValue()) {
                NCRegistry.getUtilityNC().postNotification(new ForceScheduleNextMessageExpirationTaskNotification());
            }
            message = (OwnedMessage)transactionResult.getKey();
        }
        catch (SQLException e) {
            this.logger.error("NewMessageReceivedTask.handleNormalMessage: unable to insert message or metadata in db", e);
            return;
        }
        if (jsonReturnReceipt != null) {
            Api.getMessageApi().sendMessageReturnReceipt(message, ReturnReceiptStatus.DELIVERED);
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        ArrayList<OwnedAttachment> attachmentsToDownload = new ArrayList<OwnedAttachment>();
        for (int i = 0; i < this.obvMessage.getAttachments().length; ++i) {
            ObvAttachment obvAttachment = this.obvMessage.getAttachments()[i];
            JsonMetadata attachmentMetadata = attachmentMetadatas[i];
            if (obvAttachment == null) continue;
            try {
                if (attachmentMetadata == null) {
                    throw new Exception();
                }
                byte[] sha256 = attachmentMetadata.getSha256();
                FileApi._acquireLock(obvAttachment.getUrl());
                try {
                    OwnedAttachment ownedAttachment;
                    Fyle fyle = DbManager.getInstance().getFyleDao().getFromHash(sha256);
                    if (fyle != null) {
                        if (fyle.isComplete()) {
                            Optional<LinkPreviewInfo> linkPreviewInfoOpt;
                            ownedAttachment = new OwnedAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), ReceivedAttachmentGenerated.Status.COMPLETE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                            DbManager.getInstance().getOwnedAttachmentDao().insert(ownedAttachment);
                            Api.getMessageApi().sendAttachmentReturnReceipt(message, ReturnReceiptStatus.DELIVERED, obvAttachment.getNumber());
                            Api.getAttachmentApi().markAttachmentForDeletion(obvAttachment);
                            if (ImageUtils.isLink(attachmentMetadata.getType()) && (linkPreviewInfoOpt = LinkPreviewInfo.of(List.of(ownedAttachment))).isPresent()) {
                                DbManager.getInstance().getOwnedMessageDao().updateLinkPreviewInfo(message.getItemId(), linkPreviewInfoOpt);
                            }
                            continue;
                        }
                        ownedAttachment = new OwnedAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), obvAttachment.isDownloadRequested() ? ReceivedAttachmentGenerated.Status.DOWNLOADING : ReceivedAttachmentGenerated.Status.DOWNLOADABLE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                        DbManager.getInstance().getOwnedAttachmentDao().insert(ownedAttachment);
                        attachmentsToDownload.add(ownedAttachment);
                        continue;
                    }
                    fyle = new Fyle(obvAttachment.getUrl());
                    fyle = DbManager.getInstance().getFyleDao().createIfNotExists(fyle);
                    ownedAttachment = new OwnedAttachment(fyle, discussion, message, ownedIdentity, attachmentMetadata.getFileName(), attachmentMetadata.getType(), obvAttachment.isDownloadRequested() ? ReceivedAttachmentGenerated.Status.DOWNLOADING : ReceivedAttachmentGenerated.Status.DOWNLOADABLE, obvAttachment.getExpectedLength(), obvAttachment.getMessageIdentifier(), (Integer)obvAttachment.getNumber());
                    DbManager.getInstance().getOwnedAttachmentDao().insert(ownedAttachment);
                    attachmentsToDownload.add(ownedAttachment);
                    continue;
                }
                finally {
                    FileApi._releaseLock(obvAttachment.getUrl());
                }
            }
            catch (Exception e) {
                this.logger.error("Error reading an attachment or creating the fyle (or message already expired and deleted)", e);
                Api.getAttachmentApi().markAttachmentForDeletion(obvAttachment);
            }
        }
        Api.getMessageApi().markMessageForDeletion(this.obvMessage);
        Optional<Long> automaticAttachmentDownloadSizeSetting = DbManager.getInstance().getApplicationSettingsDao().getAutomaticAttachmentDownloadSizeSetting();
        long threshold = automaticAttachmentDownloadSizeSetting.orElse(-1L);
        for (OwnedAttachment ownedAttachment : attachmentsToDownload) {
            boolean isLinkPreview;
            FileExtension extension = PreviewUtils.toFileExtension(ownedAttachment);
            boolean bl = isLinkPreview = extension == FileExtension.LINK;
            if (threshold != -1L && ownedAttachment.getSize() >= threshold && !isLinkPreview) continue;
            EngineWrapper.getInstance().downloadSmallAttachment(this.obvMessage.getBytesToIdentity(), ownedAttachment.getEngineMessageIdentifier(), ownedAttachment.getIdx());
            ownedAttachment.setStatus(ReceivedAttachmentGenerated.Status.DOWNLOADING);
            DbManager.getInstance().getOwnedAttachmentDao().update(ownedAttachment);
        }
    }

    private void handleAlreadyRemotelyDeletedMessage(Discussion discussion, IMessageSender messageSender, JsonMessage jsonMessage, JsonReturnReceipt jsonReturnReceipt, RemoteDeleteRequest remoteDeleteRequest) {
        try {
            ReceivedMessageGenerated receivedMessage;
            Pair transactionResult = TransactionWrapper.startQueryTransaction(() -> {
                JsonExpiration jsonExpiration = jsonMessage.getJsonExpiration();
                boolean sendExpireIntent = false;
                ReceivedMessageGenerated remotelyDeletedMessage = messageSender.isMe() ? MessageBuilder.createOwnedMessage(discussion, jsonMessage, this.obvMessage.getIdentifier(), jsonReturnReceipt, this.obvMessage.getServerTimestamp(), 0, 0, Optional.empty()) : MessageBuilder.createInboundMessage(discussion, messageSender.getContact(), jsonMessage, jsonReturnReceipt, this.obvMessage.getIdentifier(), this.obvMessage.getServerTimestamp(), 0, 0, InboundMessageGenerated.Status.READ, false, Optional.empty());
                remotelyDeletedMessage.setBody(Optional.empty());
                Optional<Id<Location>> locationId = remotelyDeletedMessage.getLocationId();
                if (locationId.isPresent()) {
                    DbManager.getInstance().getLocationDao().deleteById(locationId.get());
                }
                remotelyDeletedMessage.setReplyTo(Optional.empty());
                remotelyDeletedMessage.setForwarded(false);
                remotelyDeletedMessage.setWipeStatus(AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED);
                if (remotelyDeletedMessage instanceof InboundMessage) {
                    InboundMessage inboundMessage = (InboundMessage)remotelyDeletedMessage;
                    messageEphemeralInfo = null;
                    if (jsonExpiration != null && jsonExpiration.getExistenceDuration() != null) {
                        long existenceDuration = jsonExpiration.getExistenceDuration();
                        long elapsedTimeBeforeDownload = Math.max(0L, this.obvMessage.getDownloadTimestamp() - this.obvMessage.getServerTimestamp());
                        long existenceTimestamp = this.obvMessage.getLocalDownloadTimestamp() + existenceDuration * 1000L - elapsedTimeBeforeDownload;
                        boolean isReadOnce = jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce() != false;
                        messageEphemeralInfo = new InboundMessageEphemeralInfo(isReadOnce, jsonExpiration.getVisibilityDuration(), jsonExpiration.getExistenceDuration());
                        messageEphemeralInfo.setExistenceTimestamp(Optional.of(existenceTimestamp));
                        DbManager.getInstance().getInboundMessageEphemeralInfoDao().insert(messageEphemeralInfo);
                        sendExpireIntent = true;
                    }
                    remotelyDeletedMessage = DbManager.getInstance().getInboundMessageDao().createIfNotExists(inboundMessage);
                    if (messageEphemeralInfo != null) {
                        DbManager.getInstance().getInboundMessageDao().updateEphemeraInfo(inboundMessage.getItemId(), messageEphemeralInfo);
                    }
                } else if (remotelyDeletedMessage instanceof OwnedMessage) {
                    OwnedMessage ownedMessage = (OwnedMessage)remotelyDeletedMessage;
                    messageEphemeralInfo = null;
                    if (jsonExpiration != null && jsonExpiration.getExistenceDuration() != null) {
                        long existenceDuration = jsonExpiration.getExistenceDuration();
                        long elapsedTimeBeforeDownload = Math.max(0L, this.obvMessage.getDownloadTimestamp() - this.obvMessage.getServerTimestamp());
                        long existenceTimestamp = this.obvMessage.getLocalDownloadTimestamp() + existenceDuration * 1000L - elapsedTimeBeforeDownload;
                        boolean isReadOnce = jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce() != false;
                        messageEphemeralInfo = new OwnedMessageEphemeralInfo(isReadOnce, jsonExpiration.getVisibilityDuration(), jsonExpiration.getExistenceDuration(), false);
                        messageEphemeralInfo.setExistenceTimestamp(Optional.of(existenceTimestamp));
                        DbManager.getInstance().getOwnedMessageEphemeralInfoDao().insert(messageEphemeralInfo);
                        sendExpireIntent = true;
                    }
                    remotelyDeletedMessage = DbManager.getInstance().getOwnedMessageDao().createIfNotExists(ownedMessage);
                    if (messageEphemeralInfo != null) {
                        DbManager.getInstance().getOwnedMessageDao().updateEphemeraInfo(ownedMessage.getItemId(), messageEphemeralInfo);
                    }
                }
                DbManager.getInstance().getMessageRefDao().updateMessageRef(remotelyDeletedMessage);
                if (discussion.isHidden()) {
                    discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                    DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                }
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, remotelyDeletedMessage, false);
                IdentityRef remoteDeleter = DbManager.getInstance().getIdentityRefDao().get(remoteDeleteRequest.getIdentityRefId());
                if (remotelyDeletedMessage instanceof InboundMessage) {
                    DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata((InboundMessage)remotelyDeletedMessage, InboundMessageMetadataGenerated.Kind.RECEIVED, System.currentTimeMillis()));
                    DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata((InboundMessage)remotelyDeletedMessage, InboundMessageMetadataGenerated.Kind.REMOTE_DELETED, System.currentTimeMillis(), remoteDeleter));
                } else {
                    DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata((OwnedMessage)remotelyDeletedMessage, OwnedMessageMetadataGenerated.Kind.REMOTE_DELETED, System.currentTimeMillis(), remoteDeleter));
                }
                DbManager.getInstance().getRemoteDeleteRequestDao().customDelete(remoteDeleteRequest);
                Optional<MessageRef> referenceOpt = DbManager.getInstance().getMessageRefDao().get(remotelyDeletedMessage);
                if (referenceOpt.isPresent()) {
                    MessageRef messageRef = referenceOpt.get();
                    DbManager.getInstance().getReactionRequestDao().deleteAllByMessageRef(discussion, messageRef);
                }
                return new Pair((Object)remotelyDeletedMessage, (Object)sendExpireIntent);
            });
            if (((Boolean)transactionResult.getValue()).booleanValue()) {
                AsyncTaskExecutor.submitTask(MessageExpirationService.getInstance()::scheduleNextExpiration);
            }
            if ((receivedMessage = (ReceivedMessageGenerated)transactionResult.getKey()) instanceof InboundMessage) {
                InboundMessage inboundMessage = (InboundMessage)receivedMessage;
                Object inboundMessageId = inboundMessage.getItemId();
                InboundMessage message_ = (InboundMessage)DbManager.getInstance().getInboundMessageDao().get(inboundMessageId);
                if (jsonReturnReceipt != null) {
                    Api.getMessageApi().sendMessageReturnReceipt(message_, ReturnReceiptStatus.DELIVERED);
                }
                InboundMessage message = message_;
            } else if (receivedMessage instanceof OwnedMessage) {
                OwnedMessage ownedMessage = (OwnedMessage)receivedMessage;
                Object ownedMessageId = ownedMessage.getItemId();
                ReceivedMessageGenerated message = (ReceivedMessageGenerated)DbManager.getInstance().getOwnedMessageDao().get(ownedMessageId);
            } else {
                this.logger.error("HandleNewMessageTask.handleAlreadyRemotelyDeletedMessage: Found unexpected received message subtype");
                return;
            }
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
        }
        catch (SQLException e) {
            this.logger.error("HandleNewMessageTask.handleAlreadyRemotelyDeletedMessage: sql exception during transaction", e);
        }
    }

    private void handleSharedSettingsMessage(JsonSharedSettings jsonSharedSettings, IMessageSender messageSender, long serverTimestamp) {
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonSharedSettings.getGroupUid(), jsonSharedSettings.getGroupOwner(), jsonSharedSettings.getGroupV2Identifier(), jsonSharedSettings.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.CHANGE_SETTINGS));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
        if (discussionCustomization == null) {
            this.logger.error("HandleNewMessageTask: handleSharedSettingsMessage: unable to find discussion customization for this discussion: " + String.valueOf(discussion));
            return;
        }
        boolean oldReadOnce = discussionCustomization.isSettingReadOnce();
        Long oldVisibilityDuration = discussionCustomization.getSettingVisibilityDuration().orElse(null);
        Long oldExistenceDuration = discussionCustomization.getSettingExistenceDuration().orElse(null);
        if (discussionCustomization.getSharedSettingsVersion() < jsonSharedSettings.getVersion()) {
            discussionCustomization.setSharedSettingsVersion(jsonSharedSettings.getVersion());
            if (jsonSharedSettings.getJsonExpiration() == null) {
                discussionCustomization.setSettingReadOnce(false);
                discussionCustomization.setSettingVisibilityDuration(Optional.empty());
                discussionCustomization.setSettingExistenceDuration(Optional.empty());
            } else {
                discussionCustomization.setSettingReadOnce(jsonSharedSettings.getJsonExpiration().getReadOnce() != null && jsonSharedSettings.getJsonExpiration().getReadOnce() != false);
                discussionCustomization.setSettingVisibilityDuration(Optional.ofNullable(jsonSharedSettings.getJsonExpiration().getVisibilityDuration()));
                discussionCustomization.setSettingExistenceDuration(Optional.ofNullable(jsonSharedSettings.getJsonExpiration().getExistenceDuration()));
            }
        } else if (discussionCustomization.getSharedSettingsVersion() == jsonSharedSettings.getVersion()) {
            if (jsonSharedSettings.getJsonExpiration() == null) {
                return;
            }
            JsonExpiration gcdExpiration = jsonSharedSettings.getJsonExpiration().computeGcd(discussionCustomization.getExpirationJson());
            discussionCustomization.setSettingReadOnce(gcdExpiration.getReadOnce() != null && gcdExpiration.getReadOnce() != false);
            discussionCustomization.setSettingVisibilityDuration(Optional.ofNullable(gcdExpiration.getVisibilityDuration()));
            discussionCustomization.setSettingExistenceDuration(Optional.ofNullable(gcdExpiration.getExistenceDuration()));
        } else {
            if (discussion.getContactId().isPresent() && (jsonSharedSettings = discussionCustomization.getSharedSettingsJson()) != null) {
                MessagePostHelper.postDiscussionSettingsUpdatedMessageDbTask(discussion, jsonSharedSettings);
            }
            return;
        }
        if (discussionCustomization.isSettingReadOnce() ^ oldReadOnce || !Objects.equals(oldVisibilityDuration, discussionCustomization.getSettingVisibilityDuration().orElse(null)) || !Objects.equals(oldExistenceDuration, discussionCustomization.getSettingExistenceDuration().orElse(null))) {
            IdentityRef identityRef = messageSender.getIdentityRef();
            if (MessageInsertionHelper.insertDiscussionSettingsUpdateMessageDbTask(discussion, discussionCustomization.getSharedSettingsJson().getJsonExpiration(), identityRef, serverTimestamp, MessageBuilder.MessageSystemPosition.MESSAGE_TIMESTAMP)) {
                DbManager.getInstance().getDiscussionCustomizationDao().update(discussionCustomization);
            }
        }
    }

    private boolean handleDeleteDiscussion(JsonDeleteDiscussion jsonDeleteDiscussion, IMessageSender messageSender, long serverTimestamp) {
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonDeleteDiscussion.getGroupUid(), jsonDeleteDiscussion.getGroupOwner(), jsonDeleteDiscussion.getGroupV2Identifier(), jsonDeleteDiscussion.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.REMOTE_DELETE_ANYTHING));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask:handleDeleteDiscussion no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return false;
        }
        Discussion discussion = discussionOpt.get();
        discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(discussion.getItemId());
        if (!DiscussionDeletionHelper.deleteDiscussionLocallyDbTask((Id<Discussion>)discussion.getItemId())) {
            this.logger.error("HandleNewMessageTask: handleDeleteDiscussion: unable to process, will retry on restart");
        }
        MessageInsertionHelper.insertDiscussionRemotelyDeletedMessage(discussion, messageSender.getIdentityRef(), serverTimestamp);
        return true;
    }

    private void handleDeleteMessages(JsonDeleteMessages jsonDeleteMessages, IMessageSender messageSender, long serverTimestamp) {
        boolean editAndDeleteOwnMessagesPermission;
        boolean remoteDeletePermission;
        Either<Object, Object> ownedIdOrContact;
        if (jsonDeleteMessages.getMessageReferences() == null || jsonDeleteMessages.getMessageReferences().isEmpty()) {
            return;
        }
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonDeleteMessages.getGroupUid(), jsonDeleteMessages.getGroupOwner(), jsonDeleteMessages.getGroupV2Identifier(), jsonDeleteMessages.getOneToOneIdentifier(), messageSender, List.of());
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        Either<Object, Object> either = ownedIdOrContact = messageSender.isMe() ? Either.left(messageSender.getMe().getItemId()) : Either.right(messageSender.getContact().getItemId());
        if (discussion.isGroupDiscussion()) {
            remoteDeletePermission = GroupHelper.containsPermission(discussion.getGroupId().orElseThrow(IllegalStateException::new), ownedIdOrContact, List.of(GroupV2.Permission.REMOTE_DELETE_ANYTHING));
            editAndDeleteOwnMessagesPermission = GroupHelper.containsPermission(discussion.getGroupId().orElseThrow(IllegalStateException::new), ownedIdOrContact, List.of(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES));
        } else {
            remoteDeletePermission = true;
            editAndDeleteOwnMessagesPermission = true;
        }
        for (JsonMessageReference messageReference : jsonDeleteMessages.getMessageReferences()) {
            MessageRef messageRef;
            Optional<AbstractUserMessageGenerated<?>> messageOpt = MessageHelper.get((Id<Discussion>)discussion.getItemId(), messageReference);
            if (messageOpt.isPresent()) {
                AbstractUserMessageGenerated<?> message = messageOpt.get();
                try {
                    TransactionWrapper.startStatementTransaction(() -> {
                        boolean messageIsFromMessageSender;
                        if (messageSender.isMe()) {
                            messageIsFromMessageSender = message instanceof OwnedMessage || message instanceof OutboundMessage;
                        } else if (message instanceof InboundMessage) {
                            InboundMessage inboundMessage = (InboundMessage)message;
                            ContactRef senderRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(messageSender.getContact());
                            messageIsFromMessageSender = Objects.equals(senderRef.getItemId(), inboundMessage.getSenderId());
                        } else {
                            messageIsFromMessageSender = false;
                        }
                        if (remoteDeletePermission || messageIsFromMessageSender && editAndDeleteOwnMessagesPermission) {
                            if (messageIsFromMessageSender) {
                                MessageDeletionHelper.deleteMessagesDbTask(List.of(message), false);
                            } else {
                                MessageDeletionHelper.wipeMessageContentAfterARemoteDeleteDbTask(message, messageSender.getIdentityRef(), serverTimestamp);
                            }
                        } else {
                            this.logger.error("NewMessageReceivedTask::handleDeleteMessages: Received a JsonDeleteMessages from a sender without permissions.");
                        }
                        return null;
                    });
                    continue;
                }
                catch (SQLException e) {
                    this.logger.error("NewMessageReceivedTask::handleDeleteMessages: An error occurred when remote deleting message", e);
                    return;
                }
            }
            Optional<MessageRef> messageRefOpt = DbManager.getInstance().getMessageRefDao().get((Id<Discussion>)discussion.getItemId(), messageReference);
            if (messageRefOpt.isPresent()) {
                messageRef = messageRefOpt.get();
                if (messageRef.isMessageHasBeenReceived()) {
                    return;
                }
                Optional remoteEditRequestOpt = DbManager.getInstance().getRemoteEditRequestDao().getByMessageRef(discussion, messageRef);
                if (remoteEditRequestOpt.isPresent()) {
                    RemoteEditRequest remoteEditRequest = (RemoteEditRequest)remoteEditRequestOpt.get();
                    if (remoteDeletePermission || messageSender.isMe() || editAndDeleteOwnMessagesPermission && Arrays.equals(messageReference.getSenderIdentifier(), messageSender.getIdentityBytes())) {
                        DbManager.getInstance().getRemoteEditRequestDao().customDelete(remoteEditRequest);
                    }
                }
            }
            messageRef = DbManager.getInstance().getMessageRefDao().getOrCreate(discussion, messageReference);
            RemoteDeleteRequest remoteDeleteRequest = new RemoteDeleteRequest(discussion, messageSender.getIdentityRef(), messageRef, serverTimestamp);
            DbManager.getInstance().getRemoteDeleteRequestDao().insert(remoteDeleteRequest);
        }
    }

    private void handleUpdateMessage(JsonUpdateMessage jsonUpdateMessage, IMessageSender messageSender, long serverTimestamp) {
        if (jsonUpdateMessage.getMessageReference() == null || !Arrays.equals(messageSender.getIdentityBytes(), jsonUpdateMessage.getMessageReference().getSenderIdentifier())) {
            return;
        }
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonUpdateMessage.getGroupUid(), jsonUpdateMessage.getGroupOwner(), jsonUpdateMessage.getGroupV2Identifier(), jsonUpdateMessage.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        Optional<AbstractUserMessageGenerated<?>> userMessageOpt = MessageHelper.get((Id<Discussion>)discussion.getItemId(), jsonUpdateMessage.getMessageReference());
        Optional<String> newBody = Optional.ofNullable(jsonUpdateMessage.getBody()).map(String::trim);
        if (userMessageOpt.isPresent()) {
            AbstractUserMessageGenerated<?> userMessage = userMessageOpt.get();
            if (userMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.WIPED || userMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
                return;
            }
            if (jsonUpdateMessage.getJsonLocation() == null) {
                if (Objects.equals(userMessage.getBody(), newBody)) {
                    return;
                }
                try {
                    TransactionWrapper.startStatementTransaction(() -> {
                        if (userMessage instanceof InboundMessage) {
                            InboundMessage inboundMessage = (InboundMessage)userMessage;
                            DbManager.getInstance().getInboundMessageDao().updateBodyAndMarkAsEdited(inboundMessage.getItemId(), newBody);
                            DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata(inboundMessage, InboundMessageMetadataGenerated.Kind.EDITED, serverTimestamp));
                        }
                        if (userMessage instanceof OutboundMessage) {
                            OutboundMessage outboundMessage = (OutboundMessage)userMessage;
                            DbManager.getInstance().getOutboundMessageDao().updateBodyAndMarkAsEdited((Id<OutboundMessage>)outboundMessage.getItemId(), newBody);
                            DbManager.getInstance().getOutboundMessageMetadataDao().insert(new OutboundMessageMetadata(outboundMessage, OutboundMessageMetadataGenerated.Kind.EDITED, serverTimestamp));
                        }
                        if (userMessage instanceof OwnedMessage) {
                            OwnedMessage ownedMessage = (OwnedMessage)userMessage;
                            DbManager.getInstance().getOwnedMessageDao().updateBodyAndMarkAsEdited(ownedMessage.getItemId(), newBody);
                            DbManager.getInstance().getOwnedMessageMetadataDao().insert(new OwnedMessageMetadata(ownedMessage, OwnedMessageMetadataGenerated.Kind.EDITED, serverTimestamp));
                        }
                        return null;
                    });
                }
                catch (SQLException e) {
                    this.logger.error("handleUpdateMessage: An error occurred when updating message", e);
                    return;
                }
            } else if (userMessage instanceof InboundMessage) {
                InboundMessage inboundMessage = (InboundMessage)userMessage;
                Optional<Id<Location>> locationIdOpt = inboundMessage.getLocationId();
                if (locationIdOpt.isEmpty()) {
                    this.logger.error("NewMessageReceivedTask: trying to update a message that is not a location message");
                    return;
                }
                Id<Location> locationId = locationIdOpt.get();
                Location location = DbManager.getInstance().getLocationDao().get(locationId);
                switch (location.getType()) {
                    case SEND: {
                        this.logger.error("NewMessageReceivedTask: trying to update a message that is not location sharing");
                        return;
                    }
                }
                JsonLocation jsonLocation = jsonUpdateMessage.getJsonLocation();
                if (jsonLocation.getType() == 3) {
                    DbManager.getInstance().getLocationDao().updateLocationType((Id<Location>)location.getItemId(), LocationGenerated.Type.SHARE_FINISHED);
                    DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata(inboundMessage, InboundMessageMetadataGenerated.Kind.LOCATION_SHARING_END, serverTimestamp));
                } else if (jsonLocation.getType() == 2) {
                    Optional<Long> countOpt = location.getCount();
                    if (countOpt.isPresent() && jsonLocation.getCount() != null) {
                        long count = countOpt.get();
                        if (jsonLocation.getCount() <= count) {
                            AppLogger.i("NewMessageReceivedTask: updateLocationMessage: received invalid count, ignoring");
                            return;
                        }
                    }
                    DbManager.getInstance().getLocationDao().updateLocation((Id<Location>)location.getItemId(), jsonLocation);
                    Optional<InboundMessageMetadata> messageMetadata = inboundMessage.getMetadata(InboundMessageMetadataGenerated.Kind.LOCATION_SHARING_LATEST_UPDATE);
                    if (messageMetadata.isPresent()) {
                        DbManager.getInstance().getInboundMessageMetadataDao().updateTimestamp(messageMetadata.get(), serverTimestamp);
                    } else {
                        DbManager.getInstance().getInboundMessageMetadataDao().insert(new InboundMessageMetadata(inboundMessage, InboundMessageMetadataGenerated.Kind.LOCATION_SHARING_LATEST_UPDATE, serverTimestamp));
                    }
                }
            }
        } else {
            MessageRef messageRef;
            Optional<MessageRef> messageRefOpt = DbManager.getInstance().getMessageRefDao().get((Id<Discussion>)discussion.getItemId(), jsonUpdateMessage.getMessageReference());
            if (messageRefOpt.isPresent()) {
                if (messageRefOpt.get().isMessageHasBeenReceived()) {
                    return;
                }
                messageRef = messageRefOpt.get();
                Optional remoteDeleteRequestOpt = DbManager.getInstance().getRemoteDeleteRequestDao().getByMessageRef(discussion, messageRef);
                if (remoteDeleteRequestOpt.isPresent()) {
                    return;
                }
                Optional remoteEditRequestOpt = DbManager.getInstance().getRemoteEditRequestDao().getByMessageRef(discussion, messageRef);
                if (remoteEditRequestOpt.isPresent()) {
                    RemoteEditRequest remoteEditRequest = (RemoteEditRequest)remoteEditRequestOpt.get();
                    if (remoteEditRequest.getTimestamp() > serverTimestamp) {
                        return;
                    }
                    DbManager.getInstance().getRemoteEditRequestDao().customDelete(remoteEditRequest);
                }
            }
            messageRef = DbManager.getInstance().getMessageRefDao().getOrCreate(discussion, jsonUpdateMessage.getMessageReference());
            RemoteEditRequest remoteEditRequest = new RemoteEditRequest(discussion, messageSender.getIdentityRef(), messageRef, serverTimestamp, newBody);
            DbManager.getInstance().getRemoteEditRequestDao().insert(remoteEditRequest);
        }
    }

    private void handleReactionMessage(JsonReaction jsonReaction, IMessageSender messageSender, long serverTimestamp) {
        if (jsonReaction.getMessageReference() == null) {
            AppLogger.i("HandNewMessageTask.handleReactionMessage: malformed message payload, IGNORING IT!");
            return;
        }
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonReaction.getGroupUid(), jsonReaction.getGroupOwner(), jsonReaction.getGroupV2Identifier(), jsonReaction.getOneToOneIdentifier(), messageSender, List.of(GroupV2.Permission.SEND_MESSAGE));
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        JsonMessageReference jsonMessageReference = jsonReaction.getMessageReference();
        Optional<AbstractUserMessageGenerated<?>> messageOpt = MessageHelper.get((Id<Discussion>)discussion.getItemId(), jsonMessageReference);
        Optional<String> emoji = Optional.ofNullable(jsonReaction.getReaction());
        if (messageOpt.isPresent()) {
            AbstractUserMessageGenerated<?> message = messageOpt.get();
            if (message.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.WIPED || message.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
                return;
            }
            new UpdateReactionsTask(message, discussion, emoji, (Id<IdentityRef>)messageSender.getIdentityRef().getItemId(), serverTimestamp, false).call();
        } else {
            MessageRef messageRef = DbManager.getInstance().getMessageRefDao().getOrCreate(discussion, jsonMessageReference);
            RemoteReactionRequest reactionRequest = (RemoteReactionRequest)DbManager.getInstance().getReactionRequestDao().getByMessageAndIdentityRef(discussion, messageRef, messageSender.getIdentityRef());
            if (reactionRequest == null) {
                reactionRequest = new RemoteReactionRequest(discussion, messageRef, messageSender.getIdentityRef(), serverTimestamp, emoji);
                DbManager.getInstance().getReactionRequestDao().insert(reactionRequest);
            } else if (reactionRequest.getTimestamp() < serverTimestamp) {
                DbManager.getInstance().getReactionRequestDao().updateEmojiAndTimestamp((Id<RemoteReactionRequest>)reactionRequest.getItemId(), emoji, serverTimestamp);
            }
        }
    }

    private void handleDiscussionReadMessage(JsonDiscussionRead jsonDiscussionRead, IMessageSender messageSender) {
        if (!messageSender.isMe()) {
            return;
        }
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonDiscussionRead.getGroupUid(), jsonDiscussionRead.getGroupOwner(), jsonDiscussionRead.getGroupV2Identifier(), jsonDiscussionRead.getOneToOneIdentifier(), messageSender, List.of());
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        long lastReadMessageTimestamp = jsonDiscussionRead.getLastReadMessageServerTimestamp();
        int count = DbManager.getInstance().getInboundMessageDao().markDiscussionMessagesReadUpTo((Id<Discussion>)discussion.getItemId(), Optional.of(lastReadMessageTimestamp));
        UnreadMessageCountCache.getInstance().decrementUnreadCount(discussion.getOwnedIdentityId(), (Id<Discussion>)discussion.getItemId(), count);
    }

    private void handleLimitedVisibilityOpenedMessage(JsonLimitedVisibilityMessageOpened jsonLimitedVisibilityMessageOpened, IMessageSender messageSender, long serverTimestamp, long downloadTimestamp) {
        if (!messageSender.isMe() || jsonLimitedVisibilityMessageOpened.messageReference == null) {
            return;
        }
        Optional<Discussion> discussionOpt = this.getDiscussion(jsonLimitedVisibilityMessageOpened.getGroupUid(), jsonLimitedVisibilityMessageOpened.getGroupOwner(), jsonLimitedVisibilityMessageOpened.getGroupV2Identifier(), jsonLimitedVisibilityMessageOpened.getOneToOneIdentifier(), messageSender, List.of());
        if (discussionOpt.isEmpty()) {
            this.logger.error("HandleNewMessageTask: no discussion found for message, aborting");
            EngineWrapper.getInstance().deleteMessageAndAttachments(this.obvMessage.getBytesToIdentity(), this.obvMessage.getIdentifier());
            return;
        }
        Discussion discussion = discussionOpt.get();
        JsonMessageReference messageReference = jsonLimitedVisibilityMessageOpened.messageReference;
        Optional<InboundMessage> messageOpt = DbManager.getInstance().getInboundMessageDao().get((Id<Discussion>)discussion.getItemId(), messageReference);
        messageOpt.ifPresent(message -> {
            if (message.isBoxed()) {
                new InboundEphemeralUnboxTask((Id<InboundMessage>)message.getItemId(), downloadTimestamp - serverTimestamp, true).run();
            }
        });
    }

    private byte[] getGroupV1Identifier(byte[] bytesGroupUid, byte[] bytesGroupOwner) {
        byte[] groupIdentifier = new byte[bytesGroupUid.length + bytesGroupOwner.length];
        System.arraycopy(bytesGroupOwner, 0, groupIdentifier, 0, bytesGroupOwner.length);
        System.arraycopy(bytesGroupUid, 0, groupIdentifier, bytesGroupOwner.length, bytesGroupUid.length);
        return groupIdentifier;
    }

    private Optional<Discussion> getDiscussion(byte[] bytesGroupUid, byte[] bytesGroupOwner, byte[] groupV2Identifier, JsonOneToOneMessageIdentifier oneToOneMessageIdentifier, IMessageSender messageSender, Collection<GroupV2.Permission> requiredPermissions) {
        Discussion discussion;
        if (bytesGroupUid == null && bytesGroupOwner == null && groupV2Identifier == null) {
            if (oneToOneMessageIdentifier != null) {
                byte[] bytesContactIdentity = oneToOneMessageIdentifier.getBytesContactIdentity(this.ownedIdentity.getBytesOwnedIdentity());
                if (bytesContactIdentity == null) {
                    return Optional.empty();
                }
                discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), bytesContactIdentity);
            } else {
                discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), messageSender.getIdentityBytes());
            }
            if (discussion == null) {
                return Optional.empty();
            }
        } else {
            Either<Object, Object> ownedIdOrContact;
            if ((bytesGroupUid == null || bytesGroupOwner == null) && groupV2Identifier == null) {
                AppLogger.i("HandNewMessageTask: a message with one of groupOwner or groupUid null, IGNORING IT!");
                return Optional.empty();
            }
            byte[] groupIdentifier = groupV2Identifier == null ? this.getGroupV1Identifier(bytesGroupUid, bytesGroupOwner) : groupV2Identifier;
            AppLogger.t("NewMessageReceivedTask::getDiscussion group id : " + new String(groupIdentifier, StandardCharsets.UTF_8));
            discussion = DbManager.getInstance().getDiscussionDao().getDiscussionFromGroupIdentifier(groupIdentifier, (Id<OwnedIdentity>)this.ownedIdentity.getItemId());
            if (discussion == null) {
                return Optional.empty();
            }
            Optional<Id<Group>> groupOpt = discussion.getGroupId();
            if (groupOpt.isEmpty()) {
                this.logger.error("Unexpected case, cannot find Group from a group discussion");
                return Optional.empty();
            }
            Either<Object, Object> either = ownedIdOrContact = messageSender.isMe() ? Either.left(messageSender.getMe().getItemId()) : Either.right(messageSender.getContact().getItemId());
            if (!GroupHelper.containsPermission(groupOpt.get(), ownedIdOrContact, requiredPermissions)) {
                AppLogger.i("NewMessageReceivedTask::getDiscussion() Received a message from someone without proper permission --> IGNORING IT!");
                return Optional.empty();
            }
        }
        return Optional.of(discussion);
    }

    private boolean putMessageOnHoldIfNeeded(IMessageSender messageSender, Optional<byte[]> bytesGroupIdentifierOpt, Optional<JsonOneToOneMessageIdentifier> oneToOneIdOpt, ObvMessage obvMessage) {
        GroupDao groupDao = DbManager.getInstance().getGroupDao();
        DiscussionDao discussionDao = DbManager.getInstance().getDiscussionDao();
        ContactGroupJoinDao contactGroupJoinDao = DbManager.getInstance().getContactGroupJoinDao();
        PendingGroupMemberDao pendingGroupMemberDao = DbManager.getInstance().getPendingGroupMemberDao();
        if (UnknownRecipientObvMessagesHelper.isTooOld(obvMessage)) {
            return false;
        }
        if (bytesGroupIdentifierOpt.isPresent()) {
            boolean putOnHold;
            byte[] bytesGroupIdentifier = bytesGroupIdentifierOpt.get();
            if (messageSender.isMe()) {
                putOnHold = discussionDao.getByGroupIdentifierWithAnyStatus((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), bytesGroupIdentifier).isEmpty();
            } else {
                Group group = groupDao.get((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), bytesGroupIdentifier);
                if (group == null) {
                    putOnHold = true;
                } else {
                    putOnHold = contactGroupJoinDao.getContactGroupJoinCount((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), (Id<Group>)group.getItemId(), messageSender.getIdentityBytes()) == 0L;
                    putOnHold &= pendingGroupMemberDao.getMemberCount(group, messageSender.getIdentityBytes()) == 0L;
                }
            }
            if (putOnHold) {
                this.logger.debug("NewMessageReceivedTask::run Putting received group v2 message on hold.");
                UnknownRecipientObvMessagesHelper.putGroupV2MessageOnHold(new UnknownRecipientObvMessagesHelper.OnHoldMessageInput(this.ownedIdentity.getBytesOwnedIdentity(), bytesGroupIdentifier, obvMessage));
                return true;
            }
        } else {
            boolean hold;
            if (oneToOneIdOpt.isEmpty()) {
                return false;
            }
            JsonOneToOneMessageIdentifier oneToOneId = oneToOneIdOpt.get();
            if (messageSender.isMe()) {
                hold = discussionDao.getWithContactBytes((Id<OwnedIdentity>)this.ownedIdentity.getItemId(), oneToOneId.getBytesContactIdentity(this.ownedIdentity.getBytesOwnedIdentity())).isEmpty();
            } else {
                boolean bl = hold = !messageSender.isContact() || messageSender.getContact().isCollected();
            }
            if (hold) {
                this.logger.debug("NewMessageReceivedTask::run Putting received not one-to-one contact message on hold.");
                UnknownRecipientObvMessagesHelper.putOneToOneMessageOnHold(new UnknownRecipientObvMessagesHelper.OnHoldMessageInput(this.ownedIdentity.getBytesOwnedIdentity(), oneToOneId.getBytesContactIdentity(this.ownedIdentity.getBytesOwnedIdentity()), obvMessage));
                return true;
            }
        }
        return false;
    }
}

