/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageDeletionHelper;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ForceScheduleNextMessageExpirationTaskNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExpiringOutboundMessageSentTask
implements Runnable {
    private final OutboundMessage message;

    public ExpiringOutboundMessageSentTask(OutboundMessage message) {
        this.message = message;
    }

    @Override
    public void run() {
        if (this.message == null) {
            return;
        }
        Optional<OutboundMessageEphemeralInfo> messageEphemeralInfoOpt = DbManager.getInstance().getOutboundMessageDao().getEphemeralInfo(this.message);
        if (messageEphemeralInfoOpt.isEmpty()) {
            return;
        }
        OutboundMessageEphemeralInfo messageEphemeralInfo = messageEphemeralInfoOpt.get();
        boolean sendExpirationIntent = false;
        if (this.message.getWipeStatus() != AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(this.message.getDiscussionId());
            DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization(this.message.getDiscussionId());
            boolean retainMessage = false;
            if (discussionCustomization != null) {
                retainMessage = discussionCustomization.getPrefRetainWipedOutboundMessages().orElse(false);
            }
            boolean messageIsWiped = false;
            if (messageEphemeralInfo.isReadOnce()) {
                Discussion selectedDiscussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
                if (Objects.equals(selectedDiscussion, discussion)) {
                    DbManager.getInstance().getOutboundMessageDao().updateWipe(this.message.getItemId(), AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ);
                } else {
                    messageIsWiped = true;
                    if (retainMessage) {
                        MessageDeletionHelper.wipeOutboundMessagesContentDbTask(List.of(this.message));
                    } else {
                        MessageDeletionHelper.deleteMessagesDbTask(List.of(this.message), false);
                    }
                }
            }
            if (!messageIsWiped && messageEphemeralInfo.getVisibilityDuration().isPresent() && messageEphemeralInfo.getVisibilityTimestamp().isEmpty()) {
                sendExpirationIntent = true;
                long visibilityDuration = messageEphemeralInfo.getVisibilityDuration().get();
                long visibilityTimestamp = System.currentTimeMillis() + visibilityDuration * 1000L;
                DbManager.getInstance().getOutboundMessageEphemeralInfoDao().updateVisibilityExpiration((Id<OutboundMessageEphemeralInfo>)messageEphemeralInfo.getItemId(), visibilityTimestamp, retainMessage);
            }
        }
        if (messageEphemeralInfo.getExistenceDuration().isPresent()) {
            sendExpirationIntent = true;
            if (messageEphemeralInfo.getExistenceTimestamp().isPresent()) {
                AppLogger.e("ExpiringOutboundMessageSent: try to add another existence expiration");
            } else {
                long existenceDuration = messageEphemeralInfo.getExistenceDuration().get();
                long existenceTimestamp = System.currentTimeMillis() + existenceDuration * 1000L;
                DbManager.getInstance().getOutboundMessageEphemeralInfoDao().updateExistenceExpiration(messageEphemeralInfo.getItemId(), existenceTimestamp);
            }
        }
        if (sendExpirationIntent) {
            NCRegistry.getUtilityNC().postNotification(new ForceScheduleNextMessageExpirationTaskNotification());
        }
    }
}

