/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.misc.ImageUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CreateUnprocessedMessage
implements Supplier<OutboundMessage> {
    private final Optional<String> body;
    private final Id<Discussion> discussionId;
    private final Optional<JsonExpiration> jsonExpiration;
    private final Optional<MessageRef> repliedMessageRef;

    public CreateUnprocessedMessage(Optional<String> body, Id<Discussion> discussionId, Optional<JsonExpiration> jsonExpiration, Optional<MessageRef> repliedMessageRef) {
        this.body = body;
        this.discussionId = discussionId;
        this.jsonExpiration = jsonExpiration;
        this.repliedMessageRef = repliedMessageRef;
    }

    @Override
    public OutboundMessage get() {
        OutboundMessage message;
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(this.discussionId);
        if (discussion == null) {
            Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: discussion not found");
            return null;
        }
        if (discussion.isPreDiscussion() || discussion.isLocked()) {
            Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: trying to post in locked or pre discussion");
            return null;
        }
        Long copyingCount = DbManager.getInstance().getOutboundAttachmentDao().getDiscussionCopyingAttachmentsCount(this.discussionId);
        if (copyingCount == null || copyingCount > 0L) {
            Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: some attachments are not fully copied");
            return null;
        }
        JsonExpiration discussionDefaultJsonExpiration = null;
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
        if (discussionCustomization != null) {
            discussionDefaultJsonExpiration = discussionCustomization.getExpirationJson();
        }
        JsonExpiration effectiveJsonExpiration = this.jsonExpiration.isEmpty() ? discussionDefaultJsonExpiration : this.jsonExpiration.get().computeGcd(discussionDefaultJsonExpiration);
        List<OutboundAttachment> outboundAttachments = DbManager.getInstance().getOutboundAttachmentDao().getDiscussionDraftAndCopyingAttachments(this.discussionId);
        try {
            message = TransactionWrapper.startQueryTransaction(() -> {
                OutboundMessage messageToInsert;
                discussion.setLastOutboundMessageSequenceNumber(discussion.getLastOutboundMessageSequenceNumber() + 1L);
                if (discussion.isHidden()) {
                    discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                    DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
                }
                DbManager.getInstance().getDiscussionDao().updateLastOutboundMessageSequenceNumber(discussion);
                Location location = null;
                boolean isForwarded = false;
                int imageCount = 0;
                for (OutboundAttachment attachment : outboundAttachments) {
                    if (!ImageUtils.isImage(AttachmentUtils.getNonNullMimeType(attachment))) continue;
                    ++imageCount;
                }
                Optional<LinkPreviewInfo> linkPreviewInfo = LinkPreviewInfo.of(outboundAttachments);
                Optional<OutboundMessage> draftOpt = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)discussion.getItemId());
                if (draftOpt.isEmpty()) {
                    messageToInsert = MessageBuilder.createOutboundMessage(discussion, this.repliedMessageRef, location, this.body, false, outboundAttachments.size(), imageCount, linkPreviewInfo);
                    messageToInsert = DbManager.getInstance().getOutboundMessageDao().createIfNotExists(messageToInsert);
                    if (messageToInsert == null) {
                        Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: unable to insert message in database");
                        throw new SQLException("unable to insert message in database");
                    }
                } else {
                    messageToInsert = draftOpt.get();
                    DbManager.getInstance().getOutboundMessageDao().updateDraftToUnprocessed((Id<OutboundMessage>)messageToInsert.getItemId(), this.body, discussion.getLastOutboundMessageSequenceNumber(), System.currentTimeMillis(), outboundAttachments.size(), imageCount, linkPreviewInfo);
                }
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, messageToInsert, false);
                if (effectiveJsonExpiration != null) {
                    Optional<OutboundMessageEphemeralInfo> outboundMessageEphemeralInfoOpt = DbManager.getInstance().getOutboundMessageDao().getEphemeralInfo(messageToInsert);
                    if (outboundMessageEphemeralInfoOpt.isEmpty()) {
                        OutboundMessageEphemeralInfo outboundMessageEphemeralInfo = new OutboundMessageEphemeralInfo(effectiveJsonExpiration.getReadOnce(), effectiveJsonExpiration.getVisibilityDuration(), effectiveJsonExpiration.getExistenceDuration(), false);
                        outboundMessageEphemeralInfo = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().createIfNotExists(outboundMessageEphemeralInfo);
                        if (outboundMessageEphemeralInfo == null) {
                            Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: unable to insert message ephemeral info in database");
                            throw new SQLException("unable to insert insert message ephemeral info in database");
                        }
                        DbManager.getInstance().getOutboundMessageDao().updateEphemeraInfo(messageToInsert.getItemId(), outboundMessageEphemeralInfo);
                    } else {
                        OutboundMessageEphemeralInfo outboundMessageEphemeralInfo = outboundMessageEphemeralInfoOpt.get();
                        DbManager.getInstance().getOutboundMessageEphemeralInfoDao().refresh(outboundMessageEphemeralInfo);
                        JsonExpiration jsonExpirationInfo = MessageHelper.getJsonExpiration(outboundMessageEphemeralInfo);
                        jsonExpirationInfo = jsonExpirationInfo.computeGcd(effectiveJsonExpiration);
                        DbManager.getInstance().getOutboundMessageEphemeralInfoDao().update(outboundMessageEphemeralInfoOpt.get().getItemId(), jsonExpirationInfo.getReadOnce(), jsonExpirationInfo.getVisibilityDuration(), jsonExpirationInfo.getExistenceDuration());
                    }
                }
                if (!outboundAttachments.isEmpty()) {
                    DbManager.getInstance().getOutboundAttachmentDao().updateStatusForMessage((Id<OutboundMessage>)messageToInsert.getItemId(), OutboundAttachmentGenerated.Status.UNPROCESSED);
                }
                return messageToInsert;
            });
        }
        catch (SQLException throwables) {
            Logger.e((String)"UserMessagePostHelper.createUnprocessedMessageDbTask: sql exception in transaction", (Exception)throwables);
            return null;
        }
        return message;
    }
}

