/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.windows.messenger.engine.helpers.message.tasks.NewMessageReceivedTask;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UnknownRecipientObvMessagesHelper {
    public static final long UNKNOWN_RECIPIENT_MESSAGES_TTL = 172800000L;
    private static final HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> pendingGroupV2Messages = new HashMap();
    private static final HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> pendingOneToOneMessages = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putGroupV2MessageOnHold(OnHoldMessageInput input) {
        HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> hashMap = pendingGroupV2Messages;
        synchronized (hashMap) {
            BytesKey ownedIdentityBytesKey = new BytesKey(input.ownedIdentityBytes);
            HashMap ownedIdentityMap = pendingGroupV2Messages.computeIfAbsent(ownedIdentityBytesKey, k -> new HashMap());
            BytesKey groupIdentifierBytesKey = new BytesKey(input.recipientBytes);
            List groupMessages = ownedIdentityMap.computeIfAbsent(groupIdentifierBytesKey, k -> new ArrayList());
            groupMessages.add(input.obvMessageToPutOnHold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putOneToOneMessageOnHold(OnHoldMessageInput input) {
        HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> hashMap = pendingOneToOneMessages;
        synchronized (hashMap) {
            BytesKey ownedIdentityBytesKey = new BytesKey(input.ownedIdentityBytes);
            HashMap ownedIdentityMap = pendingOneToOneMessages.computeIfAbsent(ownedIdentityBytesKey, k -> new HashMap());
            BytesKey contactBytesKeys = new BytesKey(input.recipientBytes);
            List contactMessages = ownedIdentityMap.computeIfAbsent(contactBytesKeys, k -> new ArrayList());
            contactMessages.add(input.obvMessageToPutOnHold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAllGroupV2MessagesOnHold(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        AppLogger.d("UnknownRecipientObvMessagesHelper::processAllGroupV2MessagesOnHold processing on hold messages");
        HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> hashMap = pendingGroupV2Messages;
        synchronized (hashMap) {
            BytesKey groupIdentifierBytesKey;
            List<ObvMessage> groupMessages;
            BytesKey ownedIdentityBytesKey = new BytesKey(bytesOwnedIdentity);
            HashMap<BytesKey, List<ObvMessage>> ownedIdentityMap = pendingGroupV2Messages.get(ownedIdentityBytesKey);
            if (ownedIdentityMap != null && (groupMessages = ownedIdentityMap.remove(groupIdentifierBytesKey = new BytesKey(bytesGroupIdentifier))) != null) {
                for (ObvMessage obvMessage : groupMessages) {
                    new NewMessageReceivedTask(obvMessage).run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAllOneToOneMessagesOnHold(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        AppLogger.d("UnknownRecipientObvMessagesHelper::processAllGroupV2MessagesOnHold processing on hold messages");
        HashMap<BytesKey, HashMap<BytesKey, List<ObvMessage>>> hashMap = pendingOneToOneMessages;
        synchronized (hashMap) {
            BytesKey contactBytesKey;
            List<ObvMessage> oneToOneMessages;
            BytesKey ownedIdentityBytesKey = new BytesKey(bytesOwnedIdentity);
            HashMap<BytesKey, List<ObvMessage>> ownedIdentityMap = pendingOneToOneMessages.get(ownedIdentityBytesKey);
            if (ownedIdentityMap != null && (oneToOneMessages = ownedIdentityMap.remove(contactBytesKey = new BytesKey(bytesContactIdentity))) != null) {
                for (ObvMessage obvMessage : oneToOneMessages) {
                    new NewMessageReceivedTask(obvMessage).run();
                }
            }
        }
    }

    public static boolean isTooOld(ObvMessage obvMessage) {
        return obvMessage.getLocalDownloadTimestamp() < System.currentTimeMillis() - 172800000L;
    }

    public record OnHoldMessageInput(byte[] ownedIdentityBytes, byte[] recipientBytes, ObvMessage obvMessageToPutOnHold) {
    }
}

