/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.windows.messenger.database.datatypes.json.JsonDeleteDiscussion;
import io.olvid.windows.messenger.database.datatypes.json.JsonDeleteMessages;
import io.olvid.windows.messenger.database.datatypes.json.JsonDiscussionRead;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonLimitedVisibilityMessageOpened;
import io.olvid.windows.messenger.database.datatypes.json.JsonPayload;
import io.olvid.windows.messenger.database.datatypes.json.JsonQuerySharedSettings;
import io.olvid.windows.messenger.database.datatypes.json.JsonReaction;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.datatypes.json.JsonUpdateMessage;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MessagePostHelper {
    public static boolean postUpdateMessageMessageDbTask(OutboundMessage updatedMessage, Discussion discussion) {
        if (updatedMessage == null) {
            AppLogger.e("MessagePostHelper: postUpdateMessageMessage: invalid parameters");
            return false;
        }
        try {
            JsonUpdateMessage jsonUpdateMessage = JsonUpdateMessage.of(discussion, updatedMessage);
            jsonUpdateMessage.setBody(updatedMessage.getBody().orElse(null));
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonUpdateMessage(jsonUpdateMessage);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, true, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postUpdateMessageMessageDbTask: exception raised", e);
            return false;
        }
    }

    public static boolean postUpdateMessageMessageDbTask(OwnedMessage updatedMessage, Discussion discussion) {
        if (updatedMessage == null) {
            AppLogger.e("MessagePostHelper: postUpdateMessageMessage: invalid parameters");
            return false;
        }
        try {
            JsonUpdateMessage jsonUpdateMessage = JsonUpdateMessage.of(discussion, updatedMessage);
            jsonUpdateMessage.setBody(updatedMessage.getBody().orElse(null));
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonUpdateMessage(jsonUpdateMessage);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, true, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postUpdateMessageMessageDbTask: exception raised", e);
            return false;
        }
    }

    public static boolean postReactionMessageDbTask(AbstractUserMessageGenerated<?> message, Discussion discussion, Optional<String> emoji) {
        if (message == null || discussion == null) {
            AppLogger.e("MessagePostHelper: postReactionMessageDbTask: invalid parameters");
            return false;
        }
        try {
            JsonReaction jsonReaction = JsonReaction.of(discussion, message);
            jsonReaction.setReaction(emoji.orElse(null));
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonReaction(jsonReaction);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, true, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postReactionMessageDbTask: exception raised", e);
            return false;
        }
    }

    public static boolean postDiscussionSettingsUpdatedMessageDbTask(Discussion discussion, JsonSharedSettings jsonSharedSettings) {
        if (discussion == null || jsonSharedSettings == null) {
            AppLogger.e("MessagePostHelper: postDiscussionSettingsUpdatedMessageDbTask: invalid parameters");
            return false;
        }
        if (discussion.getGroupId().isPresent() && !GroupHelper.containsPermission(discussion.getGroupId().get(), Either.left(discussion.getOwnedIdentityId()), List.of(GroupV2.Permission.CHANGE_SETTINGS))) {
            return false;
        }
        try {
            jsonSharedSettings.setIdentifier(discussion);
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonSharedSettings(jsonSharedSettings);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, false, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postDiscussionSettingsUpdatedMessageDbTask: exception raised", e);
            return false;
        }
    }

    public static boolean postDiscussionReadMessageDbTask(Discussion discussion, long timestamp) {
        try {
            JsonDiscussionRead discussionRead = JsonDiscussionRead.of(discussion);
            discussionRead.setLastReadMessageServerTimestamp(timestamp);
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonDiscussionRead(discussionRead);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessageToOwnedDevices(messagePayload, discussion, true);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postDiscussionReadMessage: exception raised", e);
            return false;
        }
    }

    public static boolean postLimitedVisibilityMessageOpenedMessage(Discussion discussion, InboundMessage message) {
        try {
            JsonLimitedVisibilityMessageOpened jsonLimitedVisibilityMessageOpened = JsonLimitedVisibilityMessageOpened.of(discussion, message);
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonLimitedVisibilityMessageOpened(jsonLimitedVisibilityMessageOpened);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessageToOwnedDevices(messagePayload, discussion, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postLimitedVisibilityMessageOpenedMessage: exception raised", e);
            return false;
        }
    }

    public static <Message extends AbstractUserMessageGenerated<Message>> boolean postDeleteMessageEverywhereMessageDbTask(Discussion discussion, Message messageToDelete) {
        ArrayList<Message> messageList = new ArrayList<Message>(1);
        messageList.add(messageToDelete);
        return MessagePostHelper.postDeleteMessagesEverywhereMessageDbTask(discussion, messageList);
    }

    public static <Message extends AbstractUserMessageGenerated<?>> boolean postDeleteMessagesEverywhereMessageDbTask(Discussion discussion, List<Message> messages) {
        if (discussion == null || messages == null) {
            AppLogger.e("MessagePostHelper: postDeleteMessagesEverywhereMessageDbTask: invalid params: " + String.valueOf(discussion) + " | " + String.valueOf(messages));
            return false;
        }
        try {
            JsonDeleteMessages jsonDeleteMessages = JsonDeleteMessages.of(discussion, messages);
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonDeleteMessages(jsonDeleteMessages);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, true, false);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postDeleteMessagesEverywhereMessageDbTask: exception raised", e);
            return false;
        }
    }

    public static boolean postDeleteDiscussionEverywhereMessageDbTask(Discussion discussion, boolean onlyOwnedDevice) {
        if (discussion == null) {
            AppLogger.e("MessagePostHelper: postDeleteDiscussionEverywhereMessageDbTask: invalid params");
            return false;
        }
        try {
            JsonDeleteDiscussion jsonDeleteDiscussion = JsonDeleteDiscussion.of(discussion);
            JsonPayload jsonPayload = new JsonPayload();
            jsonPayload.setJsonDeleteDiscussion(jsonDeleteDiscussion);
            byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
            return MessagePostHelper.postMessage(messagePayload, discussion, true, onlyOwnedDevice);
        }
        catch (Exception e) {
            AppLogger.e("MessagePostHelper: postDeleteMessagesEverywhereMessageDbTask: exception raised", e);
            return false;
        }
    }

    private static boolean postMessageToOwnedDevices(byte[] messagePayload, Discussion discussion, boolean hasUserContent) {
        if (discussion == null || messagePayload == null) {
            AppLogger.e("MessagePostHelper: postNoUserContentMessage: invalid params");
            return false;
        }
        ArrayList<byte[]> byteIdentities = new ArrayList<byte[]>();
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        if (DbManager.getInstance().getOwnedDeviceDao().doesOwnedIdentityHaveAnotherDeviceWithChannel(discussion.getOwnedIdentityId())) {
            byteIdentities.add(ownedIdentity.getBytesOwnedIdentity());
        }
        if (byteIdentities.isEmpty()) {
            return true;
        }
        ObvPostMessageOutput postMessageOutput = EngineWrapper.getInstance().post(messagePayload, new ObvOutboundAttachment[0], byteIdentities, ownedIdentity.getBytesOwnedIdentity(), hasUserContent, false);
        return postMessageOutput.isMessagePostedForAtLeastOneContact();
    }

    private static boolean postMessage(byte[] messagePayload, Discussion discussion, boolean hasUserContent, boolean onlyOwnedDevice) {
        List<Contact> contacts;
        if (discussion == null || messagePayload == null) {
            AppLogger.e("MessagePostHelper: postNoUserContentMessage: invalid params");
            return false;
        }
        if (onlyOwnedDevice) {
            contacts = new ArrayList<Contact>();
        } else if (discussion.getGroupId().isPresent()) {
            List contactIds = DbManager.getInstance().getContactGroupJoinDao().getGroupMembersContactIds(discussion.getGroupId().get());
            contacts = DbManager.getInstance().getContactDao().get(contactIds);
        } else if (discussion.getContactId().isPresent()) {
            contacts = new ArrayList(1);
            contacts.add(DbManager.getInstance().getContactDao().get(discussion.getContactId().get()));
        } else {
            if (discussion.isLocked() || discussion.isPreDiscussion()) {
                AppLogger.e("MessagePostHelper: postNoUserContentMessage: trying to post a message in a locked discussion!!!");
                return false;
            }
            AppLogger.e("MessagePostHelper: postNoUserContentMessage: this discussion is not valid for posting: " + String.valueOf(discussion));
            return false;
        }
        ArrayList<byte[]> byteContactIdentities = new ArrayList<byte[]>(contacts.size());
        for (Contact contact : contacts) {
            byteContactIdentities.add(contact.getBytesContactIdentity());
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId());
        if (DbManager.getInstance().getOwnedDeviceDao().doesOwnedIdentityHaveAnotherDeviceWithChannel((Id<OwnedIdentity>)ownedIdentity.getItemId())) {
            byteContactIdentities.add(ownedIdentity.getBytesOwnedIdentity());
        }
        if (byteContactIdentities.isEmpty()) {
            return true;
        }
        ObvPostMessageOutput postMessageOutput = EngineWrapper.getInstance().post(messagePayload, new ObvOutboundAttachment[0], byteContactIdentities, ownedIdentity.getBytesOwnedIdentity(), hasUserContent, false);
        return postMessageOutput.isMessagePostedForAtLeastOneContact();
    }

    public static byte[] buildJsonQuerySharedSettingsPayloadAsBytes(Discussion discussion, Integer knownSharedSettingsVersion, JsonExpiration knownSharedExpiration) throws Exception {
        JsonQuerySharedSettings jsonQuerySharedSettings = JsonQuerySharedSettings.of(discussion);
        jsonQuerySharedSettings.setKnownSharedSettingsVersion(knownSharedSettingsVersion);
        jsonQuerySharedSettings.setKnownSharedExpiration(knownSharedExpiration);
        JsonPayload jsonPayload = new JsonPayload();
        jsonPayload.setJsonQuerySharedSettings(jsonQuerySharedSettings);
        return EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
    }
}

