/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.windows.messenger.database.dao.message.AbstractMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.LocationGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageSequenceIntervalGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public final class MessageHelper {
    public static final Object sortIndexLock = new Object();

    private MessageHelper() {
    }

    public static boolean isEdited(AbstractUserMessageGenerated.Interface<?> message) {
        return List.of(AbstractUserMessageGenerated.EditionStatus.SEEN, AbstractUserMessageGenerated.EditionStatus.UNSEEN).contains(message.getEditionStatus());
    }

    public static Optional<? extends AbstractUserMessageGenerated<?>> get(Id<Discussion> discussionId, JsonMessageReference jsonMessageReference) {
        Optional<InboundMessage> inboundMessage = DbManager.getInstance().getInboundMessageDao().get(discussionId, jsonMessageReference);
        if (inboundMessage.isPresent()) {
            return inboundMessage;
        }
        Optional<OwnedMessage> ownedMessage = DbManager.getInstance().getOwnedMessageDao().get(discussionId, jsonMessageReference);
        if (ownedMessage.isPresent()) {
            return ownedMessage;
        }
        return DbManager.getInstance().getOutboundMessageDao().get(discussionId, jsonMessageReference);
    }

    public static Optional<Double> getNextSortIndex(double minSortIndex, Discussion discussion) {
        Optional<Double> nextInboundSortIndex = DbManager.getInstance().getInboundMessageDao().getNextSortIndex(minSortIndex, discussion);
        Optional<Double> nextOutboundSortIndex = DbManager.getInstance().getOutboundMessageDao().getNextSortIndex(minSortIndex, discussion);
        Optional<Double> nextOwnedSortIndex = DbManager.getInstance().getOwnedMessageDao().getNextSortIndex(minSortIndex, discussion);
        Optional<Double> nextSystemSortIndex = DbManager.getInstance().getSystemMessageDao().getNextSortIndex(minSortIndex, discussion);
        Optional<Double> nextSortIndex = Optional.empty();
        nextSortIndex = OptionalUtils.doubleMin(nextSortIndex, nextInboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMin(nextSortIndex, nextOutboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMin(nextSortIndex, nextOwnedSortIndex);
        nextSortIndex = OptionalUtils.doubleMin(nextSortIndex, nextSystemSortIndex);
        return nextSortIndex;
    }

    public static Optional<Double> getPreviousSortIndex(double maxSortIndex, Discussion discussion) {
        Optional<Double> nextInboundSortIndex = DbManager.getInstance().getInboundMessageDao().getPreviousSortIndex(maxSortIndex, discussion);
        Optional<Double> nextOutboundSortIndex = DbManager.getInstance().getOutboundMessageDao().getPreviousSortIndex(maxSortIndex, discussion);
        Optional<Double> nextOwnedSortIndex = DbManager.getInstance().getOwnedMessageDao().getPreviousSortIndex(maxSortIndex, discussion);
        Optional<Double> nextSystemSortIndex = DbManager.getInstance().getSystemMessageDao().getPreviousSortIndex(maxSortIndex, discussion);
        Optional<Double> nextSortIndex = Optional.empty();
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, nextInboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, nextOutboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, nextOwnedSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, nextSystemSortIndex);
        return nextSortIndex;
    }

    public static Optional<Double> getDiscussionMaxSortIndex(Discussion discussion) {
        Optional<Double> maxInboundSortIndex = DbManager.getInstance().getInboundMessageDao().getDiscussionMaxSortIndex(discussion);
        Optional<Double> maxOutboundSortIndex = DbManager.getInstance().getOutboundMessageDao().getDiscussionMaxSortIndex(discussion);
        Optional<Double> maxOwnedSortIndex = DbManager.getInstance().getOwnedMessageDao().getDiscussionMaxSortIndex(discussion);
        Optional<Double> maxSystemSortIndex = DbManager.getInstance().getSystemMessageDao().getDiscussionMaxSortIndex(discussion);
        Optional<Double> nextSortIndex = Optional.empty();
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, maxInboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, maxOutboundSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, maxOwnedSortIndex);
        nextSortIndex = OptionalUtils.doubleMax(nextSortIndex, maxSystemSortIndex);
        return nextSortIndex;
    }

    public static Optional<Long> countUserMessagesInDiscussion(Discussion discussion) {
        Optional<Long> inboundMessageCount = DbManager.getInstance().getInboundMessageDao().countMessagesInDiscussion(discussion);
        Optional<Long> outboundMessageCount = DbManager.getInstance().getOutboundMessageDao().countMessagesInDiscussion(discussion);
        if (inboundMessageCount.isEmpty() || outboundMessageCount.isEmpty()) {
            return Optional.empty();
        }
        long result = 0L;
        result += inboundMessageCount.get().longValue();
        return Optional.of(result += outboundMessageCount.get().longValue());
    }

    public static Optional<Long> countAllMessagesInDiscussion(Discussion discussion) {
        Optional<Long> userMessageCount = MessageHelper.countUserMessagesInDiscussion(discussion);
        Optional<Long> systemMessageCount = DbManager.getInstance().getSystemMessageDao().countMessagesInDiscussion(discussion);
        if (userMessageCount.isEmpty() || systemMessageCount.isEmpty()) {
            return Optional.empty();
        }
        long result = 0L;
        result += userMessageCount.get().longValue();
        return Optional.of(result += systemMessageCount.get().longValue());
    }

    private static Optional<String> getStringContent(AbstractUserMessageGenerated.WipeStatus wipeStatus, Optional<String> body) {
        if (wipeStatus != null) {
            switch (wipeStatus) {
                case NONE: 
                case WIPE_ON_READ: {
                    break;
                }
                case WIPED: {
                    return Optional.of(ViewControllerHelper.getString("message_content_wiped_label"));
                }
                case REMOTE_DELETED: {
                    return Optional.of(MessageHelper.getRemoteDeletedString(Optional.empty()));
                }
            }
        }
        return body.filter(s -> !StringUtils.isEmpty(s));
    }

    public static Optional<String> getStringContent(AbstractMessageGenerated.Interface<?> message) {
        if (message instanceof SystemMessageGenerated.Interface) {
            SystemMessageGenerated.Interface systemMessage = (SystemMessageGenerated.Interface)message;
            return Optional.of(SystemMessage.getStringContent(systemMessage, Optional.empty(), systemMessage.getTimestamp()));
        }
        if (message instanceof InboundMessageGenerated.Interface) {
            InboundMessageGenerated.Interface inboundMessage = (InboundMessageGenerated.Interface)message;
            if (inboundMessage.isBoxed()) {
                return Optional.of(ViewControllerHelper.getString("message_content_boxed_label"));
            }
            return MessageHelper.getStringContent(inboundMessage.getWipeStatus(), inboundMessage.getBody());
        }
        if (message instanceof OutboundMessageGenerated.Interface) {
            OutboundMessageGenerated.Interface outboundMessage = (OutboundMessageGenerated.Interface)message;
            return MessageHelper.getStringContent(outboundMessage.getWipeStatus(), outboundMessage.getBody());
        }
        if (message instanceof OwnedMessageGenerated.Interface) {
            OwnedMessageGenerated.Interface ownedMessage = (OwnedMessageGenerated.Interface)message;
            return MessageHelper.getStringContent(ownedMessage.getWipeStatus(), ownedMessage.getBody());
        }
        AppLogger.e("Illegal State");
        return Optional.empty();
    }

    public static String getRemoteDeletedString(Optional<IdentityInfo> remoteDeleterOpt) {
        if (remoteDeleterOpt.isEmpty()) {
            return ViewControllerHelper.getString("message_content_remote_deleted_label");
        }
        IdentityInfo remoteDeleter = remoteDeleterOpt.get();
        if (remoteDeleter.isMe()) {
            return ViewControllerHelper.getString("message_content_remote_deleted_label_by_you");
        }
        if (remoteDeleter.getContactInfo().isEmpty()) {
            return ViewControllerHelper.getString("message_content_remote_deleted_label_by_deleted_contact");
        }
        MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("message_content_remote_deleted_label_by"));
        return messageFormat.format(new String[]{remoteDeleter.getContactInfo().get().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)});
    }

    public static String getLocationContent(LocationGenerated.Type type) {
        if (type == null) {
            return ViewControllerHelper.getString("location_message");
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LocationGenerated.Type.SEND -> ViewControllerHelper.getString("message_location_sent");
            case LocationGenerated.Type.SHARE -> ViewControllerHelper.getString("message_sharing_location");
            case LocationGenerated.Type.SHARE_FINISHED -> ViewControllerHelper.getString("message_sharing_location_finished");
        };
    }

    public static Optional<JsonExpiration> getJsonExpirationFromOutbound(Optional<Id<OutboundMessageEphemeralInfo>> infoOpt) {
        if (infoOpt.isEmpty()) {
            return Optional.empty();
        }
        OutboundMessageEphemeralInfo info = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().get(infoOpt.get());
        return Optional.of(MessageHelper.getJsonExpiration(info));
    }

    public static JsonExpiration getJsonExpiration(AbstractMessageEphemeralInfoGenerated<?> info) {
        JsonExpiration expiration = new JsonExpiration();
        expiration.setReadOnce(info.isReadOnce());
        expiration.setVisibilityDuration(info.getVisibilityDuration().orElse(null));
        expiration.setExistenceDuration(info.getExistenceDuration().orElse(null));
        return expiration;
    }

    public static JsonMessage getJsonMessage(OutboundMessage message) {
        Optional<JsonLocation> jsonLocation;
        Optional<JsonExpiration> jsonExpiration;
        JsonMessage jsonMessage = new JsonMessage();
        jsonMessage.body = message.getBody().orElse(null);
        jsonMessage.senderSequenceNumber = message.getSenderSequenceNumber();
        jsonMessage.senderThreadIdentifier = message.getSenderThreadIdentifier();
        if (message.isForwarded()) {
            jsonMessage.setForwarded(true);
        }
        if (message.getReplyToId().isPresent()) {
            MessageRef messageRef = DbManager.getInstance().getMessageRefDao().get(message.getReplyToId().get());
            jsonMessage.jsonReply = messageRef.toJson();
        }
        if ((jsonExpiration = MessageHelper.getJsonExpirationFromOutbound(message.getOutboundMessageEphemeralInfoId())).isPresent()) {
            jsonMessage.setJsonExpiration(jsonExpiration.get());
        }
        if ((jsonLocation = MessageHelper.getJsonLocation(message.getLocationId())).isPresent()) {
            jsonMessage.setJsonLocation(jsonLocation.get());
        }
        return jsonMessage;
    }

    public static Optional<JsonLocation> getJsonLocation(Optional<Id<Location>> loc) {
        if (loc.isEmpty()) {
            return Optional.empty();
        }
        try {
            Location location = DbManager.getInstance().getLocationDao().get(loc.get());
            return Optional.of(location.toJson());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static <Interval extends AbstractMessageSequenceIntervalGenerated<Interval>> long merge(Optional<Interval> previousOpt, long timestamp, double sortIndex, long sequenceNumber, Optional<Interval> nextOpt, AbstractMessageSequenceIntervalDao<Interval, ?> dao, Supplier<Interval> makeInterval) throws SQLException {
        long missingMessageCount = 0L;
        if (previousOpt.isPresent()) {
            AbstractMessageSequenceIntervalGenerated previous = (AbstractMessageSequenceIntervalGenerated)previousOpt.get();
            if (previous.getEndSequenceNumber() + 1L == sequenceNumber) {
                previous.setEndTimestamp(timestamp);
                previous.setEndSortIndex(sortIndex);
                previous.setEndSequenceNumber(sequenceNumber);
                if (nextOpt.isPresent() && ((AbstractMessageSequenceIntervalGenerated)nextOpt.get()).getStartSequenceNumber() - 1L == sequenceNumber) {
                    AbstractMessageSequenceIntervalGenerated after = (AbstractMessageSequenceIntervalGenerated)nextOpt.get();
                    previous.setEndTimestamp(after.getEndTimestamp());
                    previous.setEndSortIndex(after.getEndSortIndex());
                    previous.setEndSequenceNumber(after.getEndSequenceNumber());
                    dao.delete(after);
                }
                dao.update(previous);
                return 0L;
            }
            missingMessageCount = sequenceNumber - previous.getEndSequenceNumber() - 1L;
        }
        if (nextOpt.isPresent() && ((AbstractMessageSequenceIntervalGenerated)nextOpt.get()).getStartSequenceNumber() - 1L == sequenceNumber) {
            AbstractMessageSequenceIntervalGenerated next = (AbstractMessageSequenceIntervalGenerated)nextOpt.get();
            next.setStartTimestamp(timestamp);
            next.setStartSortIndex(sortIndex);
            next.setStartSequenceNumber(sequenceNumber);
            dao.update(next);
            return missingMessageCount;
        }
        dao.insert((AbstractMessageSequenceIntervalGenerated)makeInterval.get());
        return missingMessageCount;
    }

    public static <Interval extends AbstractMessageSequenceIntervalGenerated<Interval>, Message extends ReceivedMessageGenerated<Message>> InsertionInfo computeInsertionInfo(Discussion discussion, Optional<Interval> previousOpt, long timestamp, long sequenceNumber, Optional<Interval> nextOpt, AbstractMessageSequenceIntervalDao<Interval, Message> dao, ReceivedMessageDao<Message, ?, ?> messageDao, BiFunction<Double, Long, Interval> makeInterval) throws SQLException {
        AbstractMessageSequenceIntervalGenerated next;
        Optional<Message> firstMessage;
        double sortIndexResult;
        long timestampResult;
        if (nextOpt.isEmpty() || ((AbstractMessageSequenceIntervalGenerated)nextOpt.get()).getStartTimestamp() > timestamp) {
            if (previousOpt.isEmpty() || ((AbstractMessageSequenceIntervalGenerated)previousOpt.get()).getEndTimestamp() < timestamp) {
                timestampResult = timestamp;
                sortIndexResult = timestamp;
            } else {
                AbstractMessageSequenceIntervalGenerated previous = (AbstractMessageSequenceIntervalGenerated)previousOpt.get();
                double previousSortIndex = previous.getEndSortIndex();
                Optional<Double> nextSortIndex = MessageHelper.getNextSortIndex(previousSortIndex, discussion);
                sortIndex = nextSortIndex.isPresent() ? (previousSortIndex + nextSortIndex.get()) / 2.0 : previousSortIndex + 10.0;
                timestampResult = previous.getEndTimestamp();
                sortIndexResult = sortIndex;
            }
        } else {
            AbstractMessageSequenceIntervalGenerated next2 = (AbstractMessageSequenceIntervalGenerated)nextOpt.get();
            double nextSortIndex = next2.getStartSortIndex();
            Optional<Double> previousSortIndex = MessageHelper.getPreviousSortIndex(nextSortIndex, discussion);
            sortIndex = previousSortIndex.isPresent() ? (nextSortIndex + previousSortIndex.get()) / 2.0 : nextSortIndex - 10.0;
            timestampResult = next2.getStartTimestamp();
            sortIndexResult = sortIndex;
        }
        boolean canUpdateMissingMessageCount = true;
        if (nextOpt.isPresent() && (firstMessage = dao.getFirstMessage(next = (AbstractMessageSequenceIntervalGenerated)nextOpt.get())).isPresent()) {
            ReceivedMessageGenerated message = (ReceivedMessageGenerated)firstMessage.get();
            if (message.getMissedMessageCount() > 0L) {
                long remainingMissingMessageCount = message.getSenderSequenceNumber() - sequenceNumber - 1L;
                messageDao.updateMissedMessageCount((Id<Message>)message.getItemId(), remainingMissingMessageCount);
            } else {
                canUpdateMissingMessageCount = false;
            }
        }
        long missingMessageCount = MessageHelper.merge(previousOpt, timestampResult, sortIndexResult, sequenceNumber, nextOpt, dao, () -> (AbstractMessageSequenceIntervalGenerated)makeInterval.apply(sortIndexResult, timestampResult));
        if (!canUpdateMissingMessageCount) {
            missingMessageCount = 0L;
        }
        return new InsertionInfo(sortIndexResult, timestampResult, missingMessageCount);
    }

    public record InsertionInfo(double sortIndex, long adjustedTimestamp, long missingMessageCount) {
    }
}

