/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.dao.metadata.AbstractMessageMetadataDao;
import io.olvid.windows.messenger.database.dao.reaction.AbstractReactionDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.InboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OwnedMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class MessageDeletionHelper {
    public static <Message extends AbstractMessageGenerated<?>> boolean deleteMessagesDbTask(List<Message> messages, boolean deleteEverywhere) {
        List discussionMessages;
        if (messages.isEmpty()) {
            return true;
        }
        HashSet inboundMessagesId = new HashSet();
        HashSet outboundMessagesId = new HashSet();
        HashSet ownedMessagesId = new HashSet();
        HashSet systemMessagesId = new HashSet();
        HashSet inboundEphemeralMessagesId = new HashSet();
        HashSet outboundEphemeralMessagesId = new HashSet();
        HashSet ownedEphemeralMessagesId = new HashSet();
        HashSet locationId = new HashSet();
        for (AbstractMessageGenerated message : messages) {
            if (message instanceof InboundMessage) {
                InboundMessage inboundMessage = (InboundMessage)message;
                inboundMessagesId.add(inboundMessage.getItemId());
                inboundMessage.getInboundMessageEphemeralInfoId().ifPresent(inboundEphemeralMessagesId::add);
                inboundMessage.getLocationId().ifPresent(locationId::add);
                continue;
            }
            if (message instanceof OutboundMessage) {
                OutboundMessage outboundMessage = (OutboundMessage)message;
                outboundMessagesId.add(outboundMessage.getItemId());
                outboundMessage.getOutboundMessageEphemeralInfoId().ifPresent(outboundEphemeralMessagesId::add);
                outboundMessage.getLocationId().ifPresent(locationId::add);
                continue;
            }
            if (message instanceof OwnedMessage) {
                OwnedMessage ownedMessage = (OwnedMessage)message;
                ownedMessagesId.add(ownedMessage.getItemId());
                ownedMessage.getOwnedMessageEphemeralInfoId().ifPresent(ownedEphemeralMessagesId::add);
                ownedMessage.getLocationId().ifPresent(locationId::add);
                continue;
            }
            if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                systemMessagesId.add(systemMessage.getItemId());
                continue;
            }
            AppLogger.e("Found a message with unexpected type");
        }
        List inboundMessages = DbManager.getInstance().getInboundMessageDao().get(inboundMessagesId);
        List outboundMessages = DbManager.getInstance().getOutboundMessageDao().get(outboundMessagesId);
        List ownedMessages = DbManager.getInstance().getOwnedMessageDao().get(ownedMessagesId);
        List systemMessages = DbManager.getInstance().getSystemMessageDao().get(systemMessagesId);
        if (inboundMessages == null && outboundMessages == null && ownedMessages == null && systemMessages == null) {
            AppLogger.e("MessageService: deleteMessageDbTask: cannot find messages in database");
            return false;
        }
        HashMap discussionToMessages = new HashMap();
        HashMap<Id, Map> unreadMessageDeletedCount = new HashMap<Id, Map>();
        for (Object message : messages) {
            InboundMessage inboundMessage;
            Discussion discussion;
            Id<Discussion> discussionId = ((AbstractMessageGenerated)message).getDiscussionId();
            Optional<Discussion> discussionKey = discussionToMessages.keySet().stream().filter(d -> ((Id)d.getItemId()).equals(discussionId)).findAny();
            if (discussionKey.isPresent()) {
                discussionMessages = (ArrayList<Object>)discussionToMessages.get(discussionKey.get());
                discussion = discussionKey.get();
            } else {
                discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
                discussionMessages = new ArrayList<Object>();
                discussionToMessages.put(discussion, discussionMessages);
            }
            discussionMessages.add(message);
            if (!(message instanceof InboundMessage) || (inboundMessage = (InboundMessage)message).getStatus() != InboundMessageGenerated.Status.UNREAD) continue;
            Map innerMap = unreadMessageDeletedCount.computeIfAbsent(discussion.getOwnedIdentityId(), k -> new HashMap());
            AtomicInteger unreadCount = innerMap.computeIfAbsent(discussionId, k -> new AtomicInteger(0));
            unreadCount.incrementAndGet();
        }
        HashSet<Object> draftToRemoveReplyTo = new HashSet<Object>();
        for (Discussion discussion : discussionToMessages.keySet()) {
            OutboundMessage draft;
            Optional<Id<MessageRef>> draftReplyToIdOpt;
            Optional<OutboundMessage> draftOpt = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)discussion.getItemId());
            if (draftOpt.isEmpty() || (draftReplyToIdOpt = (draft = draftOpt.get()).getReplyToId()).isEmpty()) continue;
            MessageRef draftReplyTo = DbManager.getInstance().getMessageRefDao().get(draftReplyToIdOpt.get());
            AtomicBoolean removeReplyTo = new AtomicBoolean(false);
            draftReplyTo.getInboundMessageId().ifPresent(id -> removeReplyTo.set(inboundMessagesId.contains(id)));
            draftReplyTo.getOutboundMessageId().ifPresent(id -> removeReplyTo.set(outboundMessagesId.contains(id)));
            draftReplyTo.getOwnedMessageId().ifPresent(id -> removeReplyTo.set(ownedMessagesId.contains(id)));
            if (!removeReplyTo.get()) continue;
            draftToRemoveReplyTo.add(draft.getItemId());
        }
        if (deleteEverywhere) {
            Set discussions = discussionToMessages.keySet();
            for (Discussion discussion : discussions) {
                discussionMessages = (List)discussionToMessages.get(discussion);
                List<AbstractUserMessageGenerated> userMessages = discussionMessages.stream().filter(AbstractUserMessageGenerated.class::isInstance).map(m -> (AbstractUserMessageGenerated)m).toList();
                boolean success = MessagePostHelper.postDeleteMessagesEverywhereMessageDbTask(discussion, userMessages);
                if (success) continue;
                AppLogger.e("Cannot post delete messages everywhere");
                return false;
            }
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                DbManager.getInstance().getInboundMessageEphemeralInfoDao().deleteIds(inboundEphemeralMessagesId);
                DbManager.getInstance().getOutboundMessageEphemeralInfoDao().deleteIds(outboundEphemeralMessagesId);
                DbManager.getInstance().getOwnedMessageEphemeralInfoDao().deleteIds(ownedEphemeralMessagesId);
                List<AbstractUserMessageGenerated> messagesWithAttachments = messages.stream().filter(AbstractUserMessageGenerated.class::isInstance).map(m -> (AbstractUserMessageGenerated)m).filter(m -> m.getTotalAttachmentCount() > 0).toList();
                new DeleteAttachmentsDbTask(messagesWithAttachments).run();
                DbManager.getInstance().getLocationDao().deleteIds(locationId);
                HashSet<Object> discussionWithLastMessageDeleted = new HashSet<Object>();
                for (Discussion discussion : discussionToMessages.keySet()) {
                    Id<SystemMessage> systemMessageId;
                    Optional<Id<MessageRef>> lastUserMessageRefId = discussion.getLastUserMessageRefId();
                    Optional<Id<SystemMessage>> lastSystemMessageId = discussion.getLastSystemMessageId();
                    if (lastUserMessageRefId.isPresent()) {
                        Id<MessageRef> messageRefId = lastUserMessageRefId.get();
                        MessageRef messageRef = DbManager.getInstance().getMessageRefDao().get(messageRefId);
                        messageRef.getInboundMessageId().ifPresent(id -> {
                            if (inboundMessagesId.contains(id)) {
                                discussionWithLastMessageDeleted.add(discussion.getItemId());
                            }
                        });
                        messageRef.getOutboundMessageId().ifPresent(id -> {
                            if (outboundMessagesId.contains(id)) {
                                discussionWithLastMessageDeleted.add(discussion.getItemId());
                            }
                        });
                        messageRef.getOwnedMessageId().ifPresent(id -> {
                            if (ownedMessagesId.contains(id)) {
                                discussionWithLastMessageDeleted.add(discussion.getItemId());
                            }
                        });
                        continue;
                    }
                    if (!lastSystemMessageId.isPresent() || !systemMessagesId.contains(systemMessageId = lastSystemMessageId.get())) continue;
                    discussionWithLastMessageDeleted.add(discussion.getItemId());
                }
                DbManager.getInstance().getInboundMessageDao().deleteIds(inboundMessagesId);
                DbManager.getInstance().getOutboundMessageDao().deleteIds(outboundMessagesId);
                DbManager.getInstance().getOwnedMessageDao().deleteIds(ownedMessagesId);
                DbManager.getInstance().getSystemMessageDao().deleteIds(systemMessagesId);
                DbManager.getInstance().getMessageRefDao().notifyChanges();
                for (Id id2 : discussionWithLastMessageDeleted) {
                    Discussion discussion = (Discussion)DbManager.getInstance().getDiscussionDao().get(id2);
                    Optional<AbstractMessageGenerated<?>> lastMessageOpt = DbManager.getInstance().getDiscussionDao().computeLastMessage(discussion, true);
                    if (lastMessageOpt.isPresent()) {
                        DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, lastMessageOpt.get(), false);
                        continue;
                    }
                    DbManager.getInstance().getDiscussionDao().clearLastMessage(discussion);
                }
                for (Id id3 : draftToRemoveReplyTo) {
                    DbManager.getInstance().getOutboundMessageDao().updateDraftReplyTo(id3, Optional.empty());
                }
                for (Id id4 : unreadMessageDeletedCount.keySet()) {
                    Map innerMap = (Map)unreadMessageDeletedCount.get(id4);
                    for (Id discussionId : innerMap.keySet()) {
                        AtomicInteger count = (AtomicInteger)innerMap.get(discussionId);
                        UnreadMessageCountCache.getInstance().decrementUnreadCount(id4, discussionId, count.get());
                    }
                }
                return null;
            });
        }
        catch (SQLException e) {
            AppLogger.e("MessageDeletionHelper: deleteMessageDbTask: Unable to finish transaction, rolling back", e);
            return false;
        }
        return true;
    }

    private static <Message extends AbstractUserMessageGenerated<Message>, Reaction extends AbstractReactionGenerated<Reaction>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, Metadata extends AbstractMessageMetadataGenerated<Metadata>> void wipeUserMessageContentDbTask(List<Message> messages, AbstractUserMessageDao<Message, EphemeralInfo, ?> messageDao, AbstractReactionDao<Message, Reaction> reactionDao, AbstractMessageEphemeralInfoDao<Message, EphemeralInfo> ephemeralInfoDao, AbstractMessageMetadataDao<Message, Metadata> metadataDao, Function<Message, Metadata> createWipeMetadata, AbstractUserMessageGenerated.WipeStatus wipeStatus) {
        for (AbstractUserMessageGenerated message : messages) {
            reactionDao.deleteAllReactionsForMessage(message);
            ephemeralInfoDao.clearReadOnceInfo(message);
            ephemeralInfoDao.clearVisibilityExpirationInfo(message);
            ephemeralInfoDao.deleteInfoIfIrrelevant(message);
            if (message.getLocationId().isPresent()) {
                DbManager.getInstance().getLocationDao().customDeleteById(message.getLocationId().get());
            }
            messageDao.updateWipeStatusAndClearContent((Id<Message>)message.getItemId(), wipeStatus);
            messageDao.updateLinkPreviewInfo((Id<Message>)message.getItemId(), Optional.empty());
            metadataDao.insert((AbstractMessageMetadataGenerated)createWipeMetadata.apply(message));
        }
        new DeleteAttachmentsDbTask(messages).run();
    }

    public static <Message extends AbstractUserMessageGenerated<?>> void wipeMessagesContentDbTask(List<Message> messages) {
        List<InboundMessage> inboundMessages = messages.stream().filter(InboundMessage.class::isInstance).map(InboundMessage.class::cast).toList();
        if (!inboundMessages.isEmpty()) {
            AppLogger.e("Try to wipe an inbound message, this is unexpected");
        }
        List<OutboundMessage> outboundMessages = messages.stream().filter(OutboundMessage.class::isInstance).map(OutboundMessage.class::cast).toList();
        List<OwnedMessage> ownedMessages = messages.stream().filter(OwnedMessage.class::isInstance).map(OwnedMessage.class::cast).toList();
        MessageDeletionHelper.wipeOutboundMessagesContentDbTask(outboundMessages);
        MessageDeletionHelper.wipeOwnedMessagesContentDbTask(ownedMessages);
    }

    public static void wipeOutboundMessagesContentDbTask(List<OutboundMessage> messages) {
        MessageDeletionHelper.wipeUserMessageContentDbTask(messages, DbManager.getInstance().getOutboundMessageDao(), DbManager.getInstance().getOutboundMessageReactionDao(), DbManager.getInstance().getOutboundMessageEphemeralInfoDao(), DbManager.getInstance().getOutboundMessageMetadataDao(), m -> new OutboundMessageMetadata((OutboundMessage)m, OutboundMessageMetadataGenerated.Kind.WIPED, System.currentTimeMillis()), AbstractUserMessageGenerated.WipeStatus.WIPED);
    }

    public static void wipeOwnedMessagesContentDbTask(List<OwnedMessage> messages) {
        MessageDeletionHelper.wipeUserMessageContentDbTask(messages, DbManager.getInstance().getOwnedMessageDao(), DbManager.getInstance().getOwnedMessageReactionDao(), DbManager.getInstance().getOwnedMessageEphemeralInfoDao(), DbManager.getInstance().getOwnedMessageMetadataDao(), m -> new OwnedMessageMetadata((OwnedMessage)m, OwnedMessageMetadataGenerated.Kind.WIPED, System.currentTimeMillis()), AbstractUserMessageGenerated.WipeStatus.WIPED);
    }

    public static void wipeInboundMessageContentAfterARemoteDeleteDbTask(InboundMessage message, IdentityRef sender, long serverTimestamp) {
        MessageDeletionHelper.wipeUserMessageContentDbTask(List.of(message), DbManager.getInstance().getInboundMessageDao(), DbManager.getInstance().getInboundMessageReactionDao(), DbManager.getInstance().getInboundMessageEphemeralInfoDao(), DbManager.getInstance().getInboundMessageMetadataDao(), m -> new InboundMessageMetadata((InboundMessage)m, InboundMessageMetadataGenerated.Kind.REMOTE_DELETED, serverTimestamp, sender), AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED);
        if (message.isBoxed()) {
            DbManager.getInstance().getInboundMessageDao().updateBoxed((Id<InboundMessage>)message.getItemId(), false);
        }
    }

    public static void wipeOutboundMessageContentAfterARemoteDeleteDbTask(OutboundMessage message, IdentityRef sender, long serverTimestamp) {
        MessageDeletionHelper.wipeUserMessageContentDbTask(List.of(message), DbManager.getInstance().getOutboundMessageDao(), DbManager.getInstance().getOutboundMessageReactionDao(), DbManager.getInstance().getOutboundMessageEphemeralInfoDao(), DbManager.getInstance().getOutboundMessageMetadataDao(), m -> new OutboundMessageMetadata((OutboundMessage)m, OutboundMessageMetadataGenerated.Kind.REMOTE_DELETED, serverTimestamp, sender), AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED);
    }

    public static void wipeOwnedMessageContentAfterARemoteDeleteDbTask(OwnedMessage message, IdentityRef sender, long serverTimestamp) {
        MessageDeletionHelper.wipeUserMessageContentDbTask(List.of(message), DbManager.getInstance().getOwnedMessageDao(), DbManager.getInstance().getOwnedMessageReactionDao(), DbManager.getInstance().getOwnedMessageEphemeralInfoDao(), DbManager.getInstance().getOwnedMessageMetadataDao(), m -> new OwnedMessageMetadata((OwnedMessage)m, OwnedMessageMetadataGenerated.Kind.REMOTE_DELETED, serverTimestamp, sender), AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED);
    }

    public static void wipeMessageContentAfterARemoteDeleteDbTask(AbstractUserMessageGenerated<?> message, IdentityRef sender, long serverTimestamp) {
        if (message instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)message;
            MessageDeletionHelper.wipeInboundMessageContentAfterARemoteDeleteDbTask(inboundMessage, sender, serverTimestamp);
        } else if (message instanceof OutboundMessage) {
            OutboundMessage outboundMessage = (OutboundMessage)message;
            MessageDeletionHelper.wipeOutboundMessageContentAfterARemoteDeleteDbTask(outboundMessage, sender, serverTimestamp);
        } else if (message instanceof OwnedMessage) {
            OwnedMessage ownedMessage = (OwnedMessage)message;
            MessageDeletionHelper.wipeOwnedMessageContentAfterARemoteDeleteDbTask(ownedMessage, sender, serverTimestamp);
        } else {
            AppLogger.e("Found unexpected type of message");
        }
    }
}

