/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.fx.misc.OpenGraphHelper;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javafx.scene.image.Image;

public record LinkPreviewInfo(Optional<String> description, boolean isComplete, Optional<Double> imageWidth) {
    public static <Attachment extends AbstractAttachmentGenerated<?>> Optional<LinkPreviewInfo> of(List<Attachment> attachments) {
        for (AbstractAttachmentGenerated attachment : attachments) {
            if (!ImageUtils.isLink(AttachmentUtils.getNonNullMimeType(attachment))) continue;
            Fyle openGraphFyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
            if (!openGraphFyle.isComplete()) {
                return Optional.of(new LinkPreviewInfo(Optional.empty(), false, Optional.empty()));
            }
            Result<OpenGraph, Throwable> openGraphResult = OpenGraphHelper.loadOpenGraph(openGraphFyle.getFilePath());
            if (openGraphResult.isFailure()) {
                return Optional.empty();
            }
            OpenGraph openGraph = openGraphResult.getSuccess();
            byte[] imageBytes = openGraph.getImageBytes();
            String description = StringUtils.isEmpty(openGraph.getDescription()) ? openGraph.getUrl() : openGraph.getDescription();
            if (imageBytes == null) {
                return Optional.of(new LinkPreviewInfo(Optional.ofNullable(description), true, Optional.empty()));
            }
            Image image = new Image((InputStream)new ByteArrayInputStream(imageBytes));
            return Optional.of(new LinkPreviewInfo(Optional.ofNullable(description), true, Optional.of(image.getWidth())));
        }
        return Optional.empty();
    }

    public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind() {
        if (!this.isComplete) {
            return AbstractUserMessageGenerated.LinkPreviewKind.DOWNLOADING;
        }
        if (this.imageWidth.isEmpty()) {
            return AbstractUserMessageGenerated.LinkPreviewKind.PARTIAL;
        }
        return AbstractUserMessageGenerated.LinkPreviewKind.FULL;
    }
}

