/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.helpers;

import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.sync.AppDeviceSnapshot;
import io.olvid.windows.messenger.engine.sync.OwnedIdentityDeviceSnapshot;
import io.olvid.windows.messenger.engine.sync.ProfilePictureKey;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ByteArray;
import io.olvid.windows.messenger.misc.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class BackupApiHelper {
    public static ProfileBackupFetchResult fetchProfileBackupInfo(ByteArray byteArray, String profileSeed) {
        Set<Object> keys;
        List<DeviceInfo> ownedDeviceInfo;
        ObvProfileBackupsForRestore profileBackups = Api.getBackupApi().fetchProfileBackups(byteArray.byteArray(), profileSeed);
        ProfileBackupFetchResult.FetchStatus fetchStatus = ProfileBackupFetchResult.FetchStatus.map(profileBackups.status);
        List<ObvProfileBackupsForRestore.ObvProfileBackupForRestore> list = profileBackups.snapshots;
        if (list == null) {
            list = Collections.emptyList();
        }
        ArrayList<ProfileBackupsInfo> profileBackupsInfoList = new ArrayList<ProfileBackupsInfo>(list.size());
        for (ObvProfileBackupsForRestore.ObvProfileBackupForRestore obvProfileBackupsForRestore : list) {
            Optional<ProfileBackupsInfo.KeycloakInfo> keycloakInfo = BackupApiHelper.getKeycloakInfo(obvProfileBackupsForRestore);
            ProfileBackupsInfo profileBackupInfo = new ProfileBackupsInfo(new ByteArray(obvProfileBackupsForRestore.bytesBackupThreadId), obvProfileBackupsForRestore.version, obvProfileBackupsForRestore.timestamp, obvProfileBackupsForRestore.fromThisDevice, Optional.ofNullable((String)obvProfileBackupsForRestore.additionalInfo.get("device_name")), Optional.ofNullable((String)obvProfileBackupsForRestore.additionalInfo.get("platform")), obvProfileBackupsForRestore.contactCount, obvProfileBackupsForRestore.groupCount, keycloakInfo, obvProfileBackupsForRestore.snapshot, fetchStatus);
            profileBackupsInfoList.add(profileBackupInfo);
        }
        if (profileBackups.deviceList == null) {
            ownedDeviceInfo = Collections.emptyList();
            keys = Collections.emptySet();
        } else {
            ownedDeviceInfo = new ArrayList(profileBackups.deviceList.deviceUidsAndServerInfo.size());
            keys = profileBackups.deviceList.deviceUidsAndServerInfo.keySet();
        }
        for (ObvBytesKey obvBytesKey : keys) {
            ObvOwnedDevice.ServerDeviceInfo serverDeviceInfo = (ObvOwnedDevice.ServerDeviceInfo)profileBackups.deviceList.deviceUidsAndServerInfo.get(obvBytesKey);
            DeviceInfo deviceInfo = new DeviceInfo(serverDeviceInfo.displayName, Optional.ofNullable(obvBytesKey.getBytes()), false, Optional.of(serverDeviceInfo.lastRegistrationTimestamp));
            ownedDeviceInfo.add(deviceInfo);
        }
        return ProfileBackupFetchResult.of(byteArray, fetchStatus, profileBackupsInfoList, ownedDeviceInfo, profileBackups.deviceList != null && profileBackups.deviceList.multiDevice != false);
    }

    private static Optional<ProfileBackupsInfo.KeycloakInfo> getKeycloakInfo(ObvProfileBackupsForRestore.ObvProfileBackupForRestore obvProfileBackupsForRestore) {
        Optional<ProfileBackupsInfo.KeycloakInfo> keycloakInfo = Optional.empty();
        if (obvProfileBackupsForRestore.keycloakServerUrl != null && obvProfileBackupsForRestore.keycloakClientId != null) {
            ProfileBackupsInfo.KeycloakInfo.KeycloakStatus status = ProfileBackupsInfo.KeycloakInfo.KeycloakStatus.map(obvProfileBackupsForRestore.keycloakStatus);
            keycloakInfo = Optional.of(new ProfileBackupsInfo.KeycloakInfo(obvProfileBackupsForRestore.keycloakServerUrl, obvProfileBackupsForRestore.keycloakClientId, Optional.ofNullable(obvProfileBackupsForRestore.keycloakClientSecret), status));
        }
        return keycloakInfo;
    }

    public static DeviceBackupFetchResult fetchDeviceBackupInfos(String serverName, String seed) {
        ObvDeviceBackupForRestore obvDeviceBackupForRestore = Api.getBackupApi().fetchDeviceBackup(serverName, seed);
        DeviceBackupFetchResult.FetchStatus fetchStatus = DeviceBackupFetchResult.FetchStatus.map(obvDeviceBackupForRestore.status);
        List<DeviceBackupInfo> deviceBackupInfoList = List.of();
        ObvSyncSnapshotNode obvSyncSnapshotNode = obvDeviceBackupForRestore.appDeviceBackupSnapshot;
        if (obvSyncSnapshotNode instanceof AppDeviceSnapshot) {
            AppDeviceSnapshot appDeviceSnapshot = (AppDeviceSnapshot)obvSyncSnapshotNode;
            HashMap<ObvBytesKey, OwnedIdentityDeviceSnapshot> ownedIdentityDeviceSnapshotHashMap = appDeviceSnapshot.owned_identities;
            deviceBackupInfoList = obvDeviceBackupForRestore.profiles.stream().map(obvDeviceBackupProfile -> {
                ObvIdentity[] ownedIdentities;
                OwnedIdentityDeviceSnapshot ownedIdentityDeviceSnapshot = (OwnedIdentityDeviceSnapshot)ownedIdentityDeviceSnapshotHashMap.get(new ObvBytesKey(obvDeviceBackupProfile.bytesProfileIdentity));
                if (ownedIdentityDeviceSnapshot == null) {
                    return null;
                }
                Either<String, Object> photoUrlOrKey = obvDeviceBackupProfile.identityDetails.getPhotoUrl() != null ? Either.left(obvDeviceBackupProfile.identityDetails.getPhotoUrl()) : (obvDeviceBackupProfile.identityDetails.getPhotoServerLabel() != null && obvDeviceBackupProfile.identityDetails.getPhotoServerKey() != null ? Either.right(new ProfilePictureKey(obvDeviceBackupProfile.bytesProfileIdentity, obvDeviceBackupProfile.identityDetails.getPhotoServerLabel(), obvDeviceBackupProfile.identityDetails.getPhotoServerKey())) : null);
                try {
                    ownedIdentities = EngineWrapper.getInstance().getOwnedIdentities();
                }
                catch (Exception e) {
                    AppLogger.e("BackupApiHelper::fetchDeviceBackupInfos couldn't load owned identities from engine", e);
                    return null;
                }
                boolean profileAlreadyPresent = Arrays.stream(ownedIdentities).anyMatch(ownedIdentityInfo -> Arrays.equals(ownedIdentityInfo.getBytesIdentity(), obvDeviceBackupProfile.bytesProfileIdentity));
                return new DeviceBackupInfo(new ByteArray(obvDeviceBackupProfile.bytesProfileIdentity), obvDeviceBackupProfile.identityDetails.getIdentityDetails(), Optional.ofNullable(ownedIdentityDeviceSnapshot.custom_name), Optional.ofNullable(photoUrlOrKey), obvDeviceBackupProfile.keycloakManaged, profileAlreadyPresent, obvDeviceBackupProfile.profileBackupSeed);
            }).toList();
        }
        return DeviceBackupFetchResult.of(fetchStatus, deviceBackupInfoList);
    }
}

