/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.groups.tasks;

import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.fx.helpers.JsonHelper;
import io.olvid.windows.messenger.logger.AppLogger;

public class UpdateGroupDetailsDbTask
implements Runnable {
    private final Group group;
    private final JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto;

    public UpdateGroupDetailsDbTask(Group group, JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto) {
        this.group = group;
        this.jsonGroupDetailsWithVersionAndPhoto = jsonGroupDetailsWithVersionAndPhoto;
    }

    @Override
    public void run() {
        if (this.jsonGroupDetailsWithVersionAndPhoto.getGroupDetails().getName() == null) {
            AppLogger.e("UpdateGroupDetailsTask: unable to  update group details if name is null !");
            return;
        }
        if (this.group == null) {
            AppLogger.e("UpdateGroupDetailsTask: received null group");
            return;
        }
        String groupDetails = JsonHelper.jsonGroupDetailsToString(this.jsonGroupDetailsWithVersionAndPhoto.getGroupDetails());
        if (groupDetails == null) {
            AppLogger.e("UpdateGroupDetailsTask: unable to stringify group details");
            return;
        }
        DbManager.getInstance().getGroupDao().updateNamePhotoAndDetails(this.group, this.jsonGroupDetailsWithVersionAndPhoto.getGroupDetails().getName(), this.jsonGroupDetailsWithVersionAndPhoto.getPhotoUrl(), this.jsonGroupDetailsWithVersionAndPhoto.getGroupDetails().getDescription());
    }
}

