/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.groups.tasks;

import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import java.util.Objects;
import java.util.Optional;

public class GroupV2PhotoChangedNotificationHandler
implements Runnable {
    private final OwnedIdentity ownedIdentity;
    private final byte[] bytesGroupIdentifier;

    public GroupV2PhotoChangedNotificationHandler(OwnedIdentity ownedIdentity, byte[] bytesGroupIdentifier) {
        this.ownedIdentity = ownedIdentity;
        this.bytesGroupIdentifier = bytesGroupIdentifier;
    }

    @Override
    public void run() {
        Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.bytesGroupIdentifier);
        ObvGroupV2.ObvGroupV2DetailsAndPhotos detailsAndPhotos = EngineWrapper.getInstance().getGroupV2DetailsAndPhotos(this.ownedIdentity.getBytesOwnedIdentity(), this.bytesGroupIdentifier);
        if (group != null && detailsAndPhotos != null) {
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
            if (GroupHelper.detailsCanBeAutoTrusted(detailsAndPhotos)) {
                try {
                    EngineWrapper.getInstance().trustGroupV2PublishedDetails(this.ownedIdentity.getBytesOwnedIdentity(), this.bytesGroupIdentifier);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (group.getNewPublishedDetails() == GroupGenerated.PublishedDetails.NOTHING_NEW && GroupHelper.userShouldBeNotifiedOfNewPublishedDetails(detailsAndPhotos)) {
                SystemMessage newDetailsMessage = MessageBuilder.createNewPublishedDetailsMessage(discussion, Optional.empty());
                DbManager.getInstance().getSystemMessageDao().insert(newDetailsMessage);
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, newDetailsMessage, false);
            }
            if (!Objects.equals(group.getPhotoUrl().orElse(null), detailsAndPhotos.photoUrl)) {
                group.setPhotoUrl(Optional.ofNullable(detailsAndPhotos.photoUrl));
                DbManager.getInstance().getGroupDao().updatePhotoUrl(this.ownedIdentity, group.getBytesGroupIdentifier(), group.getPhotoUrl());
            }
        }
    }
}

